#include "stdafx.h"

#ifdef VCLINK_STATIC
	#define hInstVCMAIN32 theApp.GetVCMAIN32()
#else
	#include "VCType32.h"
	#include "VCMain32.h"
	extern HMODULE hInstVCMAIN32;
#endif

//============== VCAbort ==============
typedef void (CALLBACK* VCAbortFN) (void);

void WINAPI VCAbort (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAbort");
	if (fp)
	{
		((VCAbortFN)fp)();
	}
}

//============== VCAbortOperation ==============
typedef void (CALLBACK* VCAbortOperationFN) (short*);

void WINAPI VCAbortOperation (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAbortOperation");
	if (fp)
	{
		((VCAbortOperationFN)fp)(iError);
	}
}

//============== VCAddAngularDimensionEntity ==============
typedef void (CALLBACK* VCAddAngularDimensionEntityFN) (short*, short, Point2D, Point2D, Point2D, Point2D);

void WINAPI VCAddAngularDimensionEntity (short* iError, short iSymbolIndex, Point2D dpP0, Point2D dpP1, Point2D dpP2, Point2D dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddAngularDimensionEntity");
	if (fp)
	{
		((VCAddAngularDimensionEntityFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddAngularDimensionEntityBP ==============
typedef void (CALLBACK* VCAddAngularDimensionEntityBPFN) (short*, short, Point2D*, Point2D*, Point2D*, Point2D*);

void WINAPI VCAddAngularDimensionEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0, Point2D* dpP1, Point2D* dpP2, Point2D* dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddAngularDimensionEntityBP");
	if (fp)
	{
		((VCAddAngularDimensionEntityBPFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddArcEntity ==============
typedef void (CALLBACK* VCAddArcEntityFN) (short*, short, Point2D, Point2D, Point2D);

void WINAPI VCAddArcEntity (short* iError, short iSymbolIndex, Point2D dpP0, Point2D dpP1, Point2D dpP2)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddArcEntity");
	if (fp)
	{
		((VCAddArcEntityFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2);
	}
}

//============== VCAddArcEntityBP ==============
typedef void (CALLBACK* VCAddArcEntityBPFN) (short*, short, Point2D*, Point2D*, Point2D*);

void WINAPI VCAddArcEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0, Point2D* dpP1, Point2D* dpP2)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddArcEntityBP");
	if (fp)
	{
		((VCAddArcEntityBPFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2);
	}
}

//============== VCAddAtbDef ==============
typedef void (CALLBACK* VCAddAtbDefFN) (short*, char*, char*, char*);

void WINAPI VCAddAtbDef (short* iError, char* szName, char* Label0, char* Value0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddAtbDef");
	if (fp)
	{
		((VCAddAtbDefFN)fp)(iError, szName, Label0, Value0);
	}
}

//============== VCAddBezierEntity ==============
typedef void (CALLBACK* VCAddBezierEntityFN) (short*, short, Point2D, Point2D, Point2D, Point2D);

void WINAPI VCAddBezierEntity (short* iError, short iSymbolIndex, Point2D dpP0, Point2D dpP1, Point2D dpP2, Point2D dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddBezierEntity");
	if (fp)
	{
		((VCAddBezierEntityFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddBezierEntityBP ==============
typedef void (CALLBACK* VCAddBezierEntityBPFN) (short*, short, Point2D*, Point2D*, Point2D*, Point2D*);

void WINAPI VCAddBezierEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0, Point2D* dpP1, Point2D* dpP2, Point2D* dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddBezierEntityBP");
	if (fp)
	{
		((VCAddBezierEntityBPFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddCircleEntity ==============
typedef void (CALLBACK* VCAddCircleEntityFN) (short*, short, Point2D, Point2D);

void WINAPI VCAddCircleEntity (short* iError, short iSymbolIndex, Point2D dpP0, Point2D dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddCircleEntity");
	if (fp)
	{
		((VCAddCircleEntityFN)fp)(iError, iSymbolIndex, dpP0, dpP1);
	}
}

//============== VCAddCircleEntityBP ==============
typedef void (CALLBACK* VCAddCircleEntityBPFN) (short*, short, Point2D*, Point2D*);

void WINAPI VCAddCircleEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0, Point2D* dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddCircleEntityBP");
	if (fp)
	{
		((VCAddCircleEntityBPFN)fp)(iError, iSymbolIndex, dpP0, dpP1);
	}
}

//============== VCAddContinuousBezierEntity ==============
typedef void (CALLBACK* VCAddContinuousBezierEntityFN) (short*, short);

void WINAPI VCAddContinuousBezierEntity (short* iError, short iSymbolIndex)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddContinuousBezierEntity");
	if (fp)
	{
		((VCAddContinuousBezierEntityFN)fp)(iError, iSymbolIndex);
	}
}

//============== VCAddContinuousLine3DEntity ==============
typedef void (CALLBACK* VCAddContinuousLine3DEntityFN) (short*, short);

void WINAPI VCAddContinuousLine3DEntity (short* iError, short iSymbolIndex)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddContinuousLine3DEntity");
	if (fp)
	{
		((VCAddContinuousLine3DEntityFN)fp)(iError, iSymbolIndex);
	}
}

//============== VCAddContinuousLineEntity ==============
typedef void (CALLBACK* VCAddContinuousLineEntityFN) (short*, short);

void WINAPI VCAddContinuousLineEntity (short* iError, short iSymbolIndex)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddContinuousLineEntity");
	if (fp)
	{
		((VCAddContinuousLineEntityFN)fp)(iError, iSymbolIndex);
	}
}

//============== VCAddCurrentEntityUserDataByte ==============
typedef void (CALLBACK* VCAddCurrentEntityUserDataByteFN) (short*, BYTE);

void WINAPI VCAddCurrentEntityUserDataByte (short* iError, BYTE b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddCurrentEntityUserDataByte");
	if (fp)
	{
		((VCAddCurrentEntityUserDataByteFN)fp)(iError, b);
	}
}

//============== VCAddCurrentEntityUserDataChunk ==============
typedef void (CALLBACK* VCAddCurrentEntityUserDataChunkFN) (short*, void*, short);

void WINAPI VCAddCurrentEntityUserDataChunk (short* iError, void* p, short iSize)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddCurrentEntityUserDataChunk");
	if (fp)
	{
		((VCAddCurrentEntityUserDataChunkFN)fp)(iError, p, iSize);
	}
}

//============== VCAddCurrentEntityUserDataDouble ==============
typedef void (CALLBACK* VCAddCurrentEntityUserDataDoubleFN) (short*, double);

void WINAPI VCAddCurrentEntityUserDataDouble (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddCurrentEntityUserDataDouble");
	if (fp)
	{
		((VCAddCurrentEntityUserDataDoubleFN)fp)(iError, dRet);
	}
}

//============== VCAddCurrentEntityUserDataFloat ==============
typedef void (CALLBACK* VCAddCurrentEntityUserDataFloatFN) (short*, float);

void WINAPI VCAddCurrentEntityUserDataFloat (short* iError, float f)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddCurrentEntityUserDataFloat");
	if (fp)
	{
		((VCAddCurrentEntityUserDataFloatFN)fp)(iError, f);
	}
}

//============== VCAddCurrentEntityUserDataLong ==============
typedef void (CALLBACK* VCAddCurrentEntityUserDataLongFN) (short*, long);

void WINAPI VCAddCurrentEntityUserDataLong (short* iError, long l)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddCurrentEntityUserDataLong");
	if (fp)
	{
		((VCAddCurrentEntityUserDataLongFN)fp)(iError, l);
	}
}

//============== VCAddCurrentEntityUserDataShort ==============
typedef void (CALLBACK* VCAddCurrentEntityUserDataShortFN) (short*, short);

void WINAPI VCAddCurrentEntityUserDataShort (short* iError, short s)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddCurrentEntityUserDataShort");
	if (fp)
	{
		((VCAddCurrentEntityUserDataShortFN)fp)(iError, s);
	}
}

//============== VCAddCurrentEntityUserDataString ==============
typedef void (CALLBACK* VCAddCurrentEntityUserDataStringFN) (short*, char*);

void WINAPI VCAddCurrentEntityUserDataString (short* iError, char* str)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddCurrentEntityUserDataString");
	if (fp)
	{
		((VCAddCurrentEntityUserDataStringFN)fp)(iError, str);
	}
}

//============== VCAddDiameterDimensionEntity ==============
typedef void (CALLBACK* VCAddDiameterDimensionEntityFN) (short*, short, Point2D, Point2D, Point2D, Point2D);

void WINAPI VCAddDiameterDimensionEntity (short* iError, short iSymbolIndex, Point2D dpP0, Point2D dpP1, Point2D dpP2, Point2D dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddDiameterDimensionEntity");
	if (fp)
	{
		((VCAddDiameterDimensionEntityFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddDiameterDimensionEntityBP ==============
typedef void (CALLBACK* VCAddDiameterDimensionEntityBPFN) (short*, short, Point2D*, Point2D*, Point2D*, Point2D*);

void WINAPI VCAddDiameterDimensionEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0, Point2D* dpP1, Point2D* dpP2, Point2D* dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddDiameterDimensionEntityBP");
	if (fp)
	{
		((VCAddDiameterDimensionEntityBPFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddEllipseEntity ==============
typedef void (CALLBACK* VCAddEllipseEntityFN) (short*, short, Point2D, Point2D, Point2D, Point2D);

void WINAPI VCAddEllipseEntity (short* iError, short iSymbolIndex, Point2D dpP0, Point2D dpP1, Point2D dpP2, Point2D dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddEllipseEntity");
	if (fp)
	{
		((VCAddEllipseEntityFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddEllipseEntityBP ==============
typedef void (CALLBACK* VCAddEllipseEntityBPFN) (short*, short, Point2D*, Point2D*, Point2D*, Point2D*);

void WINAPI VCAddEllipseEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0, Point2D* dpP1, Point2D* dpP2, Point2D* dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddEllipseEntityBP");
	if (fp)
	{
		((VCAddEllipseEntityBPFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddEllipticalArcEntity ==============
typedef void (CALLBACK* VCAddEllipticalArcEntityFN) (short*, short, Point2D, Point2D, Point2D, Point2D, Point2D, Point2D, Point2D);

void WINAPI VCAddEllipticalArcEntity (short* iError, short iSymbolIndex, Point2D dpP0, Point2D dpP1, Point2D dpP2, Point2D dpP3, Point2D dpP4, Point2D dpP5, Point2D dpP6)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddEllipticalArcEntity");
	if (fp)
	{
		((VCAddEllipticalArcEntityFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3, dpP4, dpP5, dpP6);
	}
}

//============== VCAddEllipticalArcEntityBP ==============
typedef void (CALLBACK* VCAddEllipticalArcEntityBPFN) (short*, short, Point2D*, Point2D*, Point2D*, Point2D*, Point2D*, Point2D*, Point2D*);

void WINAPI VCAddEllipticalArcEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0, Point2D* dpP1, Point2D* dpP2, Point2D* dpP3, Point2D* dpP4, Point2D* dpP5, Point2D* dpP6)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddEllipticalArcEntityBP");
	if (fp)
	{
		((VCAddEllipticalArcEntityBPFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3, dpP4, dpP5, dpP6);
	}
}

//============== VCAddEmbAtb ==============
typedef void (CALLBACK* VCAddEmbAtbFN) (short*, short, char*, char*, char*);

void WINAPI VCAddEmbAtb (short* iError, short iWhichSymbolDef, char* szName, char* Label0, char* Value0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddEmbAtb");
	if (fp)
	{
		((VCAddEmbAtbFN)fp)(iError, iWhichSymbolDef, szName, Label0, Value0);
	}
}

//============== VCAddFillEntity ==============
typedef void (CALLBACK* VCAddFillEntityFN) (short*, short);

void WINAPI VCAddFillEntity (short* iError, short iSymbolIndex)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddFillEntity");
	if (fp)
	{
		((VCAddFillEntityFN)fp)(iError, iSymbolIndex);
	}
}

//============== VCAddHatchEntity ==============
typedef void (CALLBACK* VCAddHatchEntityFN) (short*, short);

void WINAPI VCAddHatchEntity (short* iError, short iSymbolIndex)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddHatchEntity");
	if (fp)
	{
		((VCAddHatchEntityFN)fp)(iError, iSymbolIndex);
	}
}

//============== VCAddLeaderEntity ==============
typedef void (CALLBACK* VCAddLeaderEntityFN) (short*, short, Point2D*, short);

void WINAPI VCAddLeaderEntity (short* iError, short iSymbolIndex, Point2D* P, short iPointCount)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddLeaderEntity");
	if (fp)
	{
		((VCAddLeaderEntityFN)fp)(iError, iSymbolIndex, P, iPointCount);
	}
}

//============== VCAddLine3D ==============
typedef void (CALLBACK* VCAddLine3DFN) (short*, short, Point3D*, Point3D*);

void WINAPI VCAddLine3D (short* iError, short iSymbolIndex, Point3D* dpP0, Point3D* dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddLine3D");
	if (fp)
	{
		((VCAddLine3DFN)fp)(iError, iSymbolIndex, dpP0, dpP1);
	}
}

//============== VCAddLineEntity ==============
typedef void (CALLBACK* VCAddLineEntityFN) (short*, short, Point2D, Point2D);

void WINAPI VCAddLineEntity (short* iError, short iSymbolIndex, Point2D dpP0, Point2D dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddLineEntity");
	if (fp)
	{
		((VCAddLineEntityFN)fp)(iError, iSymbolIndex, dpP0, dpP1);
	}
}

//============== VCAddLineEntityBP ==============
typedef void (CALLBACK* VCAddLineEntityBPFN) (short*, short, Point2D*, Point2D*);

void WINAPI VCAddLineEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0, Point2D* dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddLineEntityBP");
	if (fp)
	{
		((VCAddLineEntityBPFN)fp)(iError, iSymbolIndex, dpP0, dpP1);
	}
}

//============== VCAddLineType ==============
typedef short (CALLBACK* VCAddLineTypeFN) (short*, char*, short, short, double*);

short WINAPI VCAddLineType (short* iError, char* pName, short bCode, short iDashCount, double* pDashes)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddLineType");
	if (fp)
	{
		return ((VCAddLineTypeFN)fp)(iError, pName, bCode, iDashCount, pDashes);
	}
	return iRet;
}

//============== VCAddLinearDimensionEntity ==============
typedef void (CALLBACK* VCAddLinearDimensionEntityFN) (short*, short, Point2D, Point2D, Point2D, Point2D);

void WINAPI VCAddLinearDimensionEntity (short* iError, short iSymbolIndex, Point2D dpP0, Point2D dpP1, Point2D dpP2, Point2D dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddLinearDimensionEntity");
	if (fp)
	{
		((VCAddLinearDimensionEntityFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddLinearDimensionEntityBP ==============
typedef void (CALLBACK* VCAddLinearDimensionEntityBPFN) (short*, short, Point2D*, Point2D*, Point2D*, Point2D*);

void WINAPI VCAddLinearDimensionEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0, Point2D* dpP1, Point2D* dpP2, Point2D* dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddLinearDimensionEntityBP");
	if (fp)
	{
		((VCAddLinearDimensionEntityBPFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddNamedLayer ==============
typedef short (CALLBACK* VCAddNamedLayerFN) (short*, char*);

short WINAPI VCAddNamedLayer (short* iError, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddNamedLayer");
	if (fp)
	{
		return ((VCAddNamedLayerFN)fp)(iError, pName);
	}
	return iRet;
}

//============== VCAddPoint3D ==============
typedef void (CALLBACK* VCAddPoint3DFN) (short*, short, Point3D*);

void WINAPI VCAddPoint3D (short* iError, short iSymbolIndex, Point3D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddPoint3D");
	if (fp)
	{
		((VCAddPoint3DFN)fp)(iError, iSymbolIndex, dpP);
	}
}

//============== VCAddPointEntity ==============
typedef void (CALLBACK* VCAddPointEntityFN) (short*, short, Point2D);

void WINAPI VCAddPointEntity (short* iError, short iSymbolIndex, Point2D dpP0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddPointEntity");
	if (fp)
	{
		((VCAddPointEntityFN)fp)(iError, iSymbolIndex, dpP0);
	}
}

//============== VCAddPointEntityBP ==============
typedef void (CALLBACK* VCAddPointEntityBPFN) (short*, short, Point2D*);

void WINAPI VCAddPointEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddPointEntityBP");
	if (fp)
	{
		((VCAddPointEntityBPFN)fp)(iError, iSymbolIndex, dpP0);
	}
}

//============== VCAddPolygon3D ==============
typedef void (CALLBACK* VCAddPolygon3DFN) (short*, short, Point3D*, short);

void WINAPI VCAddPolygon3D (short* iError, short iSymbolIndex, Point3D* dpP, short iNumPnts)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddPolygon3D");
	if (fp)
	{
		((VCAddPolygon3DFN)fp)(iError, iSymbolIndex, dpP, iNumPnts);
	}
}

//============== VCAddRadialDimensionEntity ==============
typedef void (CALLBACK* VCAddRadialDimensionEntityFN) (short*, short, Point2D, Point2D, Point2D, Point2D);

void WINAPI VCAddRadialDimensionEntity (short* iError, short iSymbolIndex, Point2D dpP0, Point2D dpP1, Point2D dpP2, Point2D dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddRadialDimensionEntity");
	if (fp)
	{
		((VCAddRadialDimensionEntityFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddRadialDimensionEntityBP ==============
typedef void (CALLBACK* VCAddRadialDimensionEntityBPFN) (short*, short, Point2D*, Point2D*, Point2D*, Point2D*);

void WINAPI VCAddRadialDimensionEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0, Point2D* dpP1, Point2D* dpP2, Point2D* dpP3)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddRadialDimensionEntityBP");
	if (fp)
	{
		((VCAddRadialDimensionEntityBPFN)fp)(iError, iSymbolIndex, dpP0, dpP1, dpP2, dpP3);
	}
}

//============== VCAddRefFrameEntity ==============
typedef void (CALLBACK* VCAddRefFrameEntityFN) (short*, short, Point2D*);

void WINAPI VCAddRefFrameEntity (short* iError, short iSymbolIndex, Point2D* dpP0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddRefFrameEntity");
	if (fp)
	{
		((VCAddRefFrameEntityFN)fp)(iError, iSymbolIndex, dpP0);
	}
}

//============== VCAddSplineEntity ==============
typedef void (CALLBACK* VCAddSplineEntityFN) (short*, short);

void WINAPI VCAddSplineEntity (short* iError, short iSymbolIndex)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddSplineEntity");
	if (fp)
	{
		((VCAddSplineEntityFN)fp)(iError, iSymbolIndex);
	}
}

//============== VCAddSymbol3DEntity ==============
typedef void (CALLBACK* VCAddSymbol3DEntityFN) (short*, short, Point3D*);

void WINAPI VCAddSymbol3DEntity (short* iError, short iSymbolIndex, Point3D* dpP0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddSymbol3DEntity");
	if (fp)
	{
		((VCAddSymbol3DEntityFN)fp)(iError, iSymbolIndex, dpP0);
	}
}

//============== VCAddSymbolEntity ==============
typedef void (CALLBACK* VCAddSymbolEntityFN) (short*, short, Point2D);

void WINAPI VCAddSymbolEntity (short* iError, short iSymbolIndex, Point2D dpP0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddSymbolEntity");
	if (fp)
	{
		((VCAddSymbolEntityFN)fp)(iError, iSymbolIndex, dpP0);
	}
}

//============== VCAddSymbolEntityBP ==============
typedef void (CALLBACK* VCAddSymbolEntityBPFN) (short*, short, Point2D*);

void WINAPI VCAddSymbolEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddSymbolEntityBP");
	if (fp)
	{
		((VCAddSymbolEntityBPFN)fp)(iError, iSymbolIndex, dpP0);
	}
}

//============== VCAddTextEntity ==============
typedef void (CALLBACK* VCAddTextEntityFN) (short*, short, Point2D);

void WINAPI VCAddTextEntity (short* iError, short iSymbolIndex, Point2D dpP0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddTextEntity");
	if (fp)
	{
		((VCAddTextEntityFN)fp)(iError, iSymbolIndex, dpP0);
	}
}

//============== VCAddTextEntityBP ==============
typedef void (CALLBACK* VCAddTextEntityBPFN) (short*, short, Point2D*);

void WINAPI VCAddTextEntityBP (short* iError, short iSymbolIndex, Point2D* dpP0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddTextEntityBP");
	if (fp)
	{
		((VCAddTextEntityBPFN)fp)(iError, iSymbolIndex, dpP0);
	}
}

//============== VCAngleToString ==============
typedef short (CALLBACK* VCAngleToStringFN) (short*, char*, double*);

short WINAPI VCAngleToString (short* iError, char* pS, double* pA)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAngleToString");
	if (fp)
	{
		return ((VCAngleToStringFN)fp)(iError, pS, pA);
	}
	return iRet;
}

//============== VCAppExit ==============
typedef void (CALLBACK* VCAppExitFN) (short*);

void WINAPI VCAppExit (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAppExit");
	if (fp)
	{
		((VCAppExitFN)fp)(iError);
	}
}

//============== VCApplySettingsToCurrentEntity ==============
typedef void (CALLBACK* VCApplySettingsToCurrentEntityFN) (short*);

void WINAPI VCApplySettingsToCurrentEntity (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCApplySettingsToCurrentEntity");
	if (fp)
	{
		((VCApplySettingsToCurrentEntityFN)fp)(iError);
	}
}

//============== VCAuditUIDS ==============
typedef long (CALLBACK* VCAuditUIDSFN) (short*);

long WINAPI VCAuditUIDS (short* iError)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAuditUIDS");
	if (fp)
	{
		return ((VCAuditUIDSFN)fp)(iError);
	}
	return lRet;
}

//============== VCBeginOperation ==============
typedef void (CALLBACK* VCBeginOperationFN) (short*);

void WINAPI VCBeginOperation (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCBeginOperation");
	if (fp)
	{
		((VCBeginOperationFN)fp)(iError);
	}
}

//============== VCButton ==============
typedef void (CALLBACK* VCButtonFN) (short, short);

void WINAPI VCButton (short iButton, short iState)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCButton");
	if (fp)
	{
		((VCButtonFN)fp)(iButton, iState);
	}
}

//============== VCChangeView ==============
typedef void (CALLBACK* VCChangeViewFN) (short*, long);

void WINAPI VCChangeView (short* iError, long hWnd_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCChangeView");
	if (fp)
	{
		((VCChangeViewFN)fp)(iError, hWnd_);
	}
}

//============== VCChangeView3D ==============
typedef void (CALLBACK* VCChangeView3DFN) (short*, short, double);

void WINAPI VCChangeView3D (short* iError, short iCode, double dFact)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCChangeView3D");
	if (fp)
	{
		((VCChangeView3DFN)fp)(iError, iCode, dFact);
	}
}

//============== VCChar ==============
typedef void (CALLBACK* VCCharFN) (short);

void WINAPI VCChar (short c)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCChar");
	if (fp)
	{
		((VCCharFN)fp)(c);
	}
}

//============== VCClearAlertApp ==============
typedef void (CALLBACK* VCClearAlertAppFN) (short*, long);

void WINAPI VCClearAlertApp (short* iError, long hWnd)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCClearAlertApp");
	if (fp)
	{
		((VCClearAlertAppFN)fp)(iError, hWnd);
	}
}

//============== VCClearAlertAppDll ==============
typedef void (CALLBACK* VCClearAlertAppDllFN) (short*, char*, char*);

void WINAPI VCClearAlertAppDll (short* iError, char* DllName, char* NativeCmd)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCClearAlertAppDll");
	if (fp)
	{
		((VCClearAlertAppDllFN)fp)(iError, DllName, NativeCmd);
	}
}

//============== VCClearLayerProperties ==============
typedef void (CALLBACK* VCClearLayerPropertiesFN) (short*, short);

void WINAPI VCClearLayerProperties (short* iError, short iLayer)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCClearLayerProperties");
	if (fp)
	{
		((VCClearLayerPropertiesFN)fp)(iError, iLayer);
	}
}

//============== VCClearScreen ==============
typedef void (CALLBACK* VCClearScreenFN) (void);

void WINAPI VCClearScreen (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCClearScreen");
	if (fp)
	{
		((VCClearScreenFN)fp)();
	}
}

//============== VCClearSelection ==============
typedef void (CALLBACK* VCClearSelectionFN) (void);

void WINAPI VCClearSelection (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCClearSelection");
	if (fp)
	{
		((VCClearSelectionFN)fp)();
	}
}

//============== VCClose ==============
typedef void (CALLBACK* VCCloseFN) (WORLDHANDLE);

void WINAPI VCClose (WORLDHANDLE hW)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCClose");
	if (fp)
	{
		((VCCloseFN)fp)(hW);
	}
}

//============== VCCloseContour ==============
typedef void (CALLBACK* VCCloseContourFN) (void);

void WINAPI VCCloseContour (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCloseContour");
	if (fp)
	{
		((VCCloseContourFN)fp)();
	}
}

//============== VCComputeArcMid ==============
typedef void (CALLBACK* VCComputeArcMidFN) (Point2D*, Point2D*, Point2D*, Point2D*, Point2D*);

void WINAPI VCComputeArcMid (Point2D* dpC, Point2D* dpP0, Point2D* dpP2, Point2D* dpPreviousMid, Point2D* dpRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCComputeArcMid");
	if (fp)
	{
		((VCComputeArcMidFN)fp)(dpC, dpP0, dpP2, dpPreviousMid, dpRet);
	}
}

//============== VCComputeIntersection ==============
typedef void (CALLBACK* VCComputeIntersectionFN) (short*, ENTITYHANDLE, ENTITYHANDLE, Point2D*, Point2D*);

void WINAPI VCComputeIntersection (short* iError, ENTITYHANDLE l0, ENTITYHANDLE l1, Point2D* dpPick, Point2D* dpIntersect)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCComputeIntersection");
	if (fp)
	{
		((VCComputeIntersectionFN)fp)(iError, l0, l1, dpPick, dpIntersect);
	}
}

//============== VCCopy ==============
typedef void (CALLBACK* VCCopyFN) (void);

void WINAPI VCCopy (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCopy");
	if (fp)
	{
		((VCCopyFN)fp)();
	}
}

//============== VCCreateGraphicHandle ==============
typedef GRAPHICHANDLE (CALLBACK* VCCreateGraphicHandleFN) (short*);

GRAPHICHANDLE WINAPI VCCreateGraphicHandle (short* iError)
{
	GRAPHICHANDLE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCreateGraphicHandle");
	if (fp)
	{
		return ((VCCreateGraphicHandleFN)fp)(iError);
	}
	return iRet;
}

//============== VCCreateMDIWindow ==============
typedef vbool (CALLBACK* VCCreateMDIWindowFN) (short*, short);

vbool WINAPI VCCreateMDIWindow (short* iError, short iNewMDIWindow)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCreateMDIWindow");
	if (fp)
	{
		return ((VCCreateMDIWindowFN)fp)(iError, iNewMDIWindow);
	}
	return vbRet;
}

//============== VCCreateSymbolDef ==============
typedef short (CALLBACK* VCCreateSymbolDefFN) (short*, char*);

short WINAPI VCCreateSymbolDef (short* iError, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCreateSymbolDef");
	if (fp)
	{
		return ((VCCreateSymbolDefFN)fp)(iError, pName);
	}
	return iRet;
}

//============== VCCreateSymbolFromSelection ==============
typedef void (CALLBACK* VCCreateSymbolFromSelectionFN) (short*, char*, Point2D);

void WINAPI VCCreateSymbolFromSelection (short* iError, char* szName, Point2D dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCreateSymbolFromSelection");
	if (fp)
	{
		((VCCreateSymbolFromSelectionFN)fp)(iError, szName, dpP);
	}
}

//============== VCCrossingSelect ==============
typedef void (CALLBACK* VCCrossingSelectFN) (Point2D*, Point2D*);

void WINAPI VCCrossingSelect (Point2D* dpP0, Point2D* dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCrossingSelect");
	if (fp)
	{
		((VCCrossingSelectFN)fp)(dpP0, dpP1);
	}
}

//============== VCCurEntAtbAttach ==============
typedef void (CALLBACK* VCCurEntAtbAttachFN) (short*, char*, Point2D*);

void WINAPI VCCurEntAtbAttach (short* iError, char* szAtbName, Point2D* dpRef)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCurEntAtbAttach");
	if (fp)
	{
		((VCCurEntAtbAttachFN)fp)(iError, szAtbName, dpRef);
	}
}

//============== VCCurEntAtbDelete ==============
typedef void (CALLBACK* VCCurEntAtbDeleteFN) (short*, short);

void WINAPI VCCurEntAtbDelete (short* iError, short iWhichAtb)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCurEntAtbDelete");
	if (fp)
	{
		((VCCurEntAtbDeleteFN)fp)(iError, iWhichAtb);
	}
}

//============== VCCut ==============
typedef void (CALLBACK* VCCutFN) (void);

void WINAPI VCCut (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCut");
	if (fp)
	{
		((VCCutFN)fp)();
	}
}

//============== VCDeSelectAll ==============
typedef void (CALLBACK* VCDeSelectAllFN) (void);

void WINAPI VCDeSelectAll (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDeSelectAll");
	if (fp)
	{
		((VCDeSelectAllFN)fp)();
	}
}

//============== VCDeleteAtbDef ==============
typedef void (CALLBACK* VCDeleteAtbDefFN) (short*, char*);

void WINAPI VCDeleteAtbDef (short* iError, char* szName)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDeleteAtbDef");
	if (fp)
	{
		((VCDeleteAtbDefFN)fp)(iError, szName);
	}
}

//============== VCDeleteCurrentEntityUserData ==============
typedef void (CALLBACK* VCDeleteCurrentEntityUserDataFN) (short*, short);

void WINAPI VCDeleteCurrentEntityUserData (short* iError, short iIndex)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDeleteCurrentEntityUserData");
	if (fp)
	{
		((VCDeleteCurrentEntityUserDataFN)fp)(iError, iIndex);
	}
}

//============== VCDeleteEmbAtb ==============
typedef void (CALLBACK* VCDeleteEmbAtbFN) (short*, short, short);

void WINAPI VCDeleteEmbAtb (short* iError, short iWhichSymbolDef, short iWhichAtb)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDeleteEmbAtb");
	if (fp)
	{
		((VCDeleteEmbAtbFN)fp)(iError, iWhichSymbolDef, iWhichAtb);
	}
}

//============== VCDeleteGraphicHandle ==============
typedef void (CALLBACK* VCDeleteGraphicHandleFN) (short*, GRAPHICHANDLE);

void WINAPI VCDeleteGraphicHandle (short* iError, GRAPHICHANDLE hG)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDeleteGraphicHandle");
	if (fp)
	{
		((VCDeleteGraphicHandleFN)fp)(iError, hG);
	}
}

//============== VCDestroyWorld ==============
typedef void (CALLBACK* VCDestroyWorldFN) (WORLDHANDLE);

void WINAPI VCDestroyWorld (WORLDHANDLE hW)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDestroyWorld");
	if (fp)
	{
		((VCDestroyWorldFN)fp)(hW);
	}
}

//============== VCDigPoint ==============
typedef void (CALLBACK* VCDigPointFN) (lPoint2D, short, short);

void WINAPI VCDigPoint (lPoint2D lpt, short bButtonNum, short bButtonState)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDigPoint");
	if (fp)
	{
		((VCDigPointFN)fp)(lpt, bButtonNum, bButtonState);
	}
}

//============== VCDimDirectionMode ==============
typedef void (CALLBACK* VCDimDirectionModeFN) (short);

void WINAPI VCDimDirectionMode (short iMode)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDimDirectionMode");
	if (fp)
	{
		((VCDimDirectionModeFN)fp)(iMode);
	}
}

//============== VCDimGetDimExtStretch ==============
typedef short (CALLBACK* VCDimGetDimExtStretchFN) (short*);

short WINAPI VCDimGetDimExtStretch (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDimGetDimExtStretch");
	if (fp)
	{
		return ((VCDimGetDimExtStretchFN)fp)(iError);
	}
	return iRet;
}

//============== VCDimGetDimMode ==============
typedef short (CALLBACK* VCDimGetDimModeFN) (short*);

short WINAPI VCDimGetDimMode (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDimGetDimMode");
	if (fp)
	{
		return ((VCDimGetDimModeFN)fp)(iError);
	}
	return iRet;
}

//============== VCDimGetDimProximity ==============
typedef short (CALLBACK* VCDimGetDimProximityFN) (short*);

short WINAPI VCDimGetDimProximity (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDimGetDimProximity");
	if (fp)
	{
		return ((VCDimGetDimProximityFN)fp)(iError);
	}
	return iRet;
}

//============== VCDimSetDimExtStretch ==============
typedef void (CALLBACK* VCDimSetDimExtStretchFN) (short*, short);

void WINAPI VCDimSetDimExtStretch (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDimSetDimExtStretch");
	if (fp)
	{
		((VCDimSetDimExtStretchFN)fp)(iError, b);
	}
}

//============== VCDimSetDimMode ==============
typedef void (CALLBACK* VCDimSetDimModeFN) (short*, short);

void WINAPI VCDimSetDimMode (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDimSetDimMode");
	if (fp)
	{
		((VCDimSetDimModeFN)fp)(iError, b);
	}
}

//============== VCDimSetDimProximity ==============
typedef void (CALLBACK* VCDimSetDimProximityFN) (short*, short);

void WINAPI VCDimSetDimProximity (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDimSetDimProximity");
	if (fp)
	{
		((VCDimSetDimProximityFN)fp)(iError, b);
	}
}

//============== VCDistToString ==============
typedef short (CALLBACK* VCDistToStringFN) (short*, char*, double*);

short WINAPI VCDistToString (short* iError, char* pS, double* pD)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDistToString");
	if (fp)
	{
		return ((VCDistToStringFN)fp)(iError, pS, pD);
	}
	return iRet;
}

//============== VCDrawCurrentEntity ==============
typedef void (CALLBACK* VCDrawCurrentEntityFN) (short*);

void WINAPI VCDrawCurrentEntity (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDrawCurrentEntity");
	if (fp)
	{
		((VCDrawCurrentEntityFN)fp)(iError);
	}
}

//============== VCDrawCurrentEntityXOR ==============
typedef void (CALLBACK* VCDrawCurrentEntityXORFN) (short*);

void WINAPI VCDrawCurrentEntityXOR (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDrawCurrentEntityXOR");
	if (fp)
	{
		((VCDrawCurrentEntityXORFN)fp)(iError);
	}
}

//============== VCDrawToDC ==============
typedef void (CALLBACK* VCDrawToDCFN) (short*, short, long, long, long, long);

void WINAPI VCDrawToDC (short* iError, short hDC_, long bottom, long left, long right, long top)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDrawToDC");
	if (fp)
	{
		((VCDrawToDCFN)fp)(iError, hDC_, bottom, left, right, top);
	}
}

//============== VCDrawToDC2 ==============
typedef void (CALLBACK* VCDrawToDC2FN) (short*, long, long, long, long, long);

void WINAPI VCDrawToDC2 (short* iError, long hDC_, long bottom, long left, long right, long top)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDrawToDC2");
	if (fp)
	{
		((VCDrawToDC2FN)fp)(iError, hDC_, bottom, left, right, top);
	}
}

//============== VCDuplicate ==============
typedef void (CALLBACK* VCDuplicateFN) (short*, ENTITYHANDLE);

void WINAPI VCDuplicate (short* iError, ENTITYHANDLE lH)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDuplicate");
	if (fp)
	{
		((VCDuplicateFN)fp)(iError, lH);
	}
}

//============== VCDuplicateToWorld ==============
typedef void (CALLBACK* VCDuplicateToWorldFN) (short*, ENTITYHANDLE, WORLDHANDLE);

void WINAPI VCDuplicateToWorld (short* iError, ENTITYHANDLE hE, WORLDHANDLE TargetWorld)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDuplicateToWorld");
	if (fp)
	{
		((VCDuplicateToWorldFN)fp)(iError, hE, TargetWorld);
	}
}

//============== VCDuplicateWithTransform ==============
typedef void (CALLBACK* VCDuplicateWithTransformFN) (short*, ENTITYHANDLE, Point2D*, Point2D*, double);

void WINAPI VCDuplicateWithTransform (short* iError, ENTITYHANDLE lH, Point2D* dpTrans, Point2D* dpScale, double dAngle)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDuplicateWithTransform");
	if (fp)
	{
		((VCDuplicateWithTransformFN)fp)(iError, lH, dpTrans, dpScale, dAngle);
	}
}

//============== VCEndOperation ==============
typedef void (CALLBACK* VCEndOperationFN) (short*);

void WINAPI VCEndOperation (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCEndOperation");
	if (fp)
	{
		((VCEndOperationFN)fp)(iError);
	}
}

//============== VCEntityBreak ==============
typedef void (CALLBACK* VCEntityBreakFN) (short*, ENTITYHANDLE, Point2D*, Point2D*);

void WINAPI VCEntityBreak (short* iError, ENTITYHANDLE lH, Point2D* dpP0, Point2D* dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCEntityBreak");
	if (fp)
	{
		((VCEntityBreakFN)fp)(iError, lH, dpP0, dpP1);
	}
}

//============== VCEntityExtents ==============
typedef void (CALLBACK* VCEntityExtentsFN) (short*, ENTITYHANDLE, Point2D*, Point2D*);

void WINAPI VCEntityExtents (short* iError, ENTITYHANDLE lH, Point2D* dpMin, Point2D* dpMax)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCEntityExtents");
	if (fp)
	{
		((VCEntityExtentsFN)fp)(iError, lH, dpMin, dpMax);
	}
}

//============== VCEraseCursor ==============
typedef void (CALLBACK* VCEraseCursorFN) (void);

void WINAPI VCEraseCursor (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCEraseCursor");
	if (fp)
	{
		((VCEraseCursorFN)fp)();
	}
}

//============== VCEraseRubber ==============
typedef void (CALLBACK* VCEraseRubberFN) (void);

void WINAPI VCEraseRubber (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCEraseRubber");
	if (fp)
	{
		((VCEraseRubberFN)fp)();
	}
}

//============== VCFilterReset ==============
typedef void (CALLBACK* VCFilterResetFN) (short*);

void WINAPI VCFilterReset (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCFilterReset");
	if (fp)
	{
		((VCFilterResetFN)fp)(iError);
	}
}

//============== VCFirstEntity ==============
typedef vbool (CALLBACK* VCFirstEntityFN) (short*, short*);

vbool WINAPI VCFirstEntity (short* iError, short* bKind)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCFirstEntity");
	if (fp)
	{
		return ((VCFirstEntityFN)fp)(iError, bKind);
	}
	return vbRet;
}

//============== VCFirstEntityExpand ==============
typedef vbool (CALLBACK* VCFirstEntityExpandFN) (short*, short*);

vbool WINAPI VCFirstEntityExpand (short* iError, short* bKind)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCFirstEntityExpand");
	if (fp)
	{
		return ((VCFirstEntityExpandFN)fp)(iError, bKind);
	}
	return vbRet;
}

//============== VCFirstGraphic ==============
typedef vbool (CALLBACK* VCFirstGraphicFN) (short*, GRAPHICHANDLE);

vbool WINAPI VCFirstGraphic (short* iError, GRAPHICHANDLE hG)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCFirstGraphic");
	if (fp)
	{
		return ((VCFirstGraphicFN)fp)(iError, hG);
	}
	return vbRet;
}

//============== VCFirstOnScreen ==============
typedef vbool (CALLBACK* VCFirstOnScreenFN) (short*, short*);

vbool WINAPI VCFirstOnScreen (short* iError, short* bKind)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCFirstOnScreen");
	if (fp)
	{
		return ((VCFirstOnScreenFN)fp)(iError, bKind);
	}
	return vbRet;
}

//============== VCFirstSelected ==============
typedef vbool (CALLBACK* VCFirstSelectedFN) (short*, short*);

vbool WINAPI VCFirstSelected (short* iError, short* bKind)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCFirstSelected");
	if (fp)
	{
		return ((VCFirstSelectedFN)fp)(iError, bKind);
	}
	return vbRet;
}

//============== VCFirstSelectedRF ==============
typedef vbool (CALLBACK* VCFirstSelectedRFFN) (short*, long*);

vbool WINAPI VCFirstSelectedRF (short* iError, long* hE)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCFirstSelectedRF");
	if (fp)
	{
		return ((VCFirstSelectedRFFN)fp)(iError, hE);
	}
	return vbRet;
}

//============== VCFirstView ==============
typedef vbool (CALLBACK* VCFirstViewFN) (short*);

vbool WINAPI VCFirstView (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCFirstView");
	if (fp)
	{
		return ((VCFirstViewFN)fp)(iError);
	}
	return vbRet;
}

//============== VCForceWidthOnAllEntities ==============
typedef void (CALLBACK* VCForceWidthOnAllEntitiesFN) (short*, short);

void WINAPI VCForceWidthOnAllEntities (short* iError, short iNewWidth)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCForceWidthOnAllEntities");
	if (fp)
	{
		((VCForceWidthOnAllEntitiesFN)fp)(iError, iNewWidth);
	}
}

//============== VCGeneratePointsFromCurrentEntity ==============
typedef void (CALLBACK* VCGeneratePointsFromCurrentEntityFN) (short*, Point2D*, short*, short, double);

void WINAPI VCGeneratePointsFromCurrentEntity (short* iError, Point2D* P, short* iCount, short iMax, double dStep)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGeneratePointsFromCurrentEntity");
	if (fp)
	{
		((VCGeneratePointsFromCurrentEntityFN)fp)(iError, P, iCount, iMax, dStep);
	}
}

//============== VCGetAcadImportUnit ==============
typedef BYTE (CALLBACK* VCGetAcadImportUnitFN) (short*);

BYTE WINAPI VCGetAcadImportUnit (short* iError)
{
	BYTE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAcadImportUnit");
	if (fp)
	{
		return ((VCGetAcadImportUnitFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetAllLayersEd ==============
typedef vbool (CALLBACK* VCGetAllLayersEdFN) (short*);

vbool WINAPI VCGetAllLayersEd (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAllLayersEd");
	if (fp)
	{
		return ((VCGetAllLayersEdFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetAllLayersSnap ==============
typedef vbool (CALLBACK* VCGetAllLayersSnapFN) (short*);

vbool WINAPI VCGetAllLayersSnap (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAllLayersSnap");
	if (fp)
	{
		return ((VCGetAllLayersSnapFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetAngle ==============
typedef double (CALLBACK* VCGetAngleFN) (short*);

double WINAPI VCGetAngle (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAngle");
	if (fp)
	{
		return ((VCGetAngleFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetAngleBP ==============
typedef void (CALLBACK* VCGetAngleBPFN) (short*, double*);

void WINAPI VCGetAngleBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAngleBP");
	if (fp)
	{
		((VCGetAngleBPFN)fp)(iError, dRet);
	}
}

//============== VCGetAngleHandle ==============
typedef long (CALLBACK* VCGetAngleHandleFN) (void);

long WINAPI VCGetAngleHandle (void)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAngleHandle");
	if (fp)
	{
		return ((VCGetAngleHandleFN)fp)();
	}
	return lRet;
}

//============== VCGetArrowScreenStep ==============
typedef short (CALLBACK* VCGetArrowScreenStepFN) (short*);

short WINAPI VCGetArrowScreenStep (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetArrowScreenStep");
	if (fp)
	{
		return ((VCGetArrowScreenStepFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetArrowWorld ==============
typedef vbool (CALLBACK* VCGetArrowWorldFN) (short*);

vbool WINAPI VCGetArrowWorld (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetArrowWorld");
	if (fp)
	{
		return ((VCGetArrowWorldFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetArrowWorldStep ==============
typedef double (CALLBACK* VCGetArrowWorldStepFN) (short*);

double WINAPI VCGetArrowWorldStep (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetArrowWorldStep");
	if (fp)
	{
		return ((VCGetArrowWorldStepFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetArrowWorldStepBP ==============
typedef void (CALLBACK* VCGetArrowWorldStepBPFN) (short*, double*);

void WINAPI VCGetArrowWorldStepBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetArrowWorldStepBP");
	if (fp)
	{
		((VCGetArrowWorldStepBPFN)fp)(iError, dRet);
	}
}

//============== VCGetAskZoomCenter ==============
typedef vbool (CALLBACK* VCGetAskZoomCenterFN) (short*);

vbool WINAPI VCGetAskZoomCenter (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAskZoomCenter");
	if (fp)
	{
		return ((VCGetAskZoomCenterFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetAssocContourCount ==============
typedef long (CALLBACK* VCGetAssocContourCountFN) (short*, long);

long WINAPI VCGetAssocContourCount (short* iError, long WhichAssoc)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAssocContourCount");
	if (fp)
	{
		return ((VCGetAssocContourCountFN)fp)(iError, WhichAssoc);
	}
	return lRet;
}

//============== VCGetAssocCount ==============
typedef long (CALLBACK* VCGetAssocCountFN) (short*);

long WINAPI VCGetAssocCount (short* iError)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAssocCount");
	if (fp)
	{
		return ((VCGetAssocCountFN)fp)(iError);
	}
	return lRet;
}

//============== VCGetAssocEntity ==============
typedef UID (CALLBACK* VCGetAssocEntityFN) (short*, long, long, long);

UID WINAPI VCGetAssocEntity (short* iError, long WhichAssoc, long WhichContour, long WhichEntity)
{
	UID iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAssocEntity");
	if (fp)
	{
		return ((VCGetAssocEntityFN)fp)(iError, WhichAssoc, WhichContour, WhichEntity);
	}
	return iRet;
}

//============== VCGetAssocEntityCount ==============
typedef long (CALLBACK* VCGetAssocEntityCountFN) (short*, long, long);

long WINAPI VCGetAssocEntityCount (short* iError, long WhichAssoc, long WhichContour)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAssocEntityCount");
	if (fp)
	{
		return ((VCGetAssocEntityCountFN)fp)(iError, WhichAssoc, WhichContour);
	}
	return lRet;
}

//============== VCGetAssocKind ==============
typedef short (CALLBACK* VCGetAssocKindFN) (short*, long);

short WINAPI VCGetAssocKind (short* iError, long WhichAssoc)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAssocKind");
	if (fp)
	{
		return ((VCGetAssocKindFN)fp)(iError, WhichAssoc);
	}
	return iRet;
}

//============== VCGetAtbColorIndex ==============
typedef short (CALLBACK* VCGetAtbColorIndexFN) (short*);

short WINAPI VCGetAtbColorIndex (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbColorIndex");
	if (fp)
	{
		return ((VCGetAtbColorIndexFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetAtbDefCount ==============
typedef short (CALLBACK* VCGetAtbDefCountFN) (short*);

short WINAPI VCGetAtbDefCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbDefCount");
	if (fp)
	{
		return ((VCGetAtbDefCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetAtbDefLabel ==============
typedef short (CALLBACK* VCGetAtbDefLabelFN) (short*, char*, char*, short);

short WINAPI VCGetAtbDefLabel (short* iError, char* szName, char* szLabel, short iRec)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbDefLabel");
	if (fp)
	{
		return ((VCGetAtbDefLabelFN)fp)(iError, szName, szLabel, iRec);
	}
	return iRet;
}

//============== VCGetAtbDefName ==============
typedef short (CALLBACK* VCGetAtbDefNameFN) (short*, short, char*);

short WINAPI VCGetAtbDefName (short* iError, short iIndex, char* szName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbDefName");
	if (fp)
	{
		return ((VCGetAtbDefNameFN)fp)(iError, iIndex, szName);
	}
	return iRet;
}

//============== VCGetAtbDefRecordCount ==============
typedef short (CALLBACK* VCGetAtbDefRecordCountFN) (short*, char*);

short WINAPI VCGetAtbDefRecordCount (short* iError, char* szName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbDefRecordCount");
	if (fp)
	{
		return ((VCGetAtbDefRecordCountFN)fp)(iError, szName);
	}
	return iRet;
}

//============== VCGetAtbDefValue ==============
typedef short (CALLBACK* VCGetAtbDefValueFN) (short*, char*, char*, short);

short WINAPI VCGetAtbDefValue (short* iError, char* szName, char* Value, short iRec)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbDefValue");
	if (fp)
	{
		return ((VCGetAtbDefValueFN)fp)(iError, szName, Value, iRec);
	}
	return iRet;
}

//============== VCGetAtbDisplay ==============
typedef vbool (CALLBACK* VCGetAtbDisplayFN) (short*);

vbool WINAPI VCGetAtbDisplay (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbDisplay");
	if (fp)
	{
		return ((VCGetAtbDisplayFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetAtbFont ==============
typedef short (CALLBACK* VCGetAtbFontFN) (short*, char*);

short WINAPI VCGetAtbFont (short* iError, char* pS)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbFont");
	if (fp)
	{
		return ((VCGetAtbFontFN)fp)(iError, pS);
	}
	return iRet;
}

//============== VCGetAtbHeight ==============
typedef void (CALLBACK* VCGetAtbHeightFN) (short*, double*);

void WINAPI VCGetAtbHeight (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbHeight");
	if (fp)
	{
		((VCGetAtbHeightFN)fp)(iError, dRet);
	}
}

//============== VCGetAtbInternalName ==============
typedef short (CALLBACK* VCGetAtbInternalNameFN) (short*, char*, char*);

short WINAPI VCGetAtbInternalName (short* iError, char* pFileName, char* pReturn)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbInternalName");
	if (fp)
	{
		return ((VCGetAtbInternalNameFN)fp)(iError, pFileName, pReturn);
	}
	return iRet;
}

//============== VCGetAtbLabel ==============
typedef vbool (CALLBACK* VCGetAtbLabelFN) (short*);

vbool WINAPI VCGetAtbLabel (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAtbLabel");
	if (fp)
	{
		return ((VCGetAtbLabelFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetAutoFillet ==============
typedef vbool (CALLBACK* VCGetAutoFilletFN) (short*);

vbool WINAPI VCGetAutoFillet (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAutoFillet");
	if (fp)
	{
		return ((VCGetAutoFilletFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetAutoSave ==============
typedef vbool (CALLBACK* VCGetAutoSaveFN) (short*);

vbool WINAPI VCGetAutoSave (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAutoSave");
	if (fp)
	{
		return ((VCGetAutoSaveFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetAutoSaveSecs ==============
typedef short (CALLBACK* VCGetAutoSaveSecsFN) (short*);

short WINAPI VCGetAutoSaveSecs (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetAutoSaveSecs");
	if (fp)
	{
		return ((VCGetAutoSaveSecsFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetBackgroundColor ==============
typedef short (CALLBACK* VCGetBackgroundColorFN) (short*);

short WINAPI VCGetBackgroundColor (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetBackgroundColor");
	if (fp)
	{
		return ((VCGetBackgroundColorFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetBackwardsRedraw ==============
typedef vbool (CALLBACK* VCGetBackwardsRedrawFN) (short*);

vbool WINAPI VCGetBackwardsRedraw (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetBackwardsRedraw");
	if (fp)
	{
		return ((VCGetBackwardsRedrawFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetCMDId ==============
typedef long (CALLBACK* VCGetCMDIdFN) (short*, char*);

long WINAPI VCGetCMDId (short* iError, char* pNative)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCMDId");
	if (fp)
	{
		return ((VCGetCMDIdFN)fp)(iError, pNative);
	}
	return lRet;
}

//============== VCGetCMPPath ==============
typedef short (CALLBACK* VCGetCMPPathFN) (short*, char*);

short WINAPI VCGetCMPPath (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCMPPath");
	if (fp)
	{
		return ((VCGetCMPPathFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetChamferDist1 ==============
typedef double (CALLBACK* VCGetChamferDist1FN) (short*);

double WINAPI VCGetChamferDist1 (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetChamferDist1");
	if (fp)
	{
		return ((VCGetChamferDist1FN)fp)(iError);
	}
	return dRet;
}

//============== VCGetChamferDist1BP ==============
typedef void (CALLBACK* VCGetChamferDist1BPFN) (short*, double*);

void WINAPI VCGetChamferDist1BP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetChamferDist1BP");
	if (fp)
	{
		((VCGetChamferDist1BPFN)fp)(iError, dRet);
	}
}

//============== VCGetChamferDist2 ==============
typedef double (CALLBACK* VCGetChamferDist2FN) (short*);

double WINAPI VCGetChamferDist2 (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetChamferDist2");
	if (fp)
	{
		return ((VCGetChamferDist2FN)fp)(iError);
	}
	return dRet;
}

//============== VCGetChamferDist2BP ==============
typedef void (CALLBACK* VCGetChamferDist2BPFN) (short*, double*);

void WINAPI VCGetChamferDist2BP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetChamferDist2BP");
	if (fp)
	{
		((VCGetChamferDist2BPFN)fp)(iError, dRet);
	}
}

//============== VCGetClosestSegment ==============
typedef void (CALLBACK* VCGetClosestSegmentFN) (short*, Point2D*, ENTITYHANDLE, Point2D*, Point2D*);

void WINAPI VCGetClosestSegment (short* iError, Point2D* p2d, ENTITYHANDLE lH, Point2D* dpP0, Point2D* dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetClosestSegment");
	if (fp)
	{
		((VCGetClosestSegmentFN)fp)(iError, p2d, lH, dpP0, dpP1);
	}
}

//============== VCGetCmdName ==============
typedef short (CALLBACK* VCGetCmdNameFN) (short*, short, char*);

short WINAPI VCGetCmdName (short* iError, short iCmdId, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCmdName");
	if (fp)
	{
		return ((VCGetCmdNameFN)fp)(iError, iCmdId, pName);
	}
	return iRet;
}

//============== VCGetCmdStr ==============
typedef short (CALLBACK* VCGetCmdStrFN) (short*, char*);

short WINAPI VCGetCmdStr (short* iError, char* pS)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCmdStr");
	if (fp)
	{
		return ((VCGetCmdStrFN)fp)(iError, pS);
	}
	return iRet;
}

//============== VCGetColorIndex ==============
typedef short (CALLBACK* VCGetColorIndexFN) (short*);

short WINAPI VCGetColorIndex (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetColorIndex");
	if (fp)
	{
		return ((VCGetColorIndexFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCommandAlias ==============
typedef short (CALLBACK* VCGetCommandAliasFN) (short, char*);

short WINAPI VCGetCommandAlias (short i, char* szAlias)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCommandAlias");
	if (fp)
	{
		return ((VCGetCommandAliasFN)fp)(i, szAlias);
	}
	return iRet;
}

//============== VCGetCommandCount ==============
typedef short (CALLBACK* VCGetCommandCountFN) (void);

short WINAPI VCGetCommandCount (void)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCommandCount");
	if (fp)
	{
		return ((VCGetCommandCountFN)fp)();
	}
	return iRet;
}

//============== VCGetCommandDescription ==============
typedef short (CALLBACK* VCGetCommandDescriptionFN) (short, char*);

short WINAPI VCGetCommandDescription (short i, char* szNative)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCommandDescription");
	if (fp)
	{
		return ((VCGetCommandDescriptionFN)fp)(i, szNative);
	}
	return iRet;
}

//============== VCGetCommandNative ==============
typedef short (CALLBACK* VCGetCommandNativeFN) (short, char*);

short WINAPI VCGetCommandNative (short i, char* szNative)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCommandNative");
	if (fp)
	{
		return ((VCGetCommandNativeFN)fp)(i, szNative);
	}
	return iRet;
}

//============== VCGetConstPt ==============
typedef vbool (CALLBACK* VCGetConstPtFN) (short*);

vbool WINAPI VCGetConstPt (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetConstPt");
	if (fp)
	{
		return ((VCGetConstPtFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetCurEntAtbCount ==============
typedef short (CALLBACK* VCGetCurEntAtbCountFN) (short*);

short WINAPI VCGetCurEntAtbCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurEntAtbCount");
	if (fp)
	{
		return ((VCGetCurEntAtbCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurEntAtbName ==============
typedef short (CALLBACK* VCGetCurEntAtbNameFN) (short*, short, char*);

short WINAPI VCGetCurEntAtbName (short* iError, short iWhichAtb, char* szName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurEntAtbName");
	if (fp)
	{
		return ((VCGetCurEntAtbNameFN)fp)(iError, iWhichAtb, szName);
	}
	return iRet;
}

//============== VCGetCurEntAtbRecCount ==============
typedef short (CALLBACK* VCGetCurEntAtbRecCountFN) (short*, short);

short WINAPI VCGetCurEntAtbRecCount (short* iError, short iWhichAtb)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurEntAtbRecCount");
	if (fp)
	{
		return ((VCGetCurEntAtbRecCountFN)fp)(iError, iWhichAtb);
	}
	return iRet;
}

//============== VCGetCurEntAtbRecLabel ==============
typedef short (CALLBACK* VCGetCurEntAtbRecLabelFN) (short*, short, short, char*);

short WINAPI VCGetCurEntAtbRecLabel (short* iError, short iWhichAtb, short iWhichRec, char* pLabel)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurEntAtbRecLabel");
	if (fp)
	{
		return ((VCGetCurEntAtbRecLabelFN)fp)(iError, iWhichAtb, iWhichRec, pLabel);
	}
	return iRet;
}

//============== VCGetCurEntAtbRecValue ==============
typedef short (CALLBACK* VCGetCurEntAtbRecValueFN) (short*, short, short, char*);

short WINAPI VCGetCurEntAtbRecValue (short* iError, short iWhichAtb, short iWhichRec, char* pValue)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurEntAtbRecValue");
	if (fp)
	{
		return ((VCGetCurEntAtbRecValueFN)fp)(iError, iWhichAtb, iWhichRec, pValue);
	}
	return iRet;
}

//============== VCGetCurEntAtbRefPoint ==============
typedef void (CALLBACK* VCGetCurEntAtbRefPointFN) (short*, short, Point2D*);

void WINAPI VCGetCurEntAtbRefPoint (short* iError, short iWhichAtb, Point2D* dpRef)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurEntAtbRefPoint");
	if (fp)
	{
		((VCGetCurEntAtbRefPointFN)fp)(iError, iWhichAtb, dpRef);
	}
}

//============== VCGetCurEntUserDataChunkSize ==============
typedef short (CALLBACK* VCGetCurEntUserDataChunkSizeFN) (short*, short);

short WINAPI VCGetCurEntUserDataChunkSize (short* iError, short iIndex)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurEntUserDataChunkSize");
	if (fp)
	{
		return ((VCGetCurEntUserDataChunkSizeFN)fp)(iError, iIndex);
	}
	return iRet;
}

//============== VCGetCurEntUserDataStringSize ==============
typedef short (CALLBACK* VCGetCurEntUserDataStringSizeFN) (short*, short);

short WINAPI VCGetCurEntUserDataStringSize (short* iError, short iIndex)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurEntUserDataStringSize");
	if (fp)
	{
		return ((VCGetCurEntUserDataStringSizeFN)fp)(iError, iIndex);
	}
	return iRet;
}

//============== VCGetCurentOleClassId ==============
typedef long (CALLBACK* VCGetCurentOleClassIdFN) (short*);

long WINAPI VCGetCurentOleClassId (short* iError)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurentOleClassId");
	if (fp)
	{
		return ((VCGetCurentOleClassIdFN)fp)(iError);
	}
	return lRet;
}

//============== VCGetCurrEntRFAbsName ==============
typedef short (CALLBACK* VCGetCurrEntRFAbsNameFN) (short*, char*);

short WINAPI VCGetCurrEntRFAbsName (short* iError, char* RetPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrEntRFAbsName");
	if (fp)
	{
		return ((VCGetCurrEntRFAbsNameFN)fp)(iError, RetPath);
	}
	return iRet;
}

//============== VCGetCurrEntRFAbsShortName ==============
typedef short (CALLBACK* VCGetCurrEntRFAbsShortNameFN) (short*, char*);

short WINAPI VCGetCurrEntRFAbsShortName (short* iError, char* RetPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrEntRFAbsShortName");
	if (fp)
	{
		return ((VCGetCurrEntRFAbsShortNameFN)fp)(iError, RetPath);
	}
	return iRet;
}

//============== VCGetCurrEntUserDataName ==============
typedef short (CALLBACK* VCGetCurrEntUserDataNameFN) (short*, short, char*);

short WINAPI VCGetCurrEntUserDataName (short* iError, short iIndex, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrEntUserDataName");
	if (fp)
	{
		return ((VCGetCurrEntUserDataNameFN)fp)(iError, iIndex, pName);
	}
	return iRet;
}

//============== VCGetCurrWorld ==============
typedef WORLDHANDLE (CALLBACK* VCGetCurrWorldFN) (void);

WORLDHANDLE WINAPI VCGetCurrWorld (void)
{
	WORLDHANDLE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrWorld");
	if (fp)
	{
		return ((VCGetCurrWorldFN)fp)();
	}
	return iRet;
}

//============== VCGetCurrZoom ==============
typedef void (CALLBACK* VCGetCurrZoomFN) (short*, Point2D*, Point2D*);

void WINAPI VCGetCurrZoom (short* iError, Point2D* dpMin, Point2D* dpMax)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrZoom");
	if (fp)
	{
		((VCGetCurrZoomFN)fp)(iError, dpMin, dpMax);
	}
}

//============== VCGetCurrentEntUserDataDoubleBP ==============
typedef void (CALLBACK* VCGetCurrentEntUserDataDoubleBPFN) (short*, short, double*);

void WINAPI VCGetCurrentEntUserDataDoubleBP (short* iError, short iIndex, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntUserDataDoubleBP");
	if (fp)
	{
		((VCGetCurrentEntUserDataDoubleBPFN)fp)(iError, iIndex, dRet);
	}
}

//============== VCGetCurrentEntity3DFlag0 ==============
typedef short (CALLBACK* VCGetCurrentEntity3DFlag0FN) (short*);

short WINAPI VCGetCurrentEntity3DFlag0 (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntity3DFlag0");
	if (fp)
	{
		return ((VCGetCurrentEntity3DFlag0FN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentEntityArcData ==============
typedef void (CALLBACK* VCGetCurrentEntityArcDataFN) (short*, Point2D*, double*, double*, double*, double*);

void WINAPI VCGetCurrentEntityArcData (short* iError, Point2D* dpC, double* dRad, double* dStart, double* dSpan, double* dArcLength)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityArcData");
	if (fp)
	{
		((VCGetCurrentEntityArcDataFN)fp)(iError, dpC, dRad, dStart, dSpan, dArcLength);
	}
}

//============== VCGetCurrentEntityArea ==============
typedef void (CALLBACK* VCGetCurrentEntityAreaFN) (short*, double, double*);

void WINAPI VCGetCurrentEntityArea (short* iError, double dStep, double* dArea)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityArea");
	if (fp)
	{
		((VCGetCurrentEntityAreaFN)fp)(iError, dStep, dArea);
	}
}

//============== VCGetCurrentEntityCloseContour ==============
typedef vbool (CALLBACK* VCGetCurrentEntityCloseContourFN) (short*);

vbool WINAPI VCGetCurrentEntityCloseContour (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityCloseContour");
	if (fp)
	{
		return ((VCGetCurrentEntityCloseContourFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetCurrentEntityColor ==============
typedef short (CALLBACK* VCGetCurrentEntityColorFN) (short*);

short WINAPI VCGetCurrentEntityColor (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityColor");
	if (fp)
	{
		return ((VCGetCurrentEntityColorFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentEntityDist ==============
typedef void (CALLBACK* VCGetCurrentEntityDistFN) (short*, double, double*);

void WINAPI VCGetCurrentEntityDist (short* iError, double dStep, double* dDist)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityDist");
	if (fp)
	{
		((VCGetCurrentEntityDistFN)fp)(iError, dStep, dDist);
	}
}

//============== VCGetCurrentEntityHandle ==============
typedef ENTITYHANDLE (CALLBACK* VCGetCurrentEntityHandleFN) (short*);

ENTITYHANDLE WINAPI VCGetCurrentEntityHandle (short* iError)
{
	ENTITYHANDLE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityHandle");
	if (fp)
	{
		return ((VCGetCurrentEntityHandleFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentEntityKind ==============
typedef short (CALLBACK* VCGetCurrentEntityKindFN) (short*);

short WINAPI VCGetCurrentEntityKind (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityKind");
	if (fp)
	{
		return ((VCGetCurrentEntityKindFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentEntityLayer ==============
typedef short (CALLBACK* VCGetCurrentEntityLayerFN) (short*);

short WINAPI VCGetCurrentEntityLayer (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityLayer");
	if (fp)
	{
		return ((VCGetCurrentEntityLayerFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentEntityLayerName ==============
typedef short (CALLBACK* VCGetCurrentEntityLayerNameFN) (short*, char*);

short WINAPI VCGetCurrentEntityLayerName (short* iError, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityLayerName");
	if (fp)
	{
		return ((VCGetCurrentEntityLayerNameFN)fp)(iError, pName);
	}
	return iRet;
}

//============== VCGetCurrentEntityLength ==============
typedef void (CALLBACK* VCGetCurrentEntityLengthFN) (short*, double, double*);

void WINAPI VCGetCurrentEntityLength (short* iError, double dStep, double* dLength)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityLength");
	if (fp)
	{
		((VCGetCurrentEntityLengthFN)fp)(iError, dStep, dLength);
	}
}

//============== VCGetCurrentEntityLineType ==============
typedef short (CALLBACK* VCGetCurrentEntityLineTypeFN) (short*);

short WINAPI VCGetCurrentEntityLineType (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityLineType");
	if (fp)
	{
		return ((VCGetCurrentEntityLineTypeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentEntityLineTypeName ==============
typedef short (CALLBACK* VCGetCurrentEntityLineTypeNameFN) (short*, char*);

short WINAPI VCGetCurrentEntityLineTypeName (short* iError, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityLineTypeName");
	if (fp)
	{
		return ((VCGetCurrentEntityLineTypeNameFN)fp)(iError, pName);
	}
	return iRet;
}

//============== VCGetCurrentEntityLineWidth ==============
typedef short (CALLBACK* VCGetCurrentEntityLineWidthFN) (short*);

short WINAPI VCGetCurrentEntityLineWidth (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityLineWidth");
	if (fp)
	{
		return ((VCGetCurrentEntityLineWidthFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentEntityLineWidthValue ==============
typedef void (CALLBACK* VCGetCurrentEntityLineWidthValueFN) (short*, float*);

void WINAPI VCGetCurrentEntityLineWidthValue (short* iError, float* dV)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityLineWidthValue");
	if (fp)
	{
		((VCGetCurrentEntityLineWidthValueFN)fp)(iError, dV);
	}
}

//============== VCGetCurrentEntityNormal3D ==============
typedef void (CALLBACK* VCGetCurrentEntityNormal3DFN) (short*, Point3D*);

void WINAPI VCGetCurrentEntityNormal3D (short* iError, Point3D* nV)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityNormal3D");
	if (fp)
	{
		((VCGetCurrentEntityNormal3DFN)fp)(iError, nV);
	}
}

//============== VCGetCurrentEntityPoint ==============
typedef Point2D (CALLBACK* VCGetCurrentEntityPointFN) (short*, short);

Point2D WINAPI VCGetCurrentEntityPoint (short* iError, short iIndex)
{
	Point2D dpRet;
	dpRet.x = dpRet.y = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityPoint");
	if (fp)
	{
		return ((VCGetCurrentEntityPointFN)fp)(iError, iIndex);
	}
	return dpRet;
}

//============== VCGetCurrentEntityPoint3D ==============
typedef void (CALLBACK* VCGetCurrentEntityPoint3DFN) (short*, short, Point3D*);

void WINAPI VCGetCurrentEntityPoint3D (short* iError, short iIndex, Point3D* dpRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityPoint3D");
	if (fp)
	{
		((VCGetCurrentEntityPoint3DFN)fp)(iError, iIndex, dpRet);
	}
}

//============== VCGetCurrentEntityPointBP ==============
typedef void (CALLBACK* VCGetCurrentEntityPointBPFN) (short*, short, Point2D*);

void WINAPI VCGetCurrentEntityPointBP (short* iError, short iIndex, Point2D* dpRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityPointBP");
	if (fp)
	{
		((VCGetCurrentEntityPointBPFN)fp)(iError, iIndex, dpRet);
	}
}

//============== VCGetCurrentEntityPointCount ==============
typedef short (CALLBACK* VCGetCurrentEntityPointCountFN) (short*);

short WINAPI VCGetCurrentEntityPointCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityPointCount");
	if (fp)
	{
		return ((VCGetCurrentEntityPointCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentEntityUID ==============
typedef UID (CALLBACK* VCGetCurrentEntityUIDFN) (short*);

UID WINAPI VCGetCurrentEntityUID (short* iError)
{
	UID iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUID");
	if (fp)
	{
		return ((VCGetCurrentEntityUIDFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentEntityUseByLayerProperties ==============
typedef void (CALLBACK* VCGetCurrentEntityUseByLayerPropertiesFN) (short*, vbool*, vbool*, vbool*);

void WINAPI VCGetCurrentEntityUseByLayerProperties (short* iError, vbool* tfColor, vbool* tfLineType, vbool* tfLineWidth)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUseByLayerProperties");
	if (fp)
	{
		((VCGetCurrentEntityUseByLayerPropertiesFN)fp)(iError, tfColor, tfLineType, tfLineWidth);
	}
}

//============== VCGetCurrentEntityUserDataByte ==============
typedef BYTE (CALLBACK* VCGetCurrentEntityUserDataByteFN) (short*, short);

BYTE WINAPI VCGetCurrentEntityUserDataByte (short* iError, short iIndex)
{
	BYTE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUserDataByte");
	if (fp)
	{
		return ((VCGetCurrentEntityUserDataByteFN)fp)(iError, iIndex);
	}
	return iRet;
}

//============== VCGetCurrentEntityUserDataChunk ==============
typedef void (CALLBACK* VCGetCurrentEntityUserDataChunkFN) (short*, short, char*);

void WINAPI VCGetCurrentEntityUserDataChunk (short* iError, short iIndex, char* p)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUserDataChunk");
	if (fp)
	{
		((VCGetCurrentEntityUserDataChunkFN)fp)(iError, iIndex, p);
	}
}

//============== VCGetCurrentEntityUserDataCount ==============
typedef short (CALLBACK* VCGetCurrentEntityUserDataCountFN) (short*);

short WINAPI VCGetCurrentEntityUserDataCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUserDataCount");
	if (fp)
	{
		return ((VCGetCurrentEntityUserDataCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentEntityUserDataDouble ==============
typedef double (CALLBACK* VCGetCurrentEntityUserDataDoubleFN) (short*, short);

double WINAPI VCGetCurrentEntityUserDataDouble (short* iError, short iIndex)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUserDataDouble");
	if (fp)
	{
		return ((VCGetCurrentEntityUserDataDoubleFN)fp)(iError, iIndex);
	}
	return dRet;
}

//============== VCGetCurrentEntityUserDataFloat ==============
typedef float (CALLBACK* VCGetCurrentEntityUserDataFloatFN) (short*, short);

float WINAPI VCGetCurrentEntityUserDataFloat (short* iError, short iIndex)
{
	float fRet;
	fRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUserDataFloat");
	if (fp)
	{
		return ((VCGetCurrentEntityUserDataFloatFN)fp)(iError, iIndex);
	}
	return fRet;
}

//============== VCGetCurrentEntityUserDataKind ==============
typedef short (CALLBACK* VCGetCurrentEntityUserDataKindFN) (short*, short);

short WINAPI VCGetCurrentEntityUserDataKind (short* iError, short iIndex)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUserDataKind");
	if (fp)
	{
		return ((VCGetCurrentEntityUserDataKindFN)fp)(iError, iIndex);
	}
	return iRet;
}

//============== VCGetCurrentEntityUserDataLong ==============
typedef long (CALLBACK* VCGetCurrentEntityUserDataLongFN) (short*, short);

long WINAPI VCGetCurrentEntityUserDataLong (short* iError, short iIndex)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUserDataLong");
	if (fp)
	{
		return ((VCGetCurrentEntityUserDataLongFN)fp)(iError, iIndex);
	}
	return lRet;
}

//============== VCGetCurrentEntityUserDataShort ==============
typedef short (CALLBACK* VCGetCurrentEntityUserDataShortFN) (short*, short);

short WINAPI VCGetCurrentEntityUserDataShort (short* iError, short iIndex)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUserDataShort");
	if (fp)
	{
		return ((VCGetCurrentEntityUserDataShortFN)fp)(iError, iIndex);
	}
	return iRet;
}

//============== VCGetCurrentEntityUserDataString ==============
typedef void (CALLBACK* VCGetCurrentEntityUserDataStringFN) (short*, short, char*);

void WINAPI VCGetCurrentEntityUserDataString (short* iError, short iIndex, char* str)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentEntityUserDataString");
	if (fp)
	{
		((VCGetCurrentEntityUserDataStringFN)fp)(iError, iIndex, str);
	}
}

//============== VCGetCurrentErasedEntity ==============
typedef ENTITYHANDLE (CALLBACK* VCGetCurrentErasedEntityFN) (short*);

ENTITYHANDLE WINAPI VCGetCurrentErasedEntity (short* iError)
{
	ENTITYHANDLE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentErasedEntity");
	if (fp)
	{
		return ((VCGetCurrentErasedEntityFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentPoint ==============
typedef void (CALLBACK* VCGetCurrentPointFN) (short*, Point2D*);

void WINAPI VCGetCurrentPoint (short* iError, Point2D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentPoint");
	if (fp)
	{
		((VCGetCurrentPointFN)fp)(iError, dpP);
	}
}

//============== VCGetCurrentUID ==============
typedef UID (CALLBACK* VCGetCurrentUIDFN) (short*);

UID WINAPI VCGetCurrentUID (short* iError)
{
	UID iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentUID");
	if (fp)
	{
		return ((VCGetCurrentUIDFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentUndoLevel ==============
typedef short (CALLBACK* VCGetCurrentUndoLevelFN) (short*);

short WINAPI VCGetCurrentUndoLevel (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentUndoLevel");
	if (fp)
	{
		return ((VCGetCurrentUndoLevelFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCurrentView ==============
typedef void (CALLBACK* VCGetCurrentViewFN) (short*, short*);

void WINAPI VCGetCurrentView (short* iError, short* iView)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCurrentView");
	if (fp)
	{
		((VCGetCurrentViewFN)fp)(iError, iView);
	}
}

//============== VCGetCursorColor ==============
typedef short (CALLBACK* VCGetCursorColorFN) (short*);

short WINAPI VCGetCursorColor (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCursorColor");
	if (fp)
	{
		return ((VCGetCursorColorFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetCursorFree ==============
typedef vbool (CALLBACK* VCGetCursorFreeFN) (short*);

vbool WINAPI VCGetCursorFree (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCursorFree");
	if (fp)
	{
		return ((VCGetCursorFreeFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetCursorSize ==============
typedef short (CALLBACK* VCGetCursorSizeFN) (short*);

short WINAPI VCGetCursorSize (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCursorSize");
	if (fp)
	{
		return ((VCGetCursorSizeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDC ==============
typedef long (CALLBACK* VCGetDCFN) (short*);

long WINAPI VCGetDC (short* iError)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDC");
	if (fp)
	{
		return ((VCGetDCFN)fp)(iError);
	}
	return lRet;
}

//============== VCGetDWGPath ==============
typedef short (CALLBACK* VCGetDWGPathFN) (short*, char*);

short WINAPI VCGetDWGPath (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDWGPath");
	if (fp)
	{
		return ((VCGetDWGPathFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetDXFPath ==============
typedef short (CALLBACK* VCGetDXFPathFN) (short*, char*);

short WINAPI VCGetDXFPath (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDXFPath");
	if (fp)
	{
		return ((VCGetDXFPathFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetDatumBasePt ==============
typedef Point2D (CALLBACK* VCGetDatumBasePtFN) (short*);

Point2D WINAPI VCGetDatumBasePt (short* iError)
{
	Point2D dpRet;
	dpRet.x = dpRet.y = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDatumBasePt");
	if (fp)
	{
		return ((VCGetDatumBasePtFN)fp)(iError);
	}
	return dpRet;
}

//============== VCGetDatumType ==============
typedef short (CALLBACK* VCGetDatumTypeFN) (short*);

short WINAPI VCGetDatumType (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDatumType");
	if (fp)
	{
		return ((VCGetDatumTypeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDefaultTool ==============
typedef WORD (CALLBACK* VCGetDefaultToolFN) (short*);

WORD WINAPI VCGetDefaultTool (short* iError)
{
	WORD iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDefaultTool");
	if (fp)
	{
		return ((VCGetDefaultToolFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimAngleFormat ==============
typedef short (CALLBACK* VCGetDimAngleFormatFN) (short*);

short WINAPI VCGetDimAngleFormat (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimAngleFormat");
	if (fp)
	{
		return ((VCGetDimAngleFormatFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimArrowAngle ==============
typedef double (CALLBACK* VCGetDimArrowAngleFN) (short*);

double WINAPI VCGetDimArrowAngle (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimArrowAngle");
	if (fp)
	{
		return ((VCGetDimArrowAngleFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimArrowAngleBP ==============
typedef void (CALLBACK* VCGetDimArrowAngleBPFN) (short*, double*);

void WINAPI VCGetDimArrowAngleBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimArrowAngleBP");
	if (fp)
	{
		((VCGetDimArrowAngleBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimArrowFlipDists ==============
typedef void (CALLBACK* VCGetDimArrowFlipDistsFN) (short*, double*, double*);

void WINAPI VCGetDimArrowFlipDists (short* iError, double* d0, double* d1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimArrowFlipDists");
	if (fp)
	{
		((VCGetDimArrowFlipDistsFN)fp)(iError, d0, d1);
	}
}

//============== VCGetDimArrowLength ==============
typedef double (CALLBACK* VCGetDimArrowLengthFN) (short*);

double WINAPI VCGetDimArrowLength (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimArrowLength");
	if (fp)
	{
		return ((VCGetDimArrowLengthFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimArrowLengthBP ==============
typedef void (CALLBACK* VCGetDimArrowLengthBPFN) (short*, double*);

void WINAPI VCGetDimArrowLengthBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimArrowLengthBP");
	if (fp)
	{
		((VCGetDimArrowLengthBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimArrowMode ==============
typedef short (CALLBACK* VCGetDimArrowModeFN) (short*);

short WINAPI VCGetDimArrowMode (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimArrowMode");
	if (fp)
	{
		return ((VCGetDimArrowModeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimArrowType ==============
typedef short (CALLBACK* VCGetDimArrowTypeFN) (short*);

short WINAPI VCGetDimArrowType (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimArrowType");
	if (fp)
	{
		return ((VCGetDimArrowTypeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimDecimalValue ==============
typedef short (CALLBACK* VCGetDimDecimalValueFN) (short*);

short WINAPI VCGetDimDecimalValue (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimDecimalValue");
	if (fp)
	{
		return ((VCGetDimDecimalValueFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimDisplayItemCount ==============
typedef short (CALLBACK* VCGetDimDisplayItemCountFN) (short*);

short WINAPI VCGetDimDisplayItemCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimDisplayItemCount");
	if (fp)
	{
		return ((VCGetDimDisplayItemCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimDisplayItemName ==============
typedef short (CALLBACK* VCGetDimDisplayItemNameFN) (short*, short, char*);

short WINAPI VCGetDimDisplayItemName (short* iError, short i, char* pS)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimDisplayItemName");
	if (fp)
	{
		return ((VCGetDimDisplayItemNameFN)fp)(iError, i, pS);
	}
	return iRet;
}

//============== VCGetDimDistFormat ==============
typedef short (CALLBACK* VCGetDimDistFormatFN) (short*);

short WINAPI VCGetDimDistFormat (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimDistFormat");
	if (fp)
	{
		return ((VCGetDimDistFormatFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimExtAbove ==============
typedef double (CALLBACK* VCGetDimExtAboveFN) (short*);

double WINAPI VCGetDimExtAbove (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimExtAbove");
	if (fp)
	{
		return ((VCGetDimExtAboveFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimExtAboveBP ==============
typedef void (CALLBACK* VCGetDimExtAboveBPFN) (short*, double*);

void WINAPI VCGetDimExtAboveBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimExtAboveBP");
	if (fp)
	{
		((VCGetDimExtAboveBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimExtBelow ==============
typedef double (CALLBACK* VCGetDimExtBelowFN) (short*);

double WINAPI VCGetDimExtBelow (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimExtBelow");
	if (fp)
	{
		return ((VCGetDimExtBelowFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimExtBelowBP ==============
typedef void (CALLBACK* VCGetDimExtBelowBPFN) (short*, double*);

void WINAPI VCGetDimExtBelowBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimExtBelowBP");
	if (fp)
	{
		((VCGetDimExtBelowBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimExtOffset ==============
typedef double (CALLBACK* VCGetDimExtOffsetFN) (short*);

double WINAPI VCGetDimExtOffset (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimExtOffset");
	if (fp)
	{
		return ((VCGetDimExtOffsetFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimExtOffsetBP ==============
typedef void (CALLBACK* VCGetDimExtOffsetBPFN) (short*, double*);

void WINAPI VCGetDimExtOffsetBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimExtOffsetBP");
	if (fp)
	{
		((VCGetDimExtOffsetBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimFont ==============
typedef short (CALLBACK* VCGetDimFontFN) (short*, char*);

short WINAPI VCGetDimFont (short* iError, char* pS)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimFont");
	if (fp)
	{
		return ((VCGetDimFontFN)fp)(iError, pS);
	}
	return iRet;
}

//============== VCGetDimFractionalValue ==============
typedef short (CALLBACK* VCGetDimFractionalValueFN) (short*);

short WINAPI VCGetDimFractionalValue (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimFractionalValue");
	if (fp)
	{
		return ((VCGetDimFractionalValueFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimItemColor ==============
typedef short (CALLBACK* VCGetDimItemColorFN) (short*, short);

short WINAPI VCGetDimItemColor (short* iError, short i)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimItemColor");
	if (fp)
	{
		return ((VCGetDimItemColorFN)fp)(iError, i);
	}
	return iRet;
}

//============== VCGetDimItemLineType ==============
typedef short (CALLBACK* VCGetDimItemLineTypeFN) (short*, short);

short WINAPI VCGetDimItemLineType (short* iError, short i)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimItemLineType");
	if (fp)
	{
		return ((VCGetDimItemLineTypeFN)fp)(iError, i);
	}
	return iRet;
}

//============== VCGetDimItemLineWidth ==============
typedef short (CALLBACK* VCGetDimItemLineWidthFN) (short*, short);

short WINAPI VCGetDimItemLineWidth (short* iError, short i)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimItemLineWidth");
	if (fp)
	{
		return ((VCGetDimItemLineWidthFN)fp)(iError, i);
	}
	return iRet;
}

//============== VCGetDimItemShow ==============
typedef vbool (CALLBACK* VCGetDimItemShowFN) (short*, short);

vbool WINAPI VCGetDimItemShow (short* iError, short i)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimItemShow");
	if (fp)
	{
		return ((VCGetDimItemShowFN)fp)(iError, i);
	}
	return vbRet;
}

//============== VCGetDimLayer ==============
typedef short (CALLBACK* VCGetDimLayerFN) (short*);

short WINAPI VCGetDimLayer (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimLayer");
	if (fp)
	{
		return ((VCGetDimLayerFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimLineAngle ==============
typedef double (CALLBACK* VCGetDimLineAngleFN) (short*);

double WINAPI VCGetDimLineAngle (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimLineAngle");
	if (fp)
	{
		return ((VCGetDimLineAngleFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimLineAngleBP ==============
typedef void (CALLBACK* VCGetDimLineAngleBPFN) (short*, double*);

void WINAPI VCGetDimLineAngleBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimLineAngleBP");
	if (fp)
	{
		((VCGetDimLineAngleBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimLineDirect ==============
typedef short (CALLBACK* VCGetDimLineDirectFN) (short*);

short WINAPI VCGetDimLineDirect (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimLineDirect");
	if (fp)
	{
		return ((VCGetDimLineDirectFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimLineText ==============
typedef short (CALLBACK* VCGetDimLineTextFN) (short*);

short WINAPI VCGetDimLineText (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimLineText");
	if (fp)
	{
		return ((VCGetDimLineTextFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimShowDash ==============
typedef vbool (CALLBACK* VCGetDimShowDashFN) (short*);

vbool WINAPI VCGetDimShowDash (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimShowDash");
	if (fp)
	{
		return ((VCGetDimShowDashFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDimShowLeadingZeros ==============
typedef short (CALLBACK* VCGetDimShowLeadingZerosFN) (short*);

short WINAPI VCGetDimShowLeadingZeros (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimShowLeadingZeros");
	if (fp)
	{
		return ((VCGetDimShowLeadingZerosFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimShowUnits ==============
typedef short (CALLBACK* VCGetDimShowUnitsFN) (short*);

short WINAPI VCGetDimShowUnits (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimShowUnits");
	if (fp)
	{
		return ((VCGetDimShowUnitsFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimTextAspect ==============
typedef double (CALLBACK* VCGetDimTextAspectFN) (short*);

double WINAPI VCGetDimTextAspect (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextAspect");
	if (fp)
	{
		return ((VCGetDimTextAspectFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimTextBold ==============
typedef vbool (CALLBACK* VCGetDimTextBoldFN) (short*);

vbool WINAPI VCGetDimTextBold (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextBold");
	if (fp)
	{
		return ((VCGetDimTextBoldFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDimTextCentered ==============
typedef vbool (CALLBACK* VCGetDimTextCenteredFN) (short*);

vbool WINAPI VCGetDimTextCentered (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextCentered");
	if (fp)
	{
		return ((VCGetDimTextCenteredFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDimTextCharSpace ==============
typedef double (CALLBACK* VCGetDimTextCharSpaceFN) (short*);

double WINAPI VCGetDimTextCharSpace (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextCharSpace");
	if (fp)
	{
		return ((VCGetDimTextCharSpaceFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimTextFillVText ==============
typedef vbool (CALLBACK* VCGetDimTextFillVTextFN) (short*);

vbool WINAPI VCGetDimTextFillVText (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextFillVText");
	if (fp)
	{
		return ((VCGetDimTextFillVTextFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDimTextHeight ==============
typedef double (CALLBACK* VCGetDimTextHeightFN) (short*);

double WINAPI VCGetDimTextHeight (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextHeight");
	if (fp)
	{
		return ((VCGetDimTextHeightFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimTextHeightBP ==============
typedef void (CALLBACK* VCGetDimTextHeightBPFN) (short*, double*);

void WINAPI VCGetDimTextHeightBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextHeightBP");
	if (fp)
	{
		((VCGetDimTextHeightBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimTextHorizSpace ==============
typedef double (CALLBACK* VCGetDimTextHorizSpaceFN) (short*);

double WINAPI VCGetDimTextHorizSpace (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextHorizSpace");
	if (fp)
	{
		return ((VCGetDimTextHorizSpaceFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimTextHorizSpaceBP ==============
typedef void (CALLBACK* VCGetDimTextHorizSpaceBPFN) (short*, double*);

void WINAPI VCGetDimTextHorizSpaceBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextHorizSpaceBP");
	if (fp)
	{
		((VCGetDimTextHorizSpaceBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimTextItalic ==============
typedef vbool (CALLBACK* VCGetDimTextItalicFN) (short*);

vbool WINAPI VCGetDimTextItalic (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextItalic");
	if (fp)
	{
		return ((VCGetDimTextItalicFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDimTextItalicAng ==============
typedef double (CALLBACK* VCGetDimTextItalicAngFN) (short*);

double WINAPI VCGetDimTextItalicAng (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextItalicAng");
	if (fp)
	{
		return ((VCGetDimTextItalicAngFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimTextLineSpace ==============
typedef double (CALLBACK* VCGetDimTextLineSpaceFN) (short*);

double WINAPI VCGetDimTextLineSpace (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextLineSpace");
	if (fp)
	{
		return ((VCGetDimTextLineSpaceFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimTextOverwrite ==============
typedef vbool (CALLBACK* VCGetDimTextOverwriteFN) (short*);

vbool WINAPI VCGetDimTextOverwrite (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextOverwrite");
	if (fp)
	{
		return ((VCGetDimTextOverwriteFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDimTextOverwriteString ==============
typedef short (CALLBACK* VCGetDimTextOverwriteStringFN) (short*, char*);

short WINAPI VCGetDimTextOverwriteString (short* iError, char* pB)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextOverwriteString");
	if (fp)
	{
		return ((VCGetDimTextOverwriteStringFN)fp)(iError, pB);
	}
	return iRet;
}

//============== VCGetDimTextPrefix ==============
typedef vbool (CALLBACK* VCGetDimTextPrefixFN) (short*);

vbool WINAPI VCGetDimTextPrefix (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextPrefix");
	if (fp)
	{
		return ((VCGetDimTextPrefixFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDimTextPrefixString ==============
typedef short (CALLBACK* VCGetDimTextPrefixStringFN) (short*, char*);

short WINAPI VCGetDimTextPrefixString (short* iError, char* pB)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextPrefixString");
	if (fp)
	{
		return ((VCGetDimTextPrefixStringFN)fp)(iError, pB);
	}
	return iRet;
}

//============== VCGetDimTextProSpacing ==============
typedef vbool (CALLBACK* VCGetDimTextProSpacingFN) (short*);

vbool WINAPI VCGetDimTextProSpacing (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextProSpacing");
	if (fp)
	{
		return ((VCGetDimTextProSpacingFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDimTextRotationType ==============
typedef short (CALLBACK* VCGetDimTextRotationTypeFN) (short*);

short WINAPI VCGetDimTextRotationType (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextRotationType");
	if (fp)
	{
		return ((VCGetDimTextRotationTypeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimTextScale ==============
typedef double (CALLBACK* VCGetDimTextScaleFN) (short*);

double WINAPI VCGetDimTextScale (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextScale");
	if (fp)
	{
		return ((VCGetDimTextScaleFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimTextScaleBP ==============
typedef void (CALLBACK* VCGetDimTextScaleBPFN) (short*, double*);

void WINAPI VCGetDimTextScaleBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextScaleBP");
	if (fp)
	{
		((VCGetDimTextScaleBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimTextSuffix ==============
typedef vbool (CALLBACK* VCGetDimTextSuffixFN) (short*);

vbool WINAPI VCGetDimTextSuffix (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextSuffix");
	if (fp)
	{
		return ((VCGetDimTextSuffixFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDimTextSuffixString ==============
typedef short (CALLBACK* VCGetDimTextSuffixStringFN) (short*, char*);

short WINAPI VCGetDimTextSuffixString (short* iError, char* pB)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextSuffixString");
	if (fp)
	{
		return ((VCGetDimTextSuffixStringFN)fp)(iError, pB);
	}
	return iRet;
}

//============== VCGetDimTextTolDecimal ==============
typedef short (CALLBACK* VCGetDimTextTolDecimalFN) (short*);

short WINAPI VCGetDimTextTolDecimal (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextTolDecimal");
	if (fp)
	{
		return ((VCGetDimTextTolDecimalFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimTextTolLowerVal ==============
typedef double (CALLBACK* VCGetDimTextTolLowerValFN) (short*);

double WINAPI VCGetDimTextTolLowerVal (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextTolLowerVal");
	if (fp)
	{
		return ((VCGetDimTextTolLowerValFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimTextTolLowerValBP ==============
typedef void (CALLBACK* VCGetDimTextTolLowerValBPFN) (short*, double*);

void WINAPI VCGetDimTextTolLowerValBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextTolLowerValBP");
	if (fp)
	{
		((VCGetDimTextTolLowerValBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimTextTolType ==============
typedef short (CALLBACK* VCGetDimTextTolTypeFN) (short*);

short WINAPI VCGetDimTextTolType (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextTolType");
	if (fp)
	{
		return ((VCGetDimTextTolTypeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDimTextTolUpperVal ==============
typedef double (CALLBACK* VCGetDimTextTolUpperValFN) (short*);

double WINAPI VCGetDimTextTolUpperVal (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextTolUpperVal");
	if (fp)
	{
		return ((VCGetDimTextTolUpperValFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimTextTolUpperValBP ==============
typedef void (CALLBACK* VCGetDimTextTolUpperValBPFN) (short*, double*);

void WINAPI VCGetDimTextTolUpperValBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextTolUpperValBP");
	if (fp)
	{
		((VCGetDimTextTolUpperValBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimTextUnderline ==============
typedef vbool (CALLBACK* VCGetDimTextUnderlineFN) (short*);

vbool WINAPI VCGetDimTextUnderline (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextUnderline");
	if (fp)
	{
		return ((VCGetDimTextUnderlineFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDimTextVertSpace ==============
typedef double (CALLBACK* VCGetDimTextVertSpaceFN) (short*);

double WINAPI VCGetDimTextVertSpace (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextVertSpace");
	if (fp)
	{
		return ((VCGetDimTextVertSpaceFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetDimTextVertSpaceBP ==============
typedef void (CALLBACK* VCGetDimTextVertSpaceBPFN) (short*, double*);

void WINAPI VCGetDimTextVertSpaceBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimTextVertSpaceBP");
	if (fp)
	{
		((VCGetDimTextVertSpaceBPFN)fp)(iError, dRet);
	}
}

//============== VCGetDimUnitConversionFactor ==============
typedef void (CALLBACK* VCGetDimUnitConversionFactorFN) (short*, double*);

void WINAPI VCGetDimUnitConversionFactor (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimUnitConversionFactor");
	if (fp)
	{
		((VCGetDimUnitConversionFactorFN)fp)(iError, dRet);
	}
}

//============== VCGetDimUseDimLayer ==============
typedef vbool (CALLBACK* VCGetDimUseDimLayerFN) (short*);

vbool WINAPI VCGetDimUseDimLayer (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDimUseDimLayer");
	if (fp)
	{
		return ((VCGetDimUseDimLayerFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDisplayAngleFormat ==============
typedef short (CALLBACK* VCGetDisplayAngleFormatFN) (short*);

short WINAPI VCGetDisplayAngleFormat (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayAngleFormat");
	if (fp)
	{
		return ((VCGetDisplayAngleFormatFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDisplayDecimalValue ==============
typedef short (CALLBACK* VCGetDisplayDecimalValueFN) (short*);

short WINAPI VCGetDisplayDecimalValue (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayDecimalValue");
	if (fp)
	{
		return ((VCGetDisplayDecimalValueFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDisplayDistFormat ==============
typedef short (CALLBACK* VCGetDisplayDistFormatFN) (short*);

short WINAPI VCGetDisplayDistFormat (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayDistFormat");
	if (fp)
	{
		return ((VCGetDisplayDistFormatFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDisplayFontNotFoundMessage ==============
typedef vbool (CALLBACK* VCGetDisplayFontNotFoundMessageFN) (short*);

vbool WINAPI VCGetDisplayFontNotFoundMessage (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayFontNotFoundMessage");
	if (fp)
	{
		return ((VCGetDisplayFontNotFoundMessageFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDisplayFractionalValue ==============
typedef short (CALLBACK* VCGetDisplayFractionalValueFN) (short*);

short WINAPI VCGetDisplayFractionalValue (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayFractionalValue");
	if (fp)
	{
		return ((VCGetDisplayFractionalValueFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDisplayHiddenLayersMessage ==============
typedef vbool (CALLBACK* VCGetDisplayHiddenLayersMessageFN) (short*);

vbool WINAPI VCGetDisplayHiddenLayersMessage (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayHiddenLayersMessage");
	if (fp)
	{
		return ((VCGetDisplayHiddenLayersMessageFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDisplayShowLeadingZeros ==============
typedef short (CALLBACK* VCGetDisplayShowLeadingZerosFN) (short*);

short WINAPI VCGetDisplayShowLeadingZeros (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayShowLeadingZeros");
	if (fp)
	{
		return ((VCGetDisplayShowLeadingZerosFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDisplayShowUnits ==============
typedef short (CALLBACK* VCGetDisplayShowUnitsFN) (short*);

short WINAPI VCGetDisplayShowUnits (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayShowUnits");
	if (fp)
	{
		return ((VCGetDisplayShowUnitsFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetDistanceHandle ==============
typedef long (CALLBACK* VCGetDistanceHandleFN) (void);

long WINAPI VCGetDistanceHandle (void)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDistanceHandle");
	if (fp)
	{
		return ((VCGetDistanceHandleFN)fp)();
	}
	return lRet;
}

//============== VCGetDllRunCmdLine ==============
typedef short (CALLBACK* VCGetDllRunCmdLineFN) (short*, char*);

short WINAPI VCGetDllRunCmdLine (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDllRunCmdLine");
	if (fp)
	{
		return ((VCGetDllRunCmdLineFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetDllRunFunction ==============
typedef short (CALLBACK* VCGetDllRunFunctionFN) (short*, char*);

short WINAPI VCGetDllRunFunction (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDllRunFunction");
	if (fp)
	{
		return ((VCGetDllRunFunctionFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetDllRunName ==============
typedef short (CALLBACK* VCGetDllRunNameFN) (short*, char*);

short WINAPI VCGetDllRunName (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDllRunName");
	if (fp)
	{
		return ((VCGetDllRunNameFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetDrawFBoundary ==============
typedef vbool (CALLBACK* VCGetDrawFBoundaryFN) (short*);

vbool WINAPI VCGetDrawFBoundary (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDrawFBoundary");
	if (fp)
	{
		return ((VCGetDrawFBoundaryFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDrawHBoundary ==============
typedef vbool (CALLBACK* VCGetDrawHBoundaryFN) (short*);

vbool WINAPI VCGetDrawHBoundary (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDrawHBoundary");
	if (fp)
	{
		return ((VCGetDrawHBoundaryFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetDrawingName ==============
typedef short (CALLBACK* VCGetDrawingNameFN) (char*);

short WINAPI VCGetDrawingName (char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDrawingName");
	if (fp)
	{
		return ((VCGetDrawingNameFN)fp)(pName);
	}
	return iRet;
}

//============== VCGetEmbAtbCount ==============
typedef short (CALLBACK* VCGetEmbAtbCountFN) (short*, short);

short WINAPI VCGetEmbAtbCount (short* iError, short iWhichSymbolDef)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetEmbAtbCount");
	if (fp)
	{
		return ((VCGetEmbAtbCountFN)fp)(iError, iWhichSymbolDef);
	}
	return iRet;
}

//============== VCGetEmbAtbLabel ==============
typedef short (CALLBACK* VCGetEmbAtbLabelFN) (short*, short, short, char*, short);

short WINAPI VCGetEmbAtbLabel (short* iError, short iWhichSymbolDef, short iWhichAtb, char* szLabel, short iRec)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetEmbAtbLabel");
	if (fp)
	{
		return ((VCGetEmbAtbLabelFN)fp)(iError, iWhichSymbolDef, iWhichAtb, szLabel, iRec);
	}
	return iRet;
}

//============== VCGetEmbAtbName ==============
typedef short (CALLBACK* VCGetEmbAtbNameFN) (short*, short, short, char*);

short WINAPI VCGetEmbAtbName (short* iError, short iWhichSymbolDef, short iWhichAtb, char* szName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetEmbAtbName");
	if (fp)
	{
		return ((VCGetEmbAtbNameFN)fp)(iError, iWhichSymbolDef, iWhichAtb, szName);
	}
	return iRet;
}

//============== VCGetEmbAtbRecordCount ==============
typedef short (CALLBACK* VCGetEmbAtbRecordCountFN) (short*, short, short);

short WINAPI VCGetEmbAtbRecordCount (short* iError, short iWhichSymbolDef, short iWhichAtb)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetEmbAtbRecordCount");
	if (fp)
	{
		return ((VCGetEmbAtbRecordCountFN)fp)(iError, iWhichSymbolDef, iWhichAtb);
	}
	return iRet;
}

//============== VCGetEmbAtbValue ==============
typedef short (CALLBACK* VCGetEmbAtbValueFN) (short*, short, short, char*, short);

short WINAPI VCGetEmbAtbValue (short* iError, short iWhichSymbolDef, short iWhichAtb, char* Value, short iRec)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetEmbAtbValue");
	if (fp)
	{
		return ((VCGetEmbAtbValueFN)fp)(iError, iWhichSymbolDef, iWhichAtb, Value, iRec);
	}
	return iRet;
}

//============== VCGetEntityContourCount ==============
typedef short (CALLBACK* VCGetEntityContourCountFN) (short*, ENTITYHANDLE);

short WINAPI VCGetEntityContourCount (short* iError, ENTITYHANDLE lH)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetEntityContourCount");
	if (fp)
	{
		return ((VCGetEntityContourCountFN)fp)(iError, lH);
	}
	return iRet;
}

//============== VCGetEntityRedoLevel ==============
typedef short (CALLBACK* VCGetEntityRedoLevelFN) (short*, ENTITYHANDLE);

short WINAPI VCGetEntityRedoLevel (short* iError, ENTITYHANDLE hE)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetEntityRedoLevel");
	if (fp)
	{
		return ((VCGetEntityRedoLevelFN)fp)(iError, hE);
	}
	return iRet;
}

//============== VCGetEntitySubEntityCount ==============
typedef short (CALLBACK* VCGetEntitySubEntityCountFN) (short*, ENTITYHANDLE, short);

short WINAPI VCGetEntitySubEntityCount (short* iError, ENTITYHANDLE lH, short iContour)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetEntitySubEntityCount");
	if (fp)
	{
		return ((VCGetEntitySubEntityCountFN)fp)(iError, lH, iContour);
	}
	return iRet;
}

//============== VCGetEntityUndoLevel ==============
typedef short (CALLBACK* VCGetEntityUndoLevelFN) (short*, ENTITYHANDLE);

short WINAPI VCGetEntityUndoLevel (short* iError, ENTITYHANDLE hE)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetEntityUndoLevel");
	if (fp)
	{
		return ((VCGetEntityUndoLevelFN)fp)(iError, hE);
	}
	return iRet;
}

//============== VCGetErasedEntityCount ==============
typedef long (CALLBACK* VCGetErasedEntityCountFN) (short*);

long WINAPI VCGetErasedEntityCount (short* iError)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetErasedEntityCount");
	if (fp)
	{
		return ((VCGetErasedEntityCountFN)fp)(iError);
	}
	return lRet;
}

//============== VCGetExplodeContinuousLines ==============
typedef BYTE (CALLBACK* VCGetExplodeContinuousLinesFN) (short*);

BYTE WINAPI VCGetExplodeContinuousLines (short* iError)
{
	BYTE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetExplodeContinuousLines");
	if (fp)
	{
		return ((VCGetExplodeContinuousLinesFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetFillColor ==============
typedef short (CALLBACK* VCGetFillColorFN) (short*);

short WINAPI VCGetFillColor (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFillColor");
	if (fp)
	{
		return ((VCGetFillColorFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetFillDisplay ==============
typedef vbool (CALLBACK* VCGetFillDisplayFN) (short*);

vbool WINAPI VCGetFillDisplay (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFillDisplay");
	if (fp)
	{
		return ((VCGetFillDisplayFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetFillVText ==============
typedef vbool (CALLBACK* VCGetFillVTextFN) (short*);

vbool WINAPI VCGetFillVText (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFillVText");
	if (fp)
	{
		return ((VCGetFillVTextFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetFilletPreview ==============
typedef vbool (CALLBACK* VCGetFilletPreviewFN) (short*);

vbool WINAPI VCGetFilletPreview (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFilletPreview");
	if (fp)
	{
		return ((VCGetFilletPreviewFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetFilletRad ==============
typedef double (CALLBACK* VCGetFilletRadFN) (short*);

double WINAPI VCGetFilletRad (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFilletRad");
	if (fp)
	{
		return ((VCGetFilletRadFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetFilletRadBP ==============
typedef void (CALLBACK* VCGetFilletRadBPFN) (short*, double*);

void WINAPI VCGetFilletRadBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFilletRadBP");
	if (fp)
	{
		((VCGetFilletRadBPFN)fp)(iError, dRet);
	}
}

//============== VCGetFilterColor ==============
typedef short (CALLBACK* VCGetFilterColorFN) (short*);

short WINAPI VCGetFilterColor (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFilterColor");
	if (fp)
	{
		return ((VCGetFilterColorFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetFilterKind ==============
typedef BYTE (CALLBACK* VCGetFilterKindFN) (short*);

BYTE WINAPI VCGetFilterKind (short* iError)
{
	BYTE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFilterKind");
	if (fp)
	{
		return ((VCGetFilterKindFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetFilterKind2 ==============
typedef BYTE (CALLBACK* VCGetFilterKind2FN) (short*);

BYTE WINAPI VCGetFilterKind2 (short* iError)
{
	BYTE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFilterKind2");
	if (fp)
	{
		return ((VCGetFilterKind2FN)fp)(iError);
	}
	return iRet;
}

//============== VCGetFilterLayer ==============
typedef short (CALLBACK* VCGetFilterLayerFN) (short*);

short WINAPI VCGetFilterLayer (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFilterLayer");
	if (fp)
	{
		return ((VCGetFilterLayerFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetFilterLineType ==============
typedef short (CALLBACK* VCGetFilterLineTypeFN) (short*);

short WINAPI VCGetFilterLineType (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFilterLineType");
	if (fp)
	{
		return ((VCGetFilterLineTypeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetFilterName ==============
typedef short (CALLBACK* VCGetFilterNameFN) (short*, char*);

short WINAPI VCGetFilterName (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFilterName");
	if (fp)
	{
		return ((VCGetFilterNameFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetFilterWidth ==============
typedef short (CALLBACK* VCGetFilterWidthFN) (short*);

short WINAPI VCGetFilterWidth (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFilterWidth");
	if (fp)
	{
		return ((VCGetFilterWidthFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetFontList ==============
typedef long (CALLBACK* VCGetFontListFN) (short*, char*);

long WINAPI VCGetFontList (short* iError, char* list)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFontList");
	if (fp)
	{
		return ((VCGetFontListFN)fp)(iError, list);
	}
	return lRet;
}

//============== VCGetFontName ==============
typedef short (CALLBACK* VCGetFontNameFN) (short*, short, char*);

short WINAPI VCGetFontName (short* iError, short iIndex, char* s)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFontName");
	if (fp)
	{
		return ((VCGetFontNameFN)fp)(iError, iIndex, s);
	}
	return iRet;
}

//============== VCGetFontNameCount ==============
typedef short (CALLBACK* VCGetFontNameCountFN) (short*);

short WINAPI VCGetFontNameCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFontNameCount");
	if (fp)
	{
		return ((VCGetFontNameCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetFrameInitialized ==============
typedef vbool (CALLBACK* VCGetFrameInitializedFN) (void);

vbool WINAPI VCGetFrameInitialized (void)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFrameInitialized");
	if (fp)
	{
		return ((VCGetFrameInitializedFN)fp)();
	}
	return vbRet;
}

//============== VCGetFunkeyCmdString ==============
typedef short (CALLBACK* VCGetFunkeyCmdStringFN) (char*, short, short);

short WINAPI VCGetFunkeyCmdString (char* szCmd, short iShift, short nVKey)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetFunkeyCmdString");
	if (fp)
	{
		return ((VCGetFunkeyCmdStringFN)fp)(szCmd, iShift, nVKey);
	}
	return iRet;
}

//============== VCGetGCDDefaultHatchName ==============
typedef short (CALLBACK* VCGetGCDDefaultHatchNameFN) (short*, char*);

short WINAPI VCGetGCDDefaultHatchName (short* iError, char* szName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetGCDDefaultHatchName");
	if (fp)
	{
		return ((VCGetGCDDefaultHatchNameFN)fp)(iError, szName);
	}
	return iRet;
}

//============== VCGetGCDPath ==============
typedef short (CALLBACK* VCGetGCDPathFN) (short*, char*);

short WINAPI VCGetGCDPath (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetGCDPath");
	if (fp)
	{
		return ((VCGetGCDPathFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetGridDisplay ==============
typedef vbool (CALLBACK* VCGetGridDisplayFN) (short*);

vbool WINAPI VCGetGridDisplay (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetGridDisplay");
	if (fp)
	{
		return ((VCGetGridDisplayFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetGridOrigin ==============
typedef Point2D (CALLBACK* VCGetGridOriginFN) (short*);

Point2D WINAPI VCGetGridOrigin (short* iError)
{
	Point2D dpRet;
	dpRet.x = dpRet.y = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetGridOrigin");
	if (fp)
	{
		return ((VCGetGridOriginFN)fp)(iError);
	}
	return dpRet;
}

//============== VCGetGridOriginBP ==============
typedef void (CALLBACK* VCGetGridOriginBPFN) (short*, Point2D*);

void WINAPI VCGetGridOriginBP (short* iError, Point2D* pRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetGridOriginBP");
	if (fp)
	{
		((VCGetGridOriginBPFN)fp)(iError, pRet);
	}
}

//============== VCGetGridSize ==============
typedef Point2D (CALLBACK* VCGetGridSizeFN) (short*);

Point2D WINAPI VCGetGridSize (short* iError)
{
	Point2D dpRet;
	dpRet.x = dpRet.y = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetGridSize");
	if (fp)
	{
		return ((VCGetGridSizeFN)fp)(iError);
	}
	return dpRet;
}

//============== VCGetGridSizeBP ==============
typedef void (CALLBACK* VCGetGridSizeBPFN) (short*, Point2D*);

void WINAPI VCGetGridSizeBP (short* iError, Point2D* pRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetGridSizeBP");
	if (fp)
	{
		((VCGetGridSizeBPFN)fp)(iError, pRet);
	}
}

//============== VCGetGridSnap ==============
typedef vbool (CALLBACK* VCGetGridSnapFN) (short*);

vbool WINAPI VCGetGridSnap (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetGridSnap");
	if (fp)
	{
		return ((VCGetGridSnapFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetHandlePt ==============
typedef vbool (CALLBACK* VCGetHandlePtFN) (short*);

vbool WINAPI VCGetHandlePt (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetHandlePt");
	if (fp)
	{
		return ((VCGetHandlePtFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetHatchColor ==============
typedef short (CALLBACK* VCGetHatchColorFN) (short*);

short WINAPI VCGetHatchColor (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetHatchColor");
	if (fp)
	{
		return ((VCGetHatchColorFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetHatchDisplay ==============
typedef vbool (CALLBACK* VCGetHatchDisplayFN) (short*);

vbool WINAPI VCGetHatchDisplay (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetHatchDisplay");
	if (fp)
	{
		return ((VCGetHatchDisplayFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetHatchName ==============
typedef short (CALLBACK* VCGetHatchNameFN) (short*, char*);

short WINAPI VCGetHatchName (short* iError, char* s)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetHatchName");
	if (fp)
	{
		return ((VCGetHatchNameFN)fp)(iError, s);
	}
	return iRet;
}

//============== VCGetHatchRot ==============
typedef double (CALLBACK* VCGetHatchRotFN) (short*);

double WINAPI VCGetHatchRot (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetHatchRot");
	if (fp)
	{
		return ((VCGetHatchRotFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetHatchRotBP ==============
typedef void (CALLBACK* VCGetHatchRotBPFN) (short*, double*);

void WINAPI VCGetHatchRotBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetHatchRotBP");
	if (fp)
	{
		((VCGetHatchRotBPFN)fp)(iError, dRet);
	}
}

//============== VCGetHatchScale ==============
typedef double (CALLBACK* VCGetHatchScaleFN) (short*);

double WINAPI VCGetHatchScale (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetHatchScale");
	if (fp)
	{
		return ((VCGetHatchScaleFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetHatchScaleBP ==============
typedef void (CALLBACK* VCGetHatchScaleBPFN) (short*, double*);

void WINAPI VCGetHatchScaleBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetHatchScaleBP");
	if (fp)
	{
		((VCGetHatchScaleBPFN)fp)(iError, dRet);
	}
}

//============== VCGetHighlight ==============
typedef vbool (CALLBACK* VCGetHighlightFN) (short*);

vbool WINAPI VCGetHighlight (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetHighlight");
	if (fp)
	{
		return ((VCGetHighlightFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetIncSnap ==============
typedef vbool (CALLBACK* VCGetIncSnapFN) (short*);

vbool WINAPI VCGetIncSnap (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetIncSnap");
	if (fp)
	{
		return ((VCGetIncSnapFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetIncSnapSize ==============
typedef double (CALLBACK* VCGetIncSnapSizeFN) (short*);

double WINAPI VCGetIncSnapSize (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetIncSnapSize");
	if (fp)
	{
		return ((VCGetIncSnapSizeFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetIncSnapSizeBP ==============
typedef void (CALLBACK* VCGetIncSnapSizeBPFN) (short*, double*);

void WINAPI VCGetIncSnapSizeBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetIncSnapSizeBP");
	if (fp)
	{
		((VCGetIncSnapSizeBPFN)fp)(iError, dRet);
	}
}

//============== VCGetInitCount ==============
typedef short (CALLBACK* VCGetInitCountFN) (void);

short WINAPI VCGetInitCount (void)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetInitCount");
	if (fp)
	{
		return ((VCGetInitCountFN)fp)();
	}
	return iRet;
}

//============== VCGetIsoMode ==============
typedef vbool (CALLBACK* VCGetIsoModeFN) (short*);

vbool WINAPI VCGetIsoMode (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetIsoMode");
	if (fp)
	{
		return ((VCGetIsoModeFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetIsoPlane ==============
typedef short (CALLBACK* VCGetIsoPlaneFN) (short*);

short WINAPI VCGetIsoPlane (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetIsoPlane");
	if (fp)
	{
		return ((VCGetIsoPlaneFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetKeepAcadFontName ==============
typedef BOOL (CALLBACK* VCGetKeepAcadFontNameFN) (short*);

BOOL WINAPI VCGetKeepAcadFontName (short* iError)
{
	BOOL iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetKeepAcadFontName");
	if (fp)
	{
		return ((VCGetKeepAcadFontNameFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetKeepGCDFontName ==============
typedef BOOL (CALLBACK* VCGetKeepGCDFontNameFN) (short*);

BOOL WINAPI VCGetKeepGCDFontName (short* iError)
{
	BOOL iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetKeepGCDFontName");
	if (fp)
	{
		return ((VCGetKeepGCDFontNameFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetKeepGCDHatch ==============
typedef BOOL (CALLBACK* VCGetKeepGCDHatchFN) (short*);

BOOL WINAPI VCGetKeepGCDHatch (short* iError)
{
	BOOL iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetKeepGCDHatch");
	if (fp)
	{
		return ((VCGetKeepGCDHatchFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetLTScaleDevice ==============
typedef double (CALLBACK* VCGetLTScaleDeviceFN) (short*);

double WINAPI VCGetLTScaleDevice (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLTScaleDevice");
	if (fp)
	{
		return ((VCGetLTScaleDeviceFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLTScaleDeviceBP ==============
typedef void (CALLBACK* VCGetLTScaleDeviceBPFN) (short*, double*);

void WINAPI VCGetLTScaleDeviceBP (short* iError, double* pRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLTScaleDeviceBP");
	if (fp)
	{
		((VCGetLTScaleDeviceBPFN)fp)(iError, pRet);
	}
}

//============== VCGetLTScaleWorld ==============
typedef double (CALLBACK* VCGetLTScaleWorldFN) (short*);

double WINAPI VCGetLTScaleWorld (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLTScaleWorld");
	if (fp)
	{
		return ((VCGetLTScaleWorldFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLTScaleWorldBP ==============
typedef void (CALLBACK* VCGetLTScaleWorldBPFN) (short*, double*);

void WINAPI VCGetLTScaleWorldBP (short* iError, double* pRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLTScaleWorldBP");
	if (fp)
	{
		((VCGetLTScaleWorldBPFN)fp)(iError, pRet);
	}
}

//============== VCGetLastPoint ==============
typedef void (CALLBACK* VCGetLastPointFN) (short*, Point2D*);

void WINAPI VCGetLastPoint (short* iError, Point2D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLastPoint");
	if (fp)
	{
		((VCGetLastPointFN)fp)(iError, dpP);
	}
}

//============== VCGetLayerDisplay ==============
typedef vbool (CALLBACK* VCGetLayerDisplayFN) (short*, short);

vbool WINAPI VCGetLayerDisplay (short* iError, short iIndex)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerDisplay");
	if (fp)
	{
		return ((VCGetLayerDisplayFN)fp)(iError, iIndex);
	}
	return vbRet;
}

//============== VCGetLayerHasData ==============
typedef vbool (CALLBACK* VCGetLayerHasDataFN) (short*, short);

vbool WINAPI VCGetLayerHasData (short* iError, short iIndex)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerHasData");
	if (fp)
	{
		return ((VCGetLayerHasDataFN)fp)(iError, iIndex);
	}
	return vbRet;
}

//============== VCGetLayerIndex ==============
typedef short (CALLBACK* VCGetLayerIndexFN) (short*);

short WINAPI VCGetLayerIndex (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerIndex");
	if (fp)
	{
		return ((VCGetLayerIndexFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetLayerIndexFromName ==============
typedef short (CALLBACK* VCGetLayerIndexFromNameFN) (short*, char*);

short WINAPI VCGetLayerIndexFromName (short* iError, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerIndexFromName");
	if (fp)
	{
		return ((VCGetLayerIndexFromNameFN)fp)(iError, pName);
	}
	return iRet;
}

//============== VCGetLayerNameFromIndex ==============
typedef short (CALLBACK* VCGetLayerNameFromIndexFN) (short*, short, char*);

short WINAPI VCGetLayerNameFromIndex (short* iError, short iIndex, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerNameFromIndex");
	if (fp)
	{
		return ((VCGetLayerNameFromIndexFN)fp)(iError, iIndex, pName);
	}
	return iRet;
}

//============== VCGetLayerProperties ==============
typedef vbool (CALLBACK* VCGetLayerPropertiesFN) (short*, short, short*, short*, short*, float*);

vbool WINAPI VCGetLayerProperties (short* iError, short iLayer, short* iColor, short* iLtype, short* iWidth, float* fWidth)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerProperties");
	if (fp)
	{
		return ((VCGetLayerPropertiesFN)fp)(iError, iLayer, iColor, iLtype, iWidth, fWidth);
	}
	return vbRet;
}

//============== VCGetLayerRedraw ==============
typedef vbool (CALLBACK* VCGetLayerRedrawFN) (short*);

vbool WINAPI VCGetLayerRedraw (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerRedraw");
	if (fp)
	{
		return ((VCGetLayerRedrawFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetLeaderArrowAngle ==============
typedef double (CALLBACK* VCGetLeaderArrowAngleFN) (short*);

double WINAPI VCGetLeaderArrowAngle (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderArrowAngle");
	if (fp)
	{
		return ((VCGetLeaderArrowAngleFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLeaderArrowLength ==============
typedef double (CALLBACK* VCGetLeaderArrowLengthFN) (short*);

double WINAPI VCGetLeaderArrowLength (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderArrowLength");
	if (fp)
	{
		return ((VCGetLeaderArrowLengthFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLeaderArrowMode ==============
typedef short (CALLBACK* VCGetLeaderArrowModeFN) (short*);

short WINAPI VCGetLeaderArrowMode (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderArrowMode");
	if (fp)
	{
		return ((VCGetLeaderArrowModeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetLeaderArrowType ==============
typedef short (CALLBACK* VCGetLeaderArrowTypeFN) (short*);

short WINAPI VCGetLeaderArrowType (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderArrowType");
	if (fp)
	{
		return ((VCGetLeaderArrowTypeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetLeaderFontName ==============
typedef short (CALLBACK* VCGetLeaderFontNameFN) (short*, char*);

short WINAPI VCGetLeaderFontName (short* iError, char* pS)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderFontName");
	if (fp)
	{
		return ((VCGetLeaderFontNameFN)fp)(iError, pS);
	}
	return iRet;
}

//============== VCGetLeaderShoulderLength ==============
typedef double (CALLBACK* VCGetLeaderShoulderLengthFN) (short*);

double WINAPI VCGetLeaderShoulderLength (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderShoulderLength");
	if (fp)
	{
		return ((VCGetLeaderShoulderLengthFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLeaderShoulderLengthBP ==============
typedef void (CALLBACK* VCGetLeaderShoulderLengthBPFN) (short*, double*);

void WINAPI VCGetLeaderShoulderLengthBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderShoulderLengthBP");
	if (fp)
	{
		((VCGetLeaderShoulderLengthBPFN)fp)(iError, dRet);
	}
}

//============== VCGetLeaderString ==============
typedef short (CALLBACK* VCGetLeaderStringFN) (short*, char*);

short WINAPI VCGetLeaderString (short* iError, char* s)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderString");
	if (fp)
	{
		return ((VCGetLeaderStringFN)fp)(iError, s);
	}
	return iRet;
}

//============== VCGetLeaderTextAspect ==============
typedef double (CALLBACK* VCGetLeaderTextAspectFN) (short*);

double WINAPI VCGetLeaderTextAspect (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextAspect");
	if (fp)
	{
		return ((VCGetLeaderTextAspectFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLeaderTextBold ==============
typedef vbool (CALLBACK* VCGetLeaderTextBoldFN) (short*);

vbool WINAPI VCGetLeaderTextBold (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextBold");
	if (fp)
	{
		return ((VCGetLeaderTextBoldFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetLeaderTextCharSpace ==============
typedef double (CALLBACK* VCGetLeaderTextCharSpaceFN) (short*);

double WINAPI VCGetLeaderTextCharSpace (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextCharSpace");
	if (fp)
	{
		return ((VCGetLeaderTextCharSpaceFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLeaderTextFillVText ==============
typedef vbool (CALLBACK* VCGetLeaderTextFillVTextFN) (short*);

vbool WINAPI VCGetLeaderTextFillVText (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextFillVText");
	if (fp)
	{
		return ((VCGetLeaderTextFillVTextFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetLeaderTextHeight ==============
typedef double (CALLBACK* VCGetLeaderTextHeightFN) (short*);

double WINAPI VCGetLeaderTextHeight (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextHeight");
	if (fp)
	{
		return ((VCGetLeaderTextHeightFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLeaderTextItalic ==============
typedef vbool (CALLBACK* VCGetLeaderTextItalicFN) (short*);

vbool WINAPI VCGetLeaderTextItalic (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextItalic");
	if (fp)
	{
		return ((VCGetLeaderTextItalicFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetLeaderTextItalicAng ==============
typedef double (CALLBACK* VCGetLeaderTextItalicAngFN) (short*);

double WINAPI VCGetLeaderTextItalicAng (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextItalicAng");
	if (fp)
	{
		return ((VCGetLeaderTextItalicAngFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLeaderTextLineSpace ==============
typedef double (CALLBACK* VCGetLeaderTextLineSpaceFN) (short*);

double WINAPI VCGetLeaderTextLineSpace (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextLineSpace");
	if (fp)
	{
		return ((VCGetLeaderTextLineSpaceFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLeaderTextOffset ==============
typedef double (CALLBACK* VCGetLeaderTextOffsetFN) (short*);

double WINAPI VCGetLeaderTextOffset (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextOffset");
	if (fp)
	{
		return ((VCGetLeaderTextOffsetFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetLeaderTextOffsetBP ==============
typedef void (CALLBACK* VCGetLeaderTextOffsetBPFN) (short*, double*);

void WINAPI VCGetLeaderTextOffsetBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextOffsetBP");
	if (fp)
	{
		((VCGetLeaderTextOffsetBPFN)fp)(iError, dRet);
	}
}

//============== VCGetLeaderTextProSpacing ==============
typedef vbool (CALLBACK* VCGetLeaderTextProSpacingFN) (short*);

vbool WINAPI VCGetLeaderTextProSpacing (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextProSpacing");
	if (fp)
	{
		return ((VCGetLeaderTextProSpacingFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetLeaderTextUnderline ==============
typedef vbool (CALLBACK* VCGetLeaderTextUnderlineFN) (short*);

vbool WINAPI VCGetLeaderTextUnderline (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLeaderTextUnderline");
	if (fp)
	{
		return ((VCGetLeaderTextUnderlineFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetLineTypeDisplay ==============
typedef vbool (CALLBACK* VCGetLineTypeDisplayFN) (short*);

vbool WINAPI VCGetLineTypeDisplay (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLineTypeDisplay");
	if (fp)
	{
		return ((VCGetLineTypeDisplayFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetLineTypeFromIndex ==============
typedef void (CALLBACK* VCGetLineTypeFromIndexFN) (short*, short, char*, short*, short*, double*);

void WINAPI VCGetLineTypeFromIndex (short* iError, short iIndex, char* pName, short* bCode, short* iDashCount, double* pDashes)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLineTypeFromIndex");
	if (fp)
	{
		((VCGetLineTypeFromIndexFN)fp)(iError, iIndex, pName, bCode, iDashCount, pDashes);
	}
}

//============== VCGetLineTypeIndex ==============
typedef short (CALLBACK* VCGetLineTypeIndexFN) (short*);

short WINAPI VCGetLineTypeIndex (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLineTypeIndex");
	if (fp)
	{
		return ((VCGetLineTypeIndexFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetLineTypeIndexFromEntityValue ==============
typedef short (CALLBACK* VCGetLineTypeIndexFromEntityValueFN) (short*, short);

short WINAPI VCGetLineTypeIndexFromEntityValue (short* iError, short iEntityValue)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLineTypeIndexFromEntityValue");
	if (fp)
	{
		return ((VCGetLineTypeIndexFromEntityValueFN)fp)(iError, iEntityValue);
	}
	return iRet;
}

//============== VCGetLineTypeIndexFromName ==============
typedef short (CALLBACK* VCGetLineTypeIndexFromNameFN) (short*, char*);

short WINAPI VCGetLineTypeIndexFromName (short* iError, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLineTypeIndexFromName");
	if (fp)
	{
		return ((VCGetLineTypeIndexFromNameFN)fp)(iError, pName);
	}
	return iRet;
}

//============== VCGetLineTypeNameFromIndex ==============
typedef short (CALLBACK* VCGetLineTypeNameFromIndexFN) (short*, short, char*);

short WINAPI VCGetLineTypeNameFromIndex (short* iError, short iIndex, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLineTypeNameFromIndex");
	if (fp)
	{
		return ((VCGetLineTypeNameFromIndexFN)fp)(iError, iIndex, pName);
	}
	return iRet;
}

//============== VCGetLineWidthDisplay ==============
typedef vbool (CALLBACK* VCGetLineWidthDisplayFN) (short*);

vbool WINAPI VCGetLineWidthDisplay (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLineWidthDisplay");
	if (fp)
	{
		return ((VCGetLineWidthDisplayFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetLineWidthIndex ==============
typedef short (CALLBACK* VCGetLineWidthIndexFN) (short*);

short WINAPI VCGetLineWidthIndex (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLineWidthIndex");
	if (fp)
	{
		return ((VCGetLineWidthIndexFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetLineWidthValue ==============
typedef void (CALLBACK* VCGetLineWidthValueFN) (short*, float*);

void WINAPI VCGetLineWidthValue (short* iError, float* dV)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLineWidthValue");
	if (fp)
	{
		((VCGetLineWidthValueFN)fp)(iError, dV);
	}
}

//============== VCGetMDICount ==============
typedef short (CALLBACK* VCGetMDICountFN) (short*);

short WINAPI VCGetMDICount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetMDICount");
	if (fp)
	{
		return ((VCGetMDICountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetMajorVersion ==============
typedef short (CALLBACK* VCGetMajorVersionFN) (void);

short WINAPI VCGetMajorVersion (void)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetMajorVersion");
	if (fp)
	{
		return ((VCGetMajorVersionFN)fp)();
	}
	return iRet;
}

//============== VCGetMapAcadPolylineWidths ==============
typedef vbool (CALLBACK* VCGetMapAcadPolylineWidthsFN) (short*);

vbool WINAPI VCGetMapAcadPolylineWidths (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetMapAcadPolylineWidths");
	if (fp)
	{
		return ((VCGetMapAcadPolylineWidthsFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetMeasureValues ==============
typedef void (CALLBACK* VCGetMeasureValuesFN) (short*, double*, double*, double*, double*, double*);

void WINAPI VCGetMeasureValues (short* iError, double* dSegmentDist, double* dDist, double* dArea, double* dAngle, double* dAngle3Point)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetMeasureValues");
	if (fp)
	{
		((VCGetMeasureValuesFN)fp)(iError, dSegmentDist, dDist, dArea, dAngle, dAngle3Point);
	}
}

//============== VCGetMenu ==============
typedef short (CALLBACK* VCGetMenuFN) (short*, char*);

short WINAPI VCGetMenu (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetMenu");
	if (fp)
	{
		return ((VCGetMenuFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetMessageHandle ==============
typedef long (CALLBACK* VCGetMessageHandleFN) (void);

long WINAPI VCGetMessageHandle (void)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetMessageHandle");
	if (fp)
	{
		return ((VCGetMessageHandleFN)fp)();
	}
	return lRet;
}

//============== VCGetMinorDotVersion ==============
typedef short (CALLBACK* VCGetMinorDotVersionFN) (void);

short WINAPI VCGetMinorDotVersion (void)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetMinorDotVersion");
	if (fp)
	{
		return ((VCGetMinorDotVersionFN)fp)();
	}
	return iRet;
}

//============== VCGetMinorInternalVersion ==============
typedef short (CALLBACK* VCGetMinorInternalVersionFN) (void);

short WINAPI VCGetMinorInternalVersion (void)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetMinorInternalVersion");
	if (fp)
	{
		return ((VCGetMinorInternalVersionFN)fp)();
	}
	return iRet;
}

//============== VCGetMinorVersion ==============
typedef short (CALLBACK* VCGetMinorVersionFN) (void);

short WINAPI VCGetMinorVersion (void)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetMinorVersion");
	if (fp)
	{
		return ((VCGetMinorVersionFN)fp)();
	}
	return iRet;
}

//============== VCGetNumCopies ==============
typedef double (CALLBACK* VCGetNumCopiesFN) (short*);

double WINAPI VCGetNumCopies (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetNumCopies");
	if (fp)
	{
		return ((VCGetNumCopiesFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetNumCopiesBP ==============
typedef void (CALLBACK* VCGetNumCopiesBPFN) (short*, double*);

void WINAPI VCGetNumCopiesBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetNumCopiesBP");
	if (fp)
	{
		((VCGetNumCopiesBPFN)fp)(iError, dRet);
	}
}

//============== VCGetNumRows ==============
typedef short (CALLBACK* VCGetNumRowsFN) (short*);

short WINAPI VCGetNumRows (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetNumRows");
	if (fp)
	{
		return ((VCGetNumRowsFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetOffsetDist ==============
typedef double (CALLBACK* VCGetOffsetDistFN) (short*);

double WINAPI VCGetOffsetDist (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOffsetDist");
	if (fp)
	{
		return ((VCGetOffsetDistFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetOffsetDistBP ==============
typedef void (CALLBACK* VCGetOffsetDistBPFN) (short*, double*);

void WINAPI VCGetOffsetDistBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOffsetDistBP");
	if (fp)
	{
		((VCGetOffsetDistBPFN)fp)(iError, dRet);
	}
}

//============== VCGetOffsetFixed ==============
typedef vbool (CALLBACK* VCGetOffsetFixedFN) (short*);

vbool WINAPI VCGetOffsetFixed (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOffsetFixed");
	if (fp)
	{
		return ((VCGetOffsetFixedFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetOleDllClassName ==============
typedef short (CALLBACK* VCGetOleDllClassNameFN) (short*, char*);

short WINAPI VCGetOleDllClassName (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOleDllClassName");
	if (fp)
	{
		return ((VCGetOleDllClassNameFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetOleDllFunctionCmdLine ==============
typedef short (CALLBACK* VCGetOleDllFunctionCmdLineFN) (short*, char*);

short WINAPI VCGetOleDllFunctionCmdLine (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOleDllFunctionCmdLine");
	if (fp)
	{
		return ((VCGetOleDllFunctionCmdLineFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetOleDllFunctionName ==============
typedef short (CALLBACK* VCGetOleDllFunctionNameFN) (short*, char*);

short WINAPI VCGetOleDllFunctionName (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOleDllFunctionName");
	if (fp)
	{
		return ((VCGetOleDllFunctionNameFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetOleDllName ==============
typedef short (CALLBACK* VCGetOleDllNameFN) (short*, char*);

short WINAPI VCGetOleDllName (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOleDllName");
	if (fp)
	{
		return ((VCGetOleDllNameFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetOrdinateTextOffset ==============
typedef double (CALLBACK* VCGetOrdinateTextOffsetFN) (short*);

double WINAPI VCGetOrdinateTextOffset (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOrdinateTextOffset");
	if (fp)
	{
		return ((VCGetOrdinateTextOffsetFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetOrthoAng ==============
typedef double (CALLBACK* VCGetOrthoAngFN) (short*);

double WINAPI VCGetOrthoAng (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOrthoAng");
	if (fp)
	{
		return ((VCGetOrthoAngFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetOrthoAngBP ==============
typedef void (CALLBACK* VCGetOrthoAngBPFN) (short*, double*);

void WINAPI VCGetOrthoAngBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOrthoAngBP");
	if (fp)
	{
		((VCGetOrthoAngBPFN)fp)(iError, dRet);
	}
}

//============== VCGetOrthoMode ==============
typedef vbool (CALLBACK* VCGetOrthoModeFN) (short*);

vbool WINAPI VCGetOrthoMode (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetOrthoMode");
	if (fp)
	{
		return ((VCGetOrthoModeFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetPointDisplay ==============
typedef vbool (CALLBACK* VCGetPointDisplayFN) (short*);

vbool WINAPI VCGetPointDisplay (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetPointDisplay");
	if (fp)
	{
		return ((VCGetPointDisplayFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetPopupButton ==============
typedef short (CALLBACK* VCGetPopupButtonFN) (short*);

short WINAPI VCGetPopupButton (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetPopupButton");
	if (fp)
	{
		return ((VCGetPopupButtonFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetPreserveAcadColorNums ==============
typedef BOOL (CALLBACK* VCGetPreserveAcadColorNumsFN) (short*);

BOOL WINAPI VCGetPreserveAcadColorNums (short* iError)
{
	BOOL iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetPreserveAcadColorNums");
	if (fp)
	{
		return ((VCGetPreserveAcadColorNumsFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetQuickSearch ==============
typedef vbool (CALLBACK* VCGetQuickSearchFN) (short*);

vbool WINAPI VCGetQuickSearch (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetQuickSearch");
	if (fp)
	{
		return ((VCGetQuickSearchFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetRPolyInscribe ==============
typedef vbool (CALLBACK* VCGetRPolyInscribeFN) (short*);

vbool WINAPI VCGetRPolyInscribe (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRPolyInscribe");
	if (fp)
	{
		return ((VCGetRPolyInscribeFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetRPolySides ==============
typedef short (CALLBACK* VCGetRPolySidesFN) (short*);

short WINAPI VCGetRPolySides (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRPolySides");
	if (fp)
	{
		return ((VCGetRPolySidesFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetRadCopies ==============
typedef short (CALLBACK* VCGetRadCopiesFN) (short*);

short WINAPI VCGetRadCopies (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRadCopies");
	if (fp)
	{
		return ((VCGetRadCopiesFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetReadOnly ==============
typedef vbool (CALLBACK* VCGetReadOnlyFN) (short*, short*);

vbool WINAPI VCGetReadOnly (short* iError, short* iReadOnly)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetReadOnly");
	if (fp)
	{
		return ((VCGetReadOnlyFN)fp)(iError, iReadOnly);
	}
	return vbRet;
}

//============== VCGetRefFrame ==============
typedef void (CALLBACK* VCGetRefFrameFN) (short*, Point2D*, Point2D*);

void WINAPI VCGetRefFrame (short* iError, Point2D* dpLL, Point2D* dpUR)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRefFrame");
	if (fp)
	{
		((VCGetRefFrameFN)fp)(iError, dpLL, dpUR);
	}
}

//============== VCGetRefFrameColor ==============
typedef short (CALLBACK* VCGetRefFrameColorFN) (short*);

short WINAPI VCGetRefFrameColor (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRefFrameColor");
	if (fp)
	{
		return ((VCGetRefFrameColorFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetRefFrameDrawBoundary ==============
typedef vbool (CALLBACK* VCGetRefFrameDrawBoundaryFN) (short*);

vbool WINAPI VCGetRefFrameDrawBoundary (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRefFrameDrawBoundary");
	if (fp)
	{
		return ((VCGetRefFrameDrawBoundaryFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetRefFrameIsDataBound ==============
typedef vbool (CALLBACK* VCGetRefFrameIsDataBoundFN) (short*);

vbool WINAPI VCGetRefFrameIsDataBound (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRefFrameIsDataBound");
	if (fp)
	{
		return ((VCGetRefFrameIsDataBoundFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetRefFrameLineWidth ==============
typedef short (CALLBACK* VCGetRefFrameLineWidthFN) (short*);

short WINAPI VCGetRefFrameLineWidth (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRefFrameLineWidth");
	if (fp)
	{
		return ((VCGetRefFrameLineWidthFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetRefFrameName ==============
typedef short (CALLBACK* VCGetRefFrameNameFN) (short*, char*);

short WINAPI VCGetRefFrameName (short* iError, char* s)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRefFrameName");
	if (fp)
	{
		return ((VCGetRefFrameNameFN)fp)(iError, s);
	}
	return iRet;
}

//============== VCGetRefFrameOffset ==============
typedef void (CALLBACK* VCGetRefFrameOffsetFN) (short*, Point2D*);

void WINAPI VCGetRefFrameOffset (short* iError, Point2D* dpOffset)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRefFrameOffset");
	if (fp)
	{
		((VCGetRefFrameOffsetFN)fp)(iError, dpOffset);
	}
}

//============== VCGetRefFrameRot ==============
typedef void (CALLBACK* VCGetRefFrameRotFN) (short*, double*);

void WINAPI VCGetRefFrameRot (short* iError, double* dR)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRefFrameRot");
	if (fp)
	{
		((VCGetRefFrameRotFN)fp)(iError, dR);
	}
}

//============== VCGetRefFrameScale ==============
typedef void (CALLBACK* VCGetRefFrameScaleFN) (short*, Point2D*);

void WINAPI VCGetRefFrameScale (short* iError, Point2D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRefFrameScale");
	if (fp)
	{
		((VCGetRefFrameScaleFN)fp)(iError, dpP);
	}
}

//============== VCGetRefFrameViewWidthHeight ==============
typedef void (CALLBACK* VCGetRefFrameViewWidthHeightFN) (short*, Point2D*);

void WINAPI VCGetRefFrameViewWidthHeight (short* iError, Point2D* dpWidthHeight)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRefFrameViewWidthHeight");
	if (fp)
	{
		((VCGetRefFrameViewWidthHeightFN)fp)(iError, dpWidthHeight);
	}
}

//============== VCGetReplaceWithSymbol ==============
typedef vbool (CALLBACK* VCGetReplaceWithSymbolFN) (short*);

vbool WINAPI VCGetReplaceWithSymbol (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetReplaceWithSymbol");
	if (fp)
	{
		return ((VCGetReplaceWithSymbolFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetRubberBandColor ==============
typedef short (CALLBACK* VCGetRubberBandColorFN) (short*);

short WINAPI VCGetRubberBandColor (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetRubberBandColor");
	if (fp)
	{
		return ((VCGetRubberBandColorFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetSCRPath ==============
typedef short (CALLBACK* VCGetSCRPathFN) (short*, char*);

short WINAPI VCGetSCRPath (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSCRPath");
	if (fp)
	{
		return ((VCGetSCRPathFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetSYSPath ==============
typedef short (CALLBACK* VCGetSYSPathFN) (short*, char*);

short WINAPI VCGetSYSPath (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSYSPath");
	if (fp)
	{
		return ((VCGetSYSPathFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetSaveEnvOnExit ==============
typedef vbool (CALLBACK* VCGetSaveEnvOnExitFN) (short*);

vbool WINAPI VCGetSaveEnvOnExit (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSaveEnvOnExit");
	if (fp)
	{
		return ((VCGetSaveEnvOnExitFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetSavePaths ==============
typedef vbool (CALLBACK* VCGetSavePathsFN) (short*);

vbool WINAPI VCGetSavePaths (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSavePaths");
	if (fp)
	{
		return ((VCGetSavePathsFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetScale ==============
typedef double (CALLBACK* VCGetScaleFN) (short*);

double WINAPI VCGetScale (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetScale");
	if (fp)
	{
		return ((VCGetScaleFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetScaleX ==============
typedef double (CALLBACK* VCGetScaleXFN) (short*);

double WINAPI VCGetScaleX (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetScaleX");
	if (fp)
	{
		return ((VCGetScaleXFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetScaleXBP ==============
typedef void (CALLBACK* VCGetScaleXBPFN) (short*, double*);

void WINAPI VCGetScaleXBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetScaleXBP");
	if (fp)
	{
		((VCGetScaleXBPFN)fp)(iError, dRet);
	}
}

//============== VCGetScaleXY ==============
typedef Point2D (CALLBACK* VCGetScaleXYFN) (short*);

Point2D WINAPI VCGetScaleXY (short* iError)
{
	Point2D dpRet;
	dpRet.x = dpRet.y = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetScaleXY");
	if (fp)
	{
		return ((VCGetScaleXYFN)fp)(iError);
	}
	return dpRet;
}

//============== VCGetScaleXYBP ==============
typedef void (CALLBACK* VCGetScaleXYBPFN) (short*, Point2D*);

void WINAPI VCGetScaleXYBP (short* iError, Point2D* pRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetScaleXYBP");
	if (fp)
	{
		((VCGetScaleXYBPFN)fp)(iError, pRet);
	}
}

//============== VCGetScaleY ==============
typedef double (CALLBACK* VCGetScaleYFN) (short*);

double WINAPI VCGetScaleY (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetScaleY");
	if (fp)
	{
		return ((VCGetScaleYFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetScaleYBP ==============
typedef void (CALLBACK* VCGetScaleYBPFN) (short*, double*);

void WINAPI VCGetScaleYBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetScaleYBP");
	if (fp)
	{
		((VCGetScaleYBPFN)fp)(iError, dRet);
	}
}

//============== VCGetSecondaryDistFormat ==============
typedef short (CALLBACK* VCGetSecondaryDistFormatFN) (short*);

short WINAPI VCGetSecondaryDistFormat (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSecondaryDistFormat");
	if (fp)
	{
		return ((VCGetSecondaryDistFormatFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetSelectionColor ==============
typedef short (CALLBACK* VCGetSelectionColorFN) (short*);

short WINAPI VCGetSelectionColor (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSelectionColor");
	if (fp)
	{
		return ((VCGetSelectionColorFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetSelectionContextEditIds ==============
typedef short (CALLBACK* VCGetSelectionContextEditIdsFN) (long*, short);

short WINAPI VCGetSelectionContextEditIds (long* pIds, short iMax)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSelectionContextEditIds");
	if (fp)
	{
		return ((VCGetSelectionContextEditIdsFN)fp)(pIds, iMax);
	}
	return iRet;
}

//============== VCGetShiftClick ==============
typedef vbool (CALLBACK* VCGetShiftClickFN) (short*);

vbool WINAPI VCGetShiftClick (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetShiftClick");
	if (fp)
	{
		return ((VCGetShiftClickFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetShortLayerList ==============
typedef vbool (CALLBACK* VCGetShortLayerListFN) (short*);

vbool WINAPI VCGetShortLayerList (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetShortLayerList");
	if (fp)
	{
		return ((VCGetShortLayerListFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetShowAngleSeconds ==============
typedef vbool (CALLBACK* VCGetShowAngleSecondsFN) (short*);

vbool WINAPI VCGetShowAngleSeconds (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetShowAngleSeconds");
	if (fp)
	{
		return ((VCGetShowAngleSecondsFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetShowDimAngleSeconds ==============
typedef vbool (CALLBACK* VCGetShowDimAngleSecondsFN) (short*);

vbool WINAPI VCGetShowDimAngleSeconds (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetShowDimAngleSeconds");
	if (fp)
	{
		return ((VCGetShowDimAngleSecondsFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetShowDrag ==============
typedef vbool (CALLBACK* VCGetShowDragFN) (short*);

vbool WINAPI VCGetShowDrag (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetShowDrag");
	if (fp)
	{
		return ((VCGetShowDragFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetShowSecondaryUnit ==============
typedef vbool (CALLBACK* VCGetShowSecondaryUnitFN) (short*);

vbool WINAPI VCGetShowSecondaryUnit (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetShowSecondaryUnit");
	if (fp)
	{
		return ((VCGetShowSecondaryUnitFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetShowSingleUnitFrac ==============
typedef vbool (CALLBACK* VCGetShowSingleUnitFracFN) (short*);

vbool WINAPI VCGetShowSingleUnitFrac (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetShowSingleUnitFrac");
	if (fp)
	{
		return ((VCGetShowSingleUnitFracFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetShowTangentPoints ==============
typedef vbool (CALLBACK* VCGetShowTangentPointsFN) (short*);

vbool WINAPI VCGetShowTangentPoints (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetShowTangentPoints");
	if (fp)
	{
		return ((VCGetShowTangentPointsFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetSnapPercentVal ==============
typedef double (CALLBACK* VCGetSnapPercentValFN) (short*);

double WINAPI VCGetSnapPercentVal (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSnapPercentVal");
	if (fp)
	{
		return ((VCGetSnapPercentValFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetSnapPercentValBP ==============
typedef void (CALLBACK* VCGetSnapPercentValBPFN) (short*, double*);

void WINAPI VCGetSnapPercentValBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSnapPercentValBP");
	if (fp)
	{
		((VCGetSnapPercentValBPFN)fp)(iError, dRet);
	}
}

//============== VCGetSolid ==============
typedef vbool (CALLBACK* VCGetSolidFN) (short*);

vbool WINAPI VCGetSolid (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSolid");
	if (fp)
	{
		return ((VCGetSolidFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetSpanAngle ==============
typedef double (CALLBACK* VCGetSpanAngleFN) (short*);

double WINAPI VCGetSpanAngle (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSpanAngle");
	if (fp)
	{
		return ((VCGetSpanAngleFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetSpanAngleBP ==============
typedef void (CALLBACK* VCGetSpanAngleBPFN) (short*, double*);

void WINAPI VCGetSpanAngleBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSpanAngleBP");
	if (fp)
	{
		((VCGetSpanAngleBPFN)fp)(iError, dRet);
	}
}

//============== VCGetStyleIndex ==============
typedef BYTE (CALLBACK* VCGetStyleIndexFN) (short*);

BYTE WINAPI VCGetStyleIndex (short* iError)
{
	BYTE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetStyleIndex");
	if (fp)
	{
		return ((VCGetStyleIndexFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetSym3DName ==============
typedef short (CALLBACK* VCGetSym3DNameFN) (short*, char*);

short WINAPI VCGetSym3DName (short* iError, char* pS)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSym3DName");
	if (fp)
	{
		return ((VCGetSym3DNameFN)fp)(iError, pS);
	}
	return iRet;
}

//============== VCGetSym3DNormal ==============
typedef void (CALLBACK* VCGetSym3DNormalFN) (short*, Point3D*);

void WINAPI VCGetSym3DNormal (short* iError, Point3D* normal)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSym3DNormal");
	if (fp)
	{
		((VCGetSym3DNormalFN)fp)(iError, normal);
	}
}

//============== VCGetSym3DRot ==============
typedef void (CALLBACK* VCGetSym3DRotFN) (short*, double*);

void WINAPI VCGetSym3DRot (short* iError, double* dV)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSym3DRot");
	if (fp)
	{
		((VCGetSym3DRotFN)fp)(iError, dV);
	}
}

//============== VCGetSym3DScale ==============
typedef void (CALLBACK* VCGetSym3DScaleFN) (short*, Point3D*);

void WINAPI VCGetSym3DScale (short* iError, Point3D* dpScale)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSym3DScale");
	if (fp)
	{
		((VCGetSym3DScaleFN)fp)(iError, dpScale);
	}
}

//============== VCGetSymAutoExplode ==============
typedef vbool (CALLBACK* VCGetSymAutoExplodeFN) (short*);

vbool WINAPI VCGetSymAutoExplode (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymAutoExplode");
	if (fp)
	{
		return ((VCGetSymAutoExplodeFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetSymExplode ==============
typedef short (CALLBACK* VCGetSymExplodeFN) (short*);

short WINAPI VCGetSymExplode (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymExplode");
	if (fp)
	{
		return ((VCGetSymExplodeFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetSymName ==============
typedef short (CALLBACK* VCGetSymNameFN) (short*, char*);

short WINAPI VCGetSymName (short* iError, char* pS)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymName");
	if (fp)
	{
		return ((VCGetSymNameFN)fp)(iError, pS);
	}
	return iRet;
}

//============== VCGetSymRot ==============
typedef double (CALLBACK* VCGetSymRotFN) (short*);

double WINAPI VCGetSymRot (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymRot");
	if (fp)
	{
		return ((VCGetSymRotFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetSymRotBP ==============
typedef void (CALLBACK* VCGetSymRotBPFN) (short*, double*);

void WINAPI VCGetSymRotBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymRotBP");
	if (fp)
	{
		((VCGetSymRotBPFN)fp)(iError, dRet);
	}
}

//============== VCGetSymScale ==============
typedef Point2D (CALLBACK* VCGetSymScaleFN) (short*);

Point2D WINAPI VCGetSymScale (short* iError)
{
	Point2D dpRet;
	dpRet.x = dpRet.y = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymScale");
	if (fp)
	{
		return ((VCGetSymScaleFN)fp)(iError);
	}
	return dpRet;
}

//============== VCGetSymScaleBP ==============
typedef void (CALLBACK* VCGetSymScaleBPFN) (short*, Point2D*);

void WINAPI VCGetSymScaleBP (short* iError, Point2D* pRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymScaleBP");
	if (fp)
	{
		((VCGetSymScaleBPFN)fp)(iError, pRet);
	}
}

//============== VCGetSymScaleX ==============
typedef double (CALLBACK* VCGetSymScaleXFN) (short*);

double WINAPI VCGetSymScaleX (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymScaleX");
	if (fp)
	{
		return ((VCGetSymScaleXFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetSymScaleXBP ==============
typedef void (CALLBACK* VCGetSymScaleXBPFN) (short*, double*);

void WINAPI VCGetSymScaleXBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymScaleXBP");
	if (fp)
	{
		((VCGetSymScaleXBPFN)fp)(iError, dRet);
	}
}

//============== VCGetSymScaleY ==============
typedef double (CALLBACK* VCGetSymScaleYFN) (short*);

double WINAPI VCGetSymScaleY (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymScaleY");
	if (fp)
	{
		return ((VCGetSymScaleYFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetSymScaleYBP ==============
typedef void (CALLBACK* VCGetSymScaleYBPFN) (short*, double*);

void WINAPI VCGetSymScaleYBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymScaleYBP");
	if (fp)
	{
		((VCGetSymScaleYBPFN)fp)(iError, dRet);
	}
}

//============== VCGetSymSnap ==============
typedef vbool (CALLBACK* VCGetSymSnapFN) (short*);

vbool WINAPI VCGetSymSnap (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymSnap");
	if (fp)
	{
		return ((VCGetSymSnapFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetSymbolDefCount ==============
typedef short (CALLBACK* VCGetSymbolDefCountFN) (void);

short WINAPI VCGetSymbolDefCount (void)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymbolDefCount");
	if (fp)
	{
		return ((VCGetSymbolDefCountFN)fp)();
	}
	return iRet;
}

//============== VCGetSymbolDefEntityCount ==============
typedef short (CALLBACK* VCGetSymbolDefEntityCountFN) (short);

short WINAPI VCGetSymbolDefEntityCount (short i)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymbolDefEntityCount");
	if (fp)
	{
		return ((VCGetSymbolDefEntityCountFN)fp)(i);
	}
	return iRet;
}

//============== VCGetSymbolIndex ==============
typedef short (CALLBACK* VCGetSymbolIndexFN) (short*, char*);

short WINAPI VCGetSymbolIndex (short* iError, char* pName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymbolIndex");
	if (fp)
	{
		return ((VCGetSymbolIndexFN)fp)(iError, pName);
	}
	return iRet;
}

//============== VCGetSymbolInternalName ==============
typedef short (CALLBACK* VCGetSymbolInternalNameFN) (short*, char*, char*);

short WINAPI VCGetSymbolInternalName (short* iError, char* pFileName, char* pReturn)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymbolInternalName");
	if (fp)
	{
		return ((VCGetSymbolInternalNameFN)fp)(iError, pFileName, pReturn);
	}
	return iRet;
}

//============== VCGetSymbolName ==============
typedef short (CALLBACK* VCGetSymbolNameFN) (char*, short);

short WINAPI VCGetSymbolName (char* pName, short i)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymbolName");
	if (fp)
	{
		return ((VCGetSymbolNameFN)fp)(pName, i);
	}
	return iRet;
}

//============== VCGetSymbolPlacementCount ==============
typedef short (CALLBACK* VCGetSymbolPlacementCountFN) (short);

short WINAPI VCGetSymbolPlacementCount (short i)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSymbolPlacementCount");
	if (fp)
	{
		return ((VCGetSymbolPlacementCountFN)fp)(i);
	}
	return iRet;
}

//============== VCGetSystemHatchName ==============
typedef short (CALLBACK* VCGetSystemHatchNameFN) (short*, char*, short);

short WINAPI VCGetSystemHatchName (short* iError, char* pName, short i)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSystemHatchName");
	if (fp)
	{
		return ((VCGetSystemHatchNameFN)fp)(iError, pName, i);
	}
	return iRet;
}

//============== VCGetSystemHatchNameCount ==============
typedef short (CALLBACK* VCGetSystemHatchNameCountFN) (void);

short WINAPI VCGetSystemHatchNameCount (void)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSystemHatchNameCount");
	if (fp)
	{
		return ((VCGetSystemHatchNameCountFN)fp)();
	}
	return iRet;
}

//============== VCGetTextAspect ==============
typedef double (CALLBACK* VCGetTextAspectFN) (short*);

double WINAPI VCGetTextAspect (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextAspect");
	if (fp)
	{
		return ((VCGetTextAspectFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetTextAspectBP ==============
typedef void (CALLBACK* VCGetTextAspectBPFN) (short*, double*);

void WINAPI VCGetTextAspectBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextAspectBP");
	if (fp)
	{
		((VCGetTextAspectBPFN)fp)(iError, dRet);
	}
}

//============== VCGetTextBold ==============
typedef vbool (CALLBACK* VCGetTextBoldFN) (short*);

vbool WINAPI VCGetTextBold (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextBold");
	if (fp)
	{
		return ((VCGetTextBoldFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetTextCharSpace ==============
typedef double (CALLBACK* VCGetTextCharSpaceFN) (short*);

double WINAPI VCGetTextCharSpace (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextCharSpace");
	if (fp)
	{
		return ((VCGetTextCharSpaceFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetTextCharSpaceBP ==============
typedef void (CALLBACK* VCGetTextCharSpaceBPFN) (short*, double*);

void WINAPI VCGetTextCharSpaceBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextCharSpaceBP");
	if (fp)
	{
		((VCGetTextCharSpaceBPFN)fp)(iError, dRet);
	}
}

//============== VCGetTextColor ==============
typedef short (CALLBACK* VCGetTextColorFN) (short*);

short WINAPI VCGetTextColor (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextColor");
	if (fp)
	{
		return ((VCGetTextColorFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetTextFontName ==============
typedef short (CALLBACK* VCGetTextFontNameFN) (short*, char*);

short WINAPI VCGetTextFontName (short* iError, char* pS)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextFontName");
	if (fp)
	{
		return ((VCGetTextFontNameFN)fp)(iError, pS);
	}
	return iRet;
}

//============== VCGetTextHeight ==============
typedef double (CALLBACK* VCGetTextHeightFN) (short*);

double WINAPI VCGetTextHeight (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextHeight");
	if (fp)
	{
		return ((VCGetTextHeightFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetTextHeightBP ==============
typedef void (CALLBACK* VCGetTextHeightBPFN) (short*, double*);

void WINAPI VCGetTextHeightBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextHeightBP");
	if (fp)
	{
		((VCGetTextHeightBPFN)fp)(iError, dRet);
	}
}

//============== VCGetTextItalic ==============
typedef vbool (CALLBACK* VCGetTextItalicFN) (short*);

vbool WINAPI VCGetTextItalic (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextItalic");
	if (fp)
	{
		return ((VCGetTextItalicFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetTextItalicValue ==============
typedef double (CALLBACK* VCGetTextItalicValueFN) (short*);

double WINAPI VCGetTextItalicValue (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextItalicValue");
	if (fp)
	{
		return ((VCGetTextItalicValueFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetTextItalicValueBP ==============
typedef void (CALLBACK* VCGetTextItalicValueBPFN) (short*, double*);

void WINAPI VCGetTextItalicValueBP (short* iError, double* dI)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextItalicValueBP");
	if (fp)
	{
		((VCGetTextItalicValueBPFN)fp)(iError, dI);
	}
}

//============== VCGetTextJustify ==============
typedef short (CALLBACK* VCGetTextJustifyFN) (short*);

short WINAPI VCGetTextJustify (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextJustify");
	if (fp)
	{
		return ((VCGetTextJustifyFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetTextLayer ==============
typedef short (CALLBACK* VCGetTextLayerFN) (short*);

short WINAPI VCGetTextLayer (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextLayer");
	if (fp)
	{
		return ((VCGetTextLayerFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetTextLineSpace ==============
typedef double (CALLBACK* VCGetTextLineSpaceFN) (short*);

double WINAPI VCGetTextLineSpace (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextLineSpace");
	if (fp)
	{
		return ((VCGetTextLineSpaceFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetTextLineSpaceBP ==============
typedef void (CALLBACK* VCGetTextLineSpaceBPFN) (short*, double*);

void WINAPI VCGetTextLineSpaceBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextLineSpaceBP");
	if (fp)
	{
		((VCGetTextLineSpaceBPFN)fp)(iError, dRet);
	}
}

//============== VCGetTextProSpacing ==============
typedef vbool (CALLBACK* VCGetTextProSpacingFN) (short*);

vbool WINAPI VCGetTextProSpacing (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextProSpacing");
	if (fp)
	{
		return ((VCGetTextProSpacingFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetTextRot ==============
typedef double (CALLBACK* VCGetTextRotFN) (short*);

double WINAPI VCGetTextRot (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextRot");
	if (fp)
	{
		return ((VCGetTextRotFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetTextRotBP ==============
typedef void (CALLBACK* VCGetTextRotBPFN) (short*, double*);

void WINAPI VCGetTextRotBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextRotBP");
	if (fp)
	{
		((VCGetTextRotBPFN)fp)(iError, dRet);
	}
}

//============== VCGetTextString ==============
typedef short (CALLBACK* VCGetTextStringFN) (short*, char*);

short WINAPI VCGetTextString (short* iError, char* pS)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextString");
	if (fp)
	{
		return ((VCGetTextStringFN)fp)(iError, pS);
	}
	return iRet;
}

//============== VCGetTextStringBP ==============
typedef void (CALLBACK* VCGetTextStringBPFN) (short*, char*);

void WINAPI VCGetTextStringBP (short* iError, char* pS)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextStringBP");
	if (fp)
	{
		((VCGetTextStringBPFN)fp)(iError, pS);
	}
}

//============== VCGetTextUnderline ==============
typedef vbool (CALLBACK* VCGetTextUnderlineFN) (short*);

vbool WINAPI VCGetTextUnderline (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextUnderline");
	if (fp)
	{
		return ((VCGetTextUnderlineFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetTextUseByLayerProperties ==============
typedef void (CALLBACK* VCGetTextUseByLayerPropertiesFN) (short*, vbool*, vbool*, vbool*);

void WINAPI VCGetTextUseByLayerProperties (short* iError, vbool* tfColor, vbool* tfLineType, vbool* tfLineWidth)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextUseByLayerProperties");
	if (fp)
	{
		((VCGetTextUseByLayerPropertiesFN)fp)(iError, tfColor, tfLineType, tfLineWidth);
	}
}

//============== VCGetToggleState ==============
typedef vbool (CALLBACK* VCGetToggleStateFN) (WORD, vbool);

vbool WINAPI VCGetToggleState (WORD id, vbool tfReverseState)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetToggleState");
	if (fp)
	{
		return ((VCGetToggleStateFN)fp)(id, tfReverseState);
	}
	return vbRet;
}

//============== VCGetUnitConversionFactor ==============
typedef void (CALLBACK* VCGetUnitConversionFactorFN) (short*, double*);

void WINAPI VCGetUnitConversionFactor (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetUnitConversionFactor");
	if (fp)
	{
		((VCGetUnitConversionFactorFN)fp)(iError, dRet);
	}
}

//============== VCGetUseByLayerProperties ==============
typedef void (CALLBACK* VCGetUseByLayerPropertiesFN) (short*, vbool*, vbool*, vbool*);

void WINAPI VCGetUseByLayerProperties (short* iError, vbool* tfColor, vbool* tfLineType, vbool* tfLineWidth)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetUseByLayerProperties");
	if (fp)
	{
		((VCGetUseByLayerPropertiesFN)fp)(iError, tfColor, tfLineType, tfLineWidth);
	}
}

//============== VCGetUseFileLocking ==============
typedef vbool (CALLBACK* VCGetUseFileLockingFN) (short*);

vbool WINAPI VCGetUseFileLocking (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetUseFileLocking");
	if (fp)
	{
		return ((VCGetUseFileLockingFN)fp)(iError);
	}
	return vbRet;
}

//============== VCGetUsedSymbolCount ==============
typedef long (CALLBACK* VCGetUsedSymbolCountFN) (short*);

long WINAPI VCGetUsedSymbolCount (short* iError)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetUsedSymbolCount");
	if (fp)
	{
		return ((VCGetUsedSymbolCountFN)fp)(iError);
	}
	return lRet;
}

//============== VCGetUsedSymbolIndex ==============
typedef long (CALLBACK* VCGetUsedSymbolIndexFN) (short*, long);

long WINAPI VCGetUsedSymbolIndex (short* iError, long IndexIn)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetUsedSymbolIndex");
	if (fp)
	{
		return ((VCGetUsedSymbolIndexFN)fp)(iError, IndexIn);
	}
	return lRet;
}

//============== VCGetUserDataName ==============
typedef short (CALLBACK* VCGetUserDataNameFN) (short*, char*);

short WINAPI VCGetUserDataName (short* iError, char* pS)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetUserDataName");
	if (fp)
	{
		return ((VCGetUserDataNameFN)fp)(iError, pS);
	}
	return iRet;
}

//============== VCGetUserToolLBDown ==============
typedef void (CALLBACK* VCGetUserToolLBDownFN) (short*, Point2D*);

void WINAPI VCGetUserToolLBDown (short* iError, Point2D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetUserToolLBDown");
	if (fp)
	{
		((VCGetUserToolLBDownFN)fp)(iError, dpP);
	}
}

//============== VCGetUserToolLBUp ==============
typedef void (CALLBACK* VCGetUserToolLBUpFN) (short*, Point2D*);

void WINAPI VCGetUserToolLBUp (short* iError, Point2D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetUserToolLBUp");
	if (fp)
	{
		((VCGetUserToolLBUpFN)fp)(iError, dpP);
	}
}

//============== VCGetUserToolMouseMove ==============
typedef void (CALLBACK* VCGetUserToolMouseMoveFN) (short*, Point2D*);

void WINAPI VCGetUserToolMouseMove (short* iError, Point2D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetUserToolMouseMove");
	if (fp)
	{
		((VCGetUserToolMouseMoveFN)fp)(iError, dpP);
	}
}

//============== VCGetVCDPath ==============
typedef short (CALLBACK* VCGetVCDPathFN) (short*, char*);

short WINAPI VCGetVCDPath (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetVCDPath");
	if (fp)
	{
		return ((VCGetVCDPathFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetVCFPath ==============
typedef short (CALLBACK* VCGetVCFPathFN) (short*, char*);

short WINAPI VCGetVCFPath (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetVCFPath");
	if (fp)
	{
		return ((VCGetVCFPathFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetVCMainInstance ==============
typedef HINSTANCE (CALLBACK* VCGetVCMainInstanceFN) (void);

HINSTANCE WINAPI VCGetVCMainInstance (void)
{
	HINSTANCE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetVCMainInstance");
	if (fp)
	{
		return ((VCGetVCMainInstanceFN)fp)();
	}
	return iRet;
}

//============== VCGetVCSPath ==============
typedef short (CALLBACK* VCGetVCSPathFN) (short*, char*);

short WINAPI VCGetVCSPath (short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetVCSPath");
	if (fp)
	{
		return ((VCGetVCSPathFN)fp)(iError, szPath);
	}
	return iRet;
}

//============== VCGetVideoTolerance ==============
typedef double (CALLBACK* VCGetVideoToleranceFN) (short*);

double WINAPI VCGetVideoTolerance (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetVideoTolerance");
	if (fp)
	{
		return ((VCGetVideoToleranceFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetVideoToleranceBP ==============
typedef void (CALLBACK* VCGetVideoToleranceBPFN) (short*, double*);

void WINAPI VCGetVideoToleranceBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetVideoToleranceBP");
	if (fp)
	{
		((VCGetVideoToleranceBPFN)fp)(iError, dRet);
	}
}

//============== VCGetView ==============
typedef vbool (CALLBACK* VCGetViewFN) (short*, long, short*);

vbool WINAPI VCGetView (short* iError, long hWnd, short* iView)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetView");
	if (fp)
	{
		return ((VCGetViewFN)fp)(iError, hWnd, iView);
	}
	return vbRet;
}

//============== VCGetViewCount ==============
typedef vbool (CALLBACK* VCGetViewCountFN) (short*, WORLDHANDLE, short*);

vbool WINAPI VCGetViewCount (short* iError, WORLDHANDLE hW, short* iVCnt)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetViewCount");
	if (fp)
	{
		return ((VCGetViewCountFN)fp)(iError, hW, iVCnt);
	}
	return vbRet;
}

//============== VCGetWallWidth1 ==============
typedef double (CALLBACK* VCGetWallWidth1FN) (short*);

double WINAPI VCGetWallWidth1 (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetWallWidth1");
	if (fp)
	{
		return ((VCGetWallWidth1FN)fp)(iError);
	}
	return dRet;
}

//============== VCGetWallWidth1BP ==============
typedef void (CALLBACK* VCGetWallWidth1BPFN) (short*, double*);

void WINAPI VCGetWallWidth1BP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetWallWidth1BP");
	if (fp)
	{
		((VCGetWallWidth1BPFN)fp)(iError, dRet);
	}
}

//============== VCGetWallWidth2 ==============
typedef double (CALLBACK* VCGetWallWidth2FN) (short*);

double WINAPI VCGetWallWidth2 (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetWallWidth2");
	if (fp)
	{
		return ((VCGetWallWidth2FN)fp)(iError);
	}
	return dRet;
}

//============== VCGetWallWidth2BP ==============
typedef void (CALLBACK* VCGetWallWidth2BPFN) (short*, double*);

void WINAPI VCGetWallWidth2BP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetWallWidth2BP");
	if (fp)
	{
		((VCGetWallWidth2BPFN)fp)(iError, dRet);
	}
}

//============== VCGetWorldByHWND ==============
typedef WORLDHANDLE (CALLBACK* VCGetWorldByHWNDFN) (short*, long);

WORLDHANDLE WINAPI VCGetWorldByHWND (short* iError, long hwnd)
{
	WORLDHANDLE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetWorldByHWND");
	if (fp)
	{
		return ((VCGetWorldByHWNDFN)fp)(iError, hwnd);
	}
	return iRet;
}

//============== VCGetWorldExtents ==============
typedef void (CALLBACK* VCGetWorldExtentsFN) (short*, Point2D*, Point2D*);

void WINAPI VCGetWorldExtents (short* iError, Point2D* dpMin, Point2D* dpMax)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetWorldExtents");
	if (fp)
	{
		((VCGetWorldExtentsFN)fp)(iError, dpMin, dpMax);
	}
}

//============== VCGetWorldIndexByHWND ==============
typedef void (CALLBACK* VCGetWorldIndexByHWNDFN) (short*, long, WORLDHANDLE*);

void WINAPI VCGetWorldIndexByHWND (short* iError, long hWnd, WORLDHANDLE* hW)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetWorldIndexByHWND");
	if (fp)
	{
		((VCGetWorldIndexByHWNDFN)fp)(iError, hWnd, hW);
	}
}

//============== VCGetWorldSizeBP ==============
typedef void (CALLBACK* VCGetWorldSizeBPFN) (short*, double, double*);

void WINAPI VCGetWorldSizeBP (short* iError, double dScreenSize, double* dWorldSize)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetWorldSizeBP");
	if (fp)
	{
		((VCGetWorldSizeBPFN)fp)(iError, dScreenSize, dWorldSize);
	}
}

//============== VCGetXYHandle ==============
typedef long (CALLBACK* VCGetXYHandleFN) (void);

long WINAPI VCGetXYHandle (void)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetXYHandle");
	if (fp)
	{
		return ((VCGetXYHandleFN)fp)();
	}
	return lRet;
}

//============== VCGetZoomFactor ==============
typedef double (CALLBACK* VCGetZoomFactorFN) (short*);

double WINAPI VCGetZoomFactor (short* iError)
{
	double dRet;
	dRet = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetZoomFactor");
	if (fp)
	{
		return ((VCGetZoomFactorFN)fp)(iError);
	}
	return dRet;
}

//============== VCGetZoomFactorBP ==============
typedef void (CALLBACK* VCGetZoomFactorBPFN) (short*, double*);

void WINAPI VCGetZoomFactorBP (short* iError, double* dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetZoomFactorBP");
	if (fp)
	{
		((VCGetZoomFactorBPFN)fp)(iError, dRet);
	}
}

//============== VCGethWnd ==============
typedef long (CALLBACK* VCGethWndFN) (WORLDHANDLE);

long WINAPI VCGethWnd (WORLDHANDLE hW)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGethWnd");
	if (fp)
	{
		return ((VCGethWndFN)fp)(hW);
	}
	return lRet;
}

//============== VCGethWndFrame ==============
typedef long (CALLBACK* VCGethWndFrameFN) (void);

long WINAPI VCGethWndFrame (void)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGethWndFrame");
	if (fp)
	{
		return ((VCGethWndFrameFN)fp)();
	}
	return lRet;
}

//============== VCIncrementWidthOnAllEntities ==============
typedef void (CALLBACK* VCIncrementWidthOnAllEntitiesFN) (short*, short);

void WINAPI VCIncrementWidthOnAllEntities (short* iError, short iIncrement)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIncrementWidthOnAllEntities");
	if (fp)
	{
		((VCIncrementWidthOnAllEntitiesFN)fp)(iError, iIncrement);
	}
}

//============== VCInit ==============
typedef void (CALLBACK* VCInitFN) (void);

void WINAPI VCInit (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCInit");
	if (fp)
	{
		((VCInitFN)fp)();
	}
}

//============== VCInitWithProgramRegKey ==============
typedef void (CALLBACK* VCInitWithProgramRegKeyFN) (char*);

void WINAPI VCInitWithProgramRegKey (char* RegKey)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCInitWithProgramRegKey");
	if (fp)
	{
		((VCInitWithProgramRegKeyFN)fp)(RegKey);
	}
}

//============== VCInvalidateRect ==============
typedef void (CALLBACK* VCInvalidateRectFN) (void);

void WINAPI VCInvalidateRect (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCInvalidateRect");
	if (fp)
	{
		((VCInvalidateRectFN)fp)();
	}
}

//============== VCIsAnythingSelected ==============
typedef vbool (CALLBACK* VCIsAnythingSelectedFN) (void);

vbool WINAPI VCIsAnythingSelected (void)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsAnythingSelected");
	if (fp)
	{
		return ((VCIsAnythingSelectedFN)fp)();
	}
	return vbRet;
}

//============== VCIsCurrentErased ==============
typedef vbool (CALLBACK* VCIsCurrentErasedFN) (short*);

vbool WINAPI VCIsCurrentErased (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsCurrentErased");
	if (fp)
	{
		return ((VCIsCurrentErasedFN)fp)(iError);
	}
	return vbRet;
}

//============== VCIsCurrentSelected ==============
typedef vbool (CALLBACK* VCIsCurrentSelectedFN) (short*);

vbool WINAPI VCIsCurrentSelected (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsCurrentSelected");
	if (fp)
	{
		return ((VCIsCurrentSelectedFN)fp)(iError);
	}
	return vbRet;
}

//============== VCIsCurrentWorldValid ==============
typedef vbool (CALLBACK* VCIsCurrentWorldValidFN) (void);

vbool WINAPI VCIsCurrentWorldValid (void)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsCurrentWorldValid");
	if (fp)
	{
		return ((VCIsCurrentWorldValidFN)fp)();
	}
	return vbRet;
}

//============== VCIsDrawingDirty ==============
typedef vbool (CALLBACK* VCIsDrawingDirtyFN) (void);

vbool WINAPI VCIsDrawingDirty (void)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsDrawingDirty");
	if (fp)
	{
		return ((VCIsDrawingDirtyFN)fp)();
	}
	return vbRet;
}

//============== VCIsFileLocked ==============
typedef vbool (CALLBACK* VCIsFileLockedFN) (char*, char*, char*);

vbool WINAPI VCIsFileLocked (char* szFilename, char* szLockedByName, char* szTimeLocked)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsFileLocked");
	if (fp)
	{
		return ((VCIsFileLockedFN)fp)(szFilename, szLockedByName, szTimeLocked);
	}
	return vbRet;
}

//============== VCIsFileLockedByCurrentUser ==============
typedef vbool (CALLBACK* VCIsFileLockedByCurrentUserFN) (void);

vbool WINAPI VCIsFileLockedByCurrentUser (void)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsFileLockedByCurrentUser");
	if (fp)
	{
		return ((VCIsFileLockedByCurrentUserFN)fp)();
	}
	return vbRet;
}

//============== VCIsFilterActive ==============
typedef vbool (CALLBACK* VCIsFilterActiveFN) (short*);

vbool WINAPI VCIsFilterActive (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsFilterActive");
	if (fp)
	{
		return ((VCIsFilterActiveFN)fp)(iError);
	}
	return vbRet;
}

//============== VCIsFontNameVText ==============
typedef vbool (CALLBACK* VCIsFontNameVTextFN) (short*, char*);

vbool WINAPI VCIsFontNameVText (short* iError, char* pS)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsFontNameVText");
	if (fp)
	{
		return ((VCIsFontNameVTextFN)fp)(iError, pS);
	}
	return vbRet;
}

//============== VCIsGraphic ==============
typedef vbool (CALLBACK* VCIsGraphicFN) (short*);

vbool WINAPI VCIsGraphic (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsGraphic");
	if (fp)
	{
		return ((VCIsGraphicFN)fp)(iError);
	}
	return vbRet;
}

//============== VCIsOleWorld ==============
typedef vbool (CALLBACK* VCIsOleWorldFN) (void);

vbool WINAPI VCIsOleWorld (void)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsOleWorld");
	if (fp)
	{
		return ((VCIsOleWorldFN)fp)();
	}
	return vbRet;
}

//============== VCIsRedoable ==============
typedef vbool (CALLBACK* VCIsRedoableFN) (void);

vbool WINAPI VCIsRedoable (void)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsRedoable");
	if (fp)
	{
		return ((VCIsRedoableFN)fp)();
	}
	return vbRet;
}

//============== VCIsScriptAssigned ==============
typedef vbool (CALLBACK* VCIsScriptAssignedFN) (short, short);

vbool WINAPI VCIsScriptAssigned (short iShift, short iKey)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsScriptAssigned");
	if (fp)
	{
		return ((VCIsScriptAssignedFN)fp)(iShift, iKey);
	}
	return vbRet;
}

//============== VCIsSymbolLoaded ==============
typedef vbool (CALLBACK* VCIsSymbolLoadedFN) (char*);

vbool WINAPI VCIsSymbolLoaded (char* szSymbolName)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsSymbolLoaded");
	if (fp)
	{
		return ((VCIsSymbolLoadedFN)fp)(szSymbolName);
	}
	return vbRet;
}

//============== VCIsTextFontVText ==============
typedef vbool (CALLBACK* VCIsTextFontVTextFN) (short*);

vbool WINAPI VCIsTextFontVText (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsTextFontVText");
	if (fp)
	{
		return ((VCIsTextFontVTextFN)fp)(iError);
	}
	return vbRet;
}

//============== VCIsToggle ==============
typedef vbool (CALLBACK* VCIsToggleFN) (WORD);

vbool WINAPI VCIsToggle (WORD id)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsToggle");
	if (fp)
	{
		return ((VCIsToggleFN)fp)(id);
	}
	return vbRet;
}

//============== VCIsUndoable ==============
typedef vbool (CALLBACK* VCIsUndoableFN) (void);

vbool WINAPI VCIsUndoable (void)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsUndoable");
	if (fp)
	{
		return ((VCIsUndoableFN)fp)();
	}
	return vbRet;
}

//============== VCIsWorldEmpty ==============
typedef vbool (CALLBACK* VCIsWorldEmptyFN) (WORLDHANDLE);

vbool WINAPI VCIsWorldEmpty (WORLDHANDLE hW)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsWorldEmpty");
	if (fp)
	{
		return ((VCIsWorldEmptyFN)fp)(hW);
	}
	return vbRet;
}

//============== VCIsWorldValid ==============
typedef vbool (CALLBACK* VCIsWorldValidFN) (WORLDHANDLE);

vbool WINAPI VCIsWorldValid (WORLDHANDLE hW)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCIsWorldValid");
	if (fp)
	{
		return ((VCIsWorldValidFN)fp)(hW);
	}
	return vbRet;
}

//============== VCLButtonDblClk ==============
typedef void (CALLBACK* VCLButtonDblClkFN) (long, WORD);

void WINAPI VCLButtonDblClk (long lParam, WORD wParam)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLButtonDblClk");
	if (fp)
	{
		((VCLButtonDblClkFN)fp)(lParam, wParam);
	}
}

//============== VCLButtonDown ==============
typedef void (CALLBACK* VCLButtonDownFN) (long, WORD);

void WINAPI VCLButtonDown (long lParam, WORD wParam)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLButtonDown");
	if (fp)
	{
		((VCLButtonDownFN)fp)(lParam, wParam);
	}
}

//============== VCLButtonDown2 ==============
typedef void (CALLBACK* VCLButtonDown2FN) (short, short);

void WINAPI VCLButtonDown2 (short cx, short cy)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLButtonDown2");
	if (fp)
	{
		((VCLButtonDown2FN)fp)(cx, cy);
	}
}

//============== VCLButtonDownWorldPoint ==============
typedef void (CALLBACK* VCLButtonDownWorldPointFN) (Point2D*);

void WINAPI VCLButtonDownWorldPoint (Point2D* dpW)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLButtonDownWorldPoint");
	if (fp)
	{
		((VCLButtonDownWorldPointFN)fp)(dpW);
	}
}

//============== VCLButtonUp ==============
typedef void (CALLBACK* VCLButtonUpFN) (long, WORD);

void WINAPI VCLButtonUp (long lParam, WORD wParam)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLButtonUp");
	if (fp)
	{
		((VCLButtonUpFN)fp)(lParam, wParam);
	}
}

//============== VCLButtonUpTimerReset ==============
typedef void (CALLBACK* VCLButtonUpTimerResetFN) (short*);

void WINAPI VCLButtonUpTimerReset (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLButtonUpTimerReset");
	if (fp)
	{
		((VCLButtonUpTimerResetFN)fp)(iError);
	}
}

//============== VCLParamToPoint2D ==============
typedef Point2D (CALLBACK* VCLParamToPoint2DFN) (long);

Point2D WINAPI VCLParamToPoint2D (long lParam)
{
	Point2D dpRet;
	dpRet.x = dpRet.y = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLParamToPoint2D");
	if (fp)
	{
		return ((VCLParamToPoint2DFN)fp)(lParam);
	}
	return dpRet;
}

//============== VCLParamToPoint2DBP ==============
typedef void (CALLBACK* VCLParamToPoint2DBPFN) (long, Point2D*);

void WINAPI VCLParamToPoint2DBP (long lParam, Point2D* pRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLParamToPoint2DBP");
	if (fp)
	{
		((VCLParamToPoint2DBPFN)fp)(lParam, pRet);
	}
}

//============== VCLastEntity ==============
typedef void (CALLBACK* VCLastEntityFN) (short*, ENTITYHANDLE*);

void WINAPI VCLastEntity (short* iError, ENTITYHANDLE* lH)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLastEntity");
	if (fp)
	{
		((VCLastEntityFN)fp)(iError, lH);
	}
}

//============== VCLayerHasProperties ==============
typedef vbool (CALLBACK* VCLayerHasPropertiesFN) (short*, short);

vbool WINAPI VCLayerHasProperties (short* iError, short iLayer)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLayerHasProperties");
	if (fp)
	{
		return ((VCLayerHasPropertiesFN)fp)(iError, iLayer);
	}
	return vbRet;
}

//============== VCLineAngle ==============
typedef void (CALLBACK* VCLineAngleFN) (short*, double*, Point2D*, Point2D*);

void WINAPI VCLineAngle (short* iError, double* dAngle, Point2D* dpP0, Point2D* dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLineAngle");
	if (fp)
	{
		((VCLineAngleFN)fp)(iError, dAngle, dpP0, dpP1);
	}
}

//============== VCLineLength ==============
typedef void (CALLBACK* VCLineLengthFN) (short*, double*, Point2D*, Point2D*);

void WINAPI VCLineLength (short* iError, double* dAngle, Point2D* dpP0, Point2D* dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLineLength");
	if (fp)
	{
		((VCLineLengthFN)fp)(iError, dAngle, dpP0, dpP1);
	}
}

//============== VCLinePerpPoint ==============
typedef void (CALLBACK* VCLinePerpPointFN) (short*, Point2D*, Point2D*, Point2D*, Point2D*);

void WINAPI VCLinePerpPoint (short* iError, Point2D* dpC, Point2D* dpP0, Point2D* dpP1, Point2D* dpOff)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLinePerpPoint");
	if (fp)
	{
		((VCLinePerpPointFN)fp)(iError, dpC, dpP0, dpP1, dpOff);
	}
}

//============== VCLinePointCompute ==============
typedef void (CALLBACK* VCLinePointComputeFN) (short*, Point2D*, Point2D*, Point2D*, double, double);

void WINAPI VCLinePointCompute (short* iError, Point2D* dpC, Point2D* dpP0, Point2D* dpP1, double dDist, double dAngle)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLinePointCompute");
	if (fp)
	{
		((VCLinePointComputeFN)fp)(iError, dpC, dpP0, dpP1, dDist, dAngle);
	}
}

//============== VCLoadVCDFromFile ==============
typedef void (CALLBACK* VCLoadVCDFromFileFN) (short*, char*);

void WINAPI VCLoadVCDFromFile (short* iError, char* pS_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLoadVCDFromFile");
	if (fp)
	{
		((VCLoadVCDFromFileFN)fp)(iError, pS_);
	}
}

//============== VCLoadVCDFromStream ==============
typedef void (CALLBACK* VCLoadVCDFromStreamFN) (short*, void*);

void WINAPI VCLoadVCDFromStream (short* iError, void* pS_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLoadVCDFromStream");
	if (fp)
	{
		((VCLoadVCDFromStreamFN)fp)(iError, pS_);
	}
}

//============== VCLockFile ==============
typedef vbool (CALLBACK* VCLockFileFN) (char*, vbool, vbool);

vbool WINAPI VCLockFile (char* szFileName, vbool tfFileReadOnly, vbool tfLoading)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLockFile");
	if (fp)
	{
		return ((VCLockFileFN)fp)(szFileName, tfFileReadOnly, tfLoading);
	}
	return vbRet;
}

//============== VCLockMessage ==============
typedef void (CALLBACK* VCLockMessageFN) (short*, char*, vbool);

void WINAPI VCLockMessage (short* iError, char* szMess, vbool tfLock)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLockMessage");
	if (fp)
	{
		((VCLockMessageFN)fp)(iError, szMess, tfLock);
	}
}

//============== VCMacro ==============
typedef void (CALLBACK* VCMacroFN) (char*);

void WINAPI VCMacro (char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCMacro");
	if (fp)
	{
		((VCMacroFN)fp)(sz);
	}
}

//============== VCMakeValidDosFilenameForSave ==============
typedef vbool (CALLBACK* VCMakeValidDosFilenameForSaveFN) (char*);

vbool WINAPI VCMakeValidDosFilenameForSave (char* pFilename)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCMakeValidDosFilenameForSave");
	if (fp)
	{
		return ((VCMakeValidDosFilenameForSaveFN)fp)(pFilename);
	}
	return vbRet;
}

//============== VCManualEntryMode ==============
typedef void (CALLBACK* VCManualEntryModeFN) (short);

void WINAPI VCManualEntryMode (short ID)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCManualEntryMode");
	if (fp)
	{
		((VCManualEntryModeFN)fp)(ID);
	}
}

//============== VCMatchCurrentEntity ==============
typedef void (CALLBACK* VCMatchCurrentEntityFN) (short*);

void WINAPI VCMatchCurrentEntity (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCMatchCurrentEntity");
	if (fp)
	{
		((VCMatchCurrentEntityFN)fp)(iError);
	}
}

//============== VCMouseMove ==============
typedef void (CALLBACK* VCMouseMoveFN) (long, WORD);

void WINAPI VCMouseMove (long lParam, WORD wParam)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCMouseMove");
	if (fp)
	{
		((VCMouseMoveFN)fp)(lParam, wParam);
	}
}

//============== VCMouseMove2 ==============
typedef void (CALLBACK* VCMouseMove2FN) (short, short);

void WINAPI VCMouseMove2 (short cx, short cy)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCMouseMove2");
	if (fp)
	{
		((VCMouseMove2FN)fp)(cx, cy);
	}
}

//============== VCMouseMoveWorldPoint ==============
typedef void (CALLBACK* VCMouseMoveWorldPointFN) (Point2D);

void WINAPI VCMouseMoveWorldPoint (Point2D dpW)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCMouseMoveWorldPoint");
	if (fp)
	{
		((VCMouseMoveWorldPointFN)fp)(dpW);
	}
}

//============== VCMoveCursor ==============
typedef void (CALLBACK* VCMoveCursorFN) (short);

void WINAPI VCMoveCursor (short nVKey)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCMoveCursor");
	if (fp)
	{
		((VCMoveCursorFN)fp)(nVKey);
	}
}

//============== VCNameView ==============
typedef void (CALLBACK* VCNameViewFN) (char*);

void WINAPI VCNameView (char* szView)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCNameView");
	if (fp)
	{
		((VCNameViewFN)fp)(szView);
	}
}

//============== VCNewView ==============
typedef void (CALLBACK* VCNewViewFN) (short*, long);

void WINAPI VCNewView (short* iError, long hWnd_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCNewView");
	if (fp)
	{
		((VCNewViewFN)fp)(iError, hWnd_);
	}
}

//============== VCNewWorld ==============
typedef WORLDHANDLE (CALLBACK* VCNewWorldFN) (long);

WORLDHANDLE WINAPI VCNewWorld (long hWnd_)
{
	WORLDHANDLE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCNewWorld");
	if (fp)
	{
		return ((VCNewWorldFN)fp)(hWnd_);
	}
	return iRet;
}

//============== VCNextEntity ==============
typedef vbool (CALLBACK* VCNextEntityFN) (short*, short*);

vbool WINAPI VCNextEntity (short* iError, short* bKind)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCNextEntity");
	if (fp)
	{
		return ((VCNextEntityFN)fp)(iError, bKind);
	}
	return vbRet;
}

//============== VCNextEntityExpand ==============
typedef vbool (CALLBACK* VCNextEntityExpandFN) (short*, short*);

vbool WINAPI VCNextEntityExpand (short* iError, short* bKind)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCNextEntityExpand");
	if (fp)
	{
		return ((VCNextEntityExpandFN)fp)(iError, bKind);
	}
	return vbRet;
}

//============== VCNextGraphic ==============
typedef vbool (CALLBACK* VCNextGraphicFN) (short*, GRAPHICHANDLE);

vbool WINAPI VCNextGraphic (short* iError, GRAPHICHANDLE hG)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCNextGraphic");
	if (fp)
	{
		return ((VCNextGraphicFN)fp)(iError, hG);
	}
	return vbRet;
}

//============== VCNextOnScreen ==============
typedef vbool (CALLBACK* VCNextOnScreenFN) (short*, short*);

vbool WINAPI VCNextOnScreen (short* iError, short* bKind)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCNextOnScreen");
	if (fp)
	{
		return ((VCNextOnScreenFN)fp)(iError, bKind);
	}
	return vbRet;
}

//============== VCNextSelected ==============
typedef vbool (CALLBACK* VCNextSelectedFN) (short*, short*);

vbool WINAPI VCNextSelected (short* iError, short* bKind)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCNextSelected");
	if (fp)
	{
		return ((VCNextSelectedFN)fp)(iError, bKind);
	}
	return vbRet;
}

//============== VCNextView ==============
typedef vbool (CALLBACK* VCNextViewFN) (short*);

vbool WINAPI VCNextView (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCNextView");
	if (fp)
	{
		return ((VCNextViewFN)fp)(iError);
	}
	return vbRet;
}

//============== VCObjectSelect ==============
typedef void (CALLBACK* VCObjectSelectFN) (Point2D*);

void WINAPI VCObjectSelect (Point2D* dpP0)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCObjectSelect");
	if (fp)
	{
		((VCObjectSelectFN)fp)(dpP0);
	}
}

//============== VCOleUpdate ==============
typedef void (CALLBACK* VCOleUpdateFN) (void);

void WINAPI VCOleUpdate (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCOleUpdate");
	if (fp)
	{
		((VCOleUpdateFN)fp)();
	}
}

//============== VCOpenCMP ==============
typedef void (CALLBACK* VCOpenCMPFN) (char*);

void WINAPI VCOpenCMP (char* szFile)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCOpenCMP");
	if (fp)
	{
		((VCOpenCMPFN)fp)(szFile);
	}
}

//============== VCOpenGCD ==============
typedef void (CALLBACK* VCOpenGCDFN) (char*);

void WINAPI VCOpenGCD (char* szFile)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCOpenGCD");
	if (fp)
	{
		((VCOpenGCDFN)fp)(szFile);
	}
}

//============== VCOpenStyle ==============
typedef void (CALLBACK* VCOpenStyleFN) (char*);

void WINAPI VCOpenStyle (char* fname)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCOpenStyle");
	if (fp)
	{
		((VCOpenStyleFN)fp)(fname);
	}
}

//============== VCOpenVCA ==============
typedef void (CALLBACK* VCOpenVCAFN) (char*);

void WINAPI VCOpenVCA (char* szFile)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCOpenVCA");
	if (fp)
	{
		((VCOpenVCAFN)fp)(szFile);
	}
}

//============== VCOpenVCD ==============
typedef void (CALLBACK* VCOpenVCDFN) (char*);

void WINAPI VCOpenVCD (char* szFile)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCOpenVCD");
	if (fp)
	{
		((VCOpenVCDFN)fp)(szFile);
	}
}

//============== VCOpenVCS ==============
typedef void (CALLBACK* VCOpenVCSFN) (char*);

void WINAPI VCOpenVCS (char* szFile)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCOpenVCS");
	if (fp)
	{
		((VCOpenVCSFN)fp)(szFile);
	}
}

//============== VCPaint ==============
typedef void (CALLBACK* VCPaintFN) (long, RECT);

void WINAPI VCPaint (long hWnd, RECT rc)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCPaint");
	if (fp)
	{
		((VCPaintFN)fp)(hWnd, rc);
	}
}

//============== VCPaintWorld ==============
typedef void (CALLBACK* VCPaintWorldFN) (void);

void WINAPI VCPaintWorld (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCPaintWorld");
	if (fp)
	{
		((VCPaintWorldFN)fp)();
	}
}

//============== VCPanCursor ==============
typedef void (CALLBACK* VCPanCursorFN) (short);

void WINAPI VCPanCursor (short nVKey)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCPanCursor");
	if (fp)
	{
		((VCPanCursorFN)fp)(nVKey);
	}
}

//============== VCPenUp ==============
typedef void (CALLBACK* VCPenUpFN) (void);

void WINAPI VCPenUp (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCPenUp");
	if (fp)
	{
		((VCPenUpFN)fp)();
	}
}

//============== VCPostMessage ==============
typedef vbool (CALLBACK* VCPostMessageFN) (WORD, WORD, LPARAM);

vbool WINAPI VCPostMessage (WORD iMessage, WORD wParam, LPARAM lParam)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCPostMessage");
	if (fp)
	{
		return ((VCPostMessageFN)fp)(iMessage, wParam, lParam);
	}
	return vbRet;
}

//============== VCPurgeErasedEntities ==============
typedef void (CALLBACK* VCPurgeErasedEntitiesFN) (WORLDHANDLE);

void WINAPI VCPurgeErasedEntities (WORLDHANDLE hW)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCPurgeErasedEntities");
	if (fp)
	{
		((VCPurgeErasedEntitiesFN)fp)(hW);
	}
}

//============== VCRButtonUp ==============
typedef void (CALLBACK* VCRButtonUpFN) (long, WORD);

void WINAPI VCRButtonUp (long lParam, WORD wParam)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRButtonUp");
	if (fp)
	{
		((VCRButtonUpFN)fp)(lParam, wParam);
	}
}

//============== VCRFGetDrawBoundary ==============
typedef vbool (CALLBACK* VCRFGetDrawBoundaryFN) (short*);

vbool WINAPI VCRFGetDrawBoundary (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRFGetDrawBoundary");
	if (fp)
	{
		return ((VCRFGetDrawBoundaryFN)fp)(iError);
	}
	return vbRet;
}

//============== VCRFGetTransparent ==============
typedef vbool (CALLBACK* VCRFGetTransparentFN) (short*);

vbool WINAPI VCRFGetTransparent (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRFGetTransparent");
	if (fp)
	{
		return ((VCRFGetTransparentFN)fp)(iError);
	}
	return vbRet;
}

//============== VCRFSetDrawBoundary ==============
typedef void (CALLBACK* VCRFSetDrawBoundaryFN) (short*, vbool);

void WINAPI VCRFSetDrawBoundary (short* iError, vbool tfDrawBoundary)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRFSetDrawBoundary");
	if (fp)
	{
		((VCRFSetDrawBoundaryFN)fp)(iError, tfDrawBoundary);
	}
}

//============== VCRFSetTransparent ==============
typedef void (CALLBACK* VCRFSetTransparentFN) (short*, vbool);

void WINAPI VCRFSetTransparent (short* iError, vbool tfDrawBoundary)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRFSetTransparent");
	if (fp)
	{
		((VCRFSetTransparentFN)fp)(iError, tfDrawBoundary);
	}
}

//============== VCRFUpdateFileLink ==============
typedef void (CALLBACK* VCRFUpdateFileLinkFN) (short*);

void WINAPI VCRFUpdateFileLink (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRFUpdateFileLink");
	if (fp)
	{
		((VCRFUpdateFileLinkFN)fp)(iError);
	}
}

//============== VCRelativePath ==============
typedef void (CALLBACK* VCRelativePathFN) (short*, char*, char*, char*);

void WINAPI VCRelativePath (short* iError, char* ReturnPath, char* CurrPath, char* AbsPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRelativePath");
	if (fp)
	{
		((VCRelativePathFN)fp)(iError, ReturnPath, CurrPath, AbsPath);
	}
}

//============== VCRemoveAllViews ==============
typedef vbool (CALLBACK* VCRemoveAllViewsFN) (short*, WORLDHANDLE);

vbool WINAPI VCRemoveAllViews (short* iError, WORLDHANDLE hW)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRemoveAllViews");
	if (fp)
	{
		return ((VCRemoveAllViewsFN)fp)(iError, hW);
	}
	return vbRet;
}

//============== VCRemoveFileLock ==============
typedef void (CALLBACK* VCRemoveFileLockFN) (char*);

void WINAPI VCRemoveFileLock (char* szFile)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRemoveFileLock");
	if (fp)
	{
		((VCRemoveFileLockFN)fp)(szFile);
	}
}

//============== VCRemoveSymbols ==============
typedef void (CALLBACK* VCRemoveSymbolsFN) (short*, char*, short);

void WINAPI VCRemoveSymbols (short* iError, char* pNames, short iCnt)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRemoveSymbols");
	if (fp)
	{
		((VCRemoveSymbolsFN)fp)(iError, pNames, iCnt);
	}
}

//============== VCRemoveView ==============
typedef vbool (CALLBACK* VCRemoveViewFN) (short*, WORLDHANDLE, long);

vbool WINAPI VCRemoveView (short* iError, WORLDHANDLE hW, long hWnd)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRemoveView");
	if (fp)
	{
		return ((VCRemoveViewFN)fp)(iError, hW, hWnd);
	}
	return vbRet;
}

//============== VCResetAllLayerTables ==============
typedef void (CALLBACK* VCResetAllLayerTablesFN) (short*);

void WINAPI VCResetAllLayerTables (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCResetAllLayerTables");
	if (fp)
	{
		((VCResetAllLayerTablesFN)fp)(iError);
	}
}

//============== VCResetOnScreenList ==============
typedef void (CALLBACK* VCResetOnScreenListFN) (short*);

void WINAPI VCResetOnScreenList (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCResetOnScreenList");
	if (fp)
	{
		((VCResetOnScreenListFN)fp)(iError);
	}
}

//============== VCResizeChildWindow ==============
typedef void (CALLBACK* VCResizeChildWindowFN) (void);

void WINAPI VCResizeChildWindow (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCResizeChildWindow");
	if (fp)
	{
		((VCResizeChildWindowFN)fp)();
	}
}

//============== VCRestoreSettings ==============
typedef void (CALLBACK* VCRestoreSettingsFN) (void);

void WINAPI VCRestoreSettings (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRestoreSettings");
	if (fp)
	{
		((VCRestoreSettingsFN)fp)();
	}
}

//============== VCRestoreSysSettings ==============
typedef void (CALLBACK* VCRestoreSysSettingsFN) (void);

void WINAPI VCRestoreSysSettings (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCRestoreSysSettings");
	if (fp)
	{
		((VCRestoreSysSettingsFN)fp)();
	}
}

//============== VCSaveCurrent3DViewTo2D ==============
typedef void (CALLBACK* VCSaveCurrent3DViewTo2DFN) (short*, WORLDHANDLE);

void WINAPI VCSaveCurrent3DViewTo2D (short* iError, WORLDHANDLE TargetWorld)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSaveCurrent3DViewTo2D");
	if (fp)
	{
		((VCSaveCurrent3DViewTo2DFN)fp)(iError, TargetWorld);
	}
}

//============== VCSaveDrawingView ==============
typedef void (CALLBACK* VCSaveDrawingViewFN) (short*, vbool);

void WINAPI VCSaveDrawingView (short* iError, vbool tfSaveView)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSaveDrawingView");
	if (fp)
	{
		((VCSaveDrawingViewFN)fp)(iError, tfSaveView);
	}
}

//============== VCSaveEnvironment ==============
typedef void (CALLBACK* VCSaveEnvironmentFN) (short*);

void WINAPI VCSaveEnvironment (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSaveEnvironment");
	if (fp)
	{
		((VCSaveEnvironmentFN)fp)(iError);
	}
}

//============== VCSaveSettings ==============
typedef void (CALLBACK* VCSaveSettingsFN) (void);

void WINAPI VCSaveSettings (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSaveSettings");
	if (fp)
	{
		((VCSaveSettingsFN)fp)();
	}
}

//============== VCSaveStyle ==============
typedef void (CALLBACK* VCSaveStyleFN) (char*);

void WINAPI VCSaveStyle (char* fname)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSaveStyle");
	if (fp)
	{
		((VCSaveStyleFN)fp)(fname);
	}
}

//============== VCSaveSysSettings ==============
typedef void (CALLBACK* VCSaveSysSettingsFN) (void);

void WINAPI VCSaveSysSettings (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSaveSysSettings");
	if (fp)
	{
		((VCSaveSysSettingsFN)fp)();
	}
}

//============== VCSaveVCA ==============
typedef void (CALLBACK* VCSaveVCAFN) (char*, char*);

void WINAPI VCSaveVCA (char* szAttribName, char* szAttribFile)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSaveVCA");
	if (fp)
	{
		((VCSaveVCAFN)fp)(szAttribName, szAttribFile);
	}
}

//============== VCSaveVCDToFile ==============
typedef void (CALLBACK* VCSaveVCDToFileFN) (short*, char*);

void WINAPI VCSaveVCDToFile (short* iError, char* pS_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSaveVCDToFile");
	if (fp)
	{
		((VCSaveVCDToFileFN)fp)(iError, pS_);
	}
}

//============== VCSaveVCDToStream ==============
typedef void (CALLBACK* VCSaveVCDToStreamFN) (short*, void*);

void WINAPI VCSaveVCDToStream (short* iError, void* pS_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSaveVCDToStream");
	if (fp)
	{
		((VCSaveVCDToStreamFN)fp)(iError, pS_);
	}
}

//============== VCSaveVCS ==============
typedef void (CALLBACK* VCSaveVCSFN) (char*, char*);

void WINAPI VCSaveVCS (char* szSymbolName, char* szSymbolFile)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSaveVCS");
	if (fp)
	{
		((VCSaveVCSFN)fp)(szSymbolName, szSymbolFile);
	}
}

//============== VCSelectAll ==============
typedef void (CALLBACK* VCSelectAllFN) (void);

void WINAPI VCSelectAll (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSelectAll");
	if (fp)
	{
		((VCSelectAllFN)fp)();
	}
}

//============== VCSelectInvert ==============
typedef void (CALLBACK* VCSelectInvertFN) (void);

void WINAPI VCSelectInvert (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSelectInvert");
	if (fp)
	{
		((VCSelectInvertFN)fp)();
	}
}

//============== VCSelectLast ==============
typedef void (CALLBACK* VCSelectLastFN) (void);

void WINAPI VCSelectLast (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSelectLast");
	if (fp)
	{
		((VCSelectLastFN)fp)();
	}
}

//============== VCSendMessage ==============
typedef LRESULT (CALLBACK* VCSendMessageFN) (WORD, WORD, LPARAM);

LRESULT WINAPI VCSendMessage (WORD iMessage, WORD wParam, LPARAM lParam)
{
	LRESULT iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSendMessage");
	if (fp)
	{
		return ((VCSendMessageFN)fp)(iMessage, wParam, lParam);
	}
	return iRet;
}

//============== VCSet3DDisplay ==============
typedef void (CALLBACK* VCSet3DDisplayFN) (short*, short);

void WINAPI VCSet3DDisplay (short* iError, short iCode)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSet3DDisplay");
	if (fp)
	{
		((VCSet3DDisplayFN)fp)(iError, iCode);
	}
}

//============== VCSet3DQShadeOptions ==============
typedef void (CALLBACK* VCSet3DQShadeOptionsFN) (short*, short);

void WINAPI VCSet3DQShadeOptions (short* iError, short iCode)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSet3DQShadeOptions");
	if (fp)
	{
		((VCSet3DQShadeOptionsFN)fp)(iError, iCode);
	}
}

//============== VCSetAcadImportUnit ==============
typedef void (CALLBACK* VCSetAcadImportUnitFN) (short*, BYTE);

void WINAPI VCSetAcadImportUnit (short* iError, BYTE b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAcadImportUnit");
	if (fp)
	{
		((VCSetAcadImportUnitFN)fp)(iError, b);
	}
}

//============== VCSetAlertApp ==============
typedef void (CALLBACK* VCSetAlertAppFN) (short*, long, short);

void WINAPI VCSetAlertApp (short* iError, long hWnd, short iCode)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAlertApp");
	if (fp)
	{
		((VCSetAlertAppFN)fp)(iError, hWnd, iCode);
	}
}

//============== VCSetAlertAppDll ==============
typedef void (CALLBACK* VCSetAlertAppDllFN) (short*, char*, char*, long);

void WINAPI VCSetAlertAppDll (short* iError, char* DllName, char* NativeCmd, long iCode)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAlertAppDll");
	if (fp)
	{
		((VCSetAlertAppDllFN)fp)(iError, DllName, NativeCmd, iCode);
	}
}

//============== VCSetAlertAppDllEx ==============
typedef void (CALLBACK* VCSetAlertAppDllExFN) (short*, char*, char*, long, long);

void WINAPI VCSetAlertAppDllEx (short* iError, char* DllName, char* NativeCmd, long iCode0, long iCode1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAlertAppDllEx");
	if (fp)
	{
		((VCSetAlertAppDllExFN)fp)(iError, DllName, NativeCmd, iCode0, iCode1);
	}
}

//============== VCSetAlertAppEx ==============
typedef void (CALLBACK* VCSetAlertAppExFN) (short*, long, long, long);

void WINAPI VCSetAlertAppEx (short* iError, long hWnd, long iCode0, long iCode1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAlertAppEx");
	if (fp)
	{
		((VCSetAlertAppExFN)fp)(iError, hWnd, iCode0, iCode1);
	}
}

//============== VCSetAllDimPartsColor ==============
typedef void (CALLBACK* VCSetAllDimPartsColorFN) (short*, short);

void WINAPI VCSetAllDimPartsColor (short* iError, short iColor)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAllDimPartsColor");
	if (fp)
	{
		((VCSetAllDimPartsColorFN)fp)(iError, iColor);
	}
}

//============== VCSetAllDimPartsOn ==============
typedef void (CALLBACK* VCSetAllDimPartsOnFN) (short*);

void WINAPI VCSetAllDimPartsOn (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAllDimPartsOn");
	if (fp)
	{
		((VCSetAllDimPartsOnFN)fp)(iError);
	}
}

//============== VCSetAllLayersEd ==============
typedef void (CALLBACK* VCSetAllLayersEdFN) (short*, vbool);

void WINAPI VCSetAllLayersEd (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAllLayersEd");
	if (fp)
	{
		((VCSetAllLayersEdFN)fp)(iError, tf);
	}
}

//============== VCSetAllLayersSnap ==============
typedef void (CALLBACK* VCSetAllLayersSnapFN) (short*, vbool);

void WINAPI VCSetAllLayersSnap (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAllLayersSnap");
	if (fp)
	{
		((VCSetAllLayersSnapFN)fp)(iError, tf);
	}
}

//============== VCSetAngle ==============
typedef void (CALLBACK* VCSetAngleFN) (short*, double);

void WINAPI VCSetAngle (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAngle");
	if (fp)
	{
		((VCSetAngleFN)fp)(iError, dRet);
	}
}

//============== VCSetAngleHandle ==============
typedef void (CALLBACK* VCSetAngleHandleFN) (long);

void WINAPI VCSetAngleHandle (long hWnd_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAngleHandle");
	if (fp)
	{
		((VCSetAngleHandleFN)fp)(hWnd_);
	}
}

//============== VCSetArrowScreenStep ==============
typedef void (CALLBACK* VCSetArrowScreenStepFN) (short*, short);

void WINAPI VCSetArrowScreenStep (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetArrowScreenStep");
	if (fp)
	{
		((VCSetArrowScreenStepFN)fp)(iError, i);
	}
}

//============== VCSetArrowWorld ==============
typedef void (CALLBACK* VCSetArrowWorldFN) (short*, vbool);

void WINAPI VCSetArrowWorld (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetArrowWorld");
	if (fp)
	{
		((VCSetArrowWorldFN)fp)(iError, tf);
	}
}

//============== VCSetArrowWorldStep ==============
typedef void (CALLBACK* VCSetArrowWorldStepFN) (short*, double);

void WINAPI VCSetArrowWorldStep (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetArrowWorldStep");
	if (fp)
	{
		((VCSetArrowWorldStepFN)fp)(iError, dRet);
	}
}

//============== VCSetAskZoomCenter ==============
typedef void (CALLBACK* VCSetAskZoomCenterFN) (short*, vbool);

void WINAPI VCSetAskZoomCenter (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAskZoomCenter");
	if (fp)
	{
		((VCSetAskZoomCenterFN)fp)(iError, tf);
	}
}

//============== VCSetAtbColorIndex ==============
typedef void (CALLBACK* VCSetAtbColorIndexFN) (short*, short);

void WINAPI VCSetAtbColorIndex (short* iError, short iIndex)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAtbColorIndex");
	if (fp)
	{
		((VCSetAtbColorIndexFN)fp)(iError, iIndex);
	}
}

//============== VCSetAtbDefLabelValue ==============
typedef void (CALLBACK* VCSetAtbDefLabelValueFN) (short*, char*, char*, char*, short);

void WINAPI VCSetAtbDefLabelValue (short* iError, char* szName, char* szLabel, char* Value, short iRec)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAtbDefLabelValue");
	if (fp)
	{
		((VCSetAtbDefLabelValueFN)fp)(iError, szName, szLabel, Value, iRec);
	}
}

//============== VCSetAtbDisplay ==============
typedef void (CALLBACK* VCSetAtbDisplayFN) (short*, vbool);

void WINAPI VCSetAtbDisplay (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAtbDisplay");
	if (fp)
	{
		((VCSetAtbDisplayFN)fp)(iError, tf);
	}
}

//============== VCSetAtbFont ==============
typedef void (CALLBACK* VCSetAtbFontFN) (short*, char*);

void WINAPI VCSetAtbFont (short* iError, char* pS)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAtbFont");
	if (fp)
	{
		((VCSetAtbFontFN)fp)(iError, pS);
	}
}

//============== VCSetAtbHeight ==============
typedef void (CALLBACK* VCSetAtbHeightFN) (short*, double);

void WINAPI VCSetAtbHeight (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAtbHeight");
	if (fp)
	{
		((VCSetAtbHeightFN)fp)(iError, dRet);
	}
}

//============== VCSetAtbLabel ==============
typedef void (CALLBACK* VCSetAtbLabelFN) (short*, vbool);

void WINAPI VCSetAtbLabel (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAtbLabel");
	if (fp)
	{
		((VCSetAtbLabelFN)fp)(iError, tf);
	}
}

//============== VCSetAutoFillet ==============
typedef void (CALLBACK* VCSetAutoFilletFN) (short*, vbool);

void WINAPI VCSetAutoFillet (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAutoFillet");
	if (fp)
	{
		((VCSetAutoFilletFN)fp)(iError, tf);
	}
}

//============== VCSetAutoSave ==============
typedef void (CALLBACK* VCSetAutoSaveFN) (short*, vbool);

void WINAPI VCSetAutoSave (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAutoSave");
	if (fp)
	{
		((VCSetAutoSaveFN)fp)(iError, tf);
	}
}

//============== VCSetAutoSaveSecs ==============
typedef void (CALLBACK* VCSetAutoSaveSecsFN) (short*, short);

void WINAPI VCSetAutoSaveSecs (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetAutoSaveSecs");
	if (fp)
	{
		((VCSetAutoSaveSecsFN)fp)(iError, i);
	}
}

//============== VCSetBackgroundColor ==============
typedef void (CALLBACK* VCSetBackgroundColorFN) (short*, short);

void WINAPI VCSetBackgroundColor (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetBackgroundColor");
	if (fp)
	{
		((VCSetBackgroundColorFN)fp)(iError, i);
	}
}

//============== VCSetBackwardsRedraw ==============
typedef void (CALLBACK* VCSetBackwardsRedrawFN) (short*, vbool);

void WINAPI VCSetBackwardsRedraw (short* iError, vbool tfBRD)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetBackwardsRedraw");
	if (fp)
	{
		((VCSetBackwardsRedrawFN)fp)(iError, tfBRD);
	}
}

//============== VCSetCMPPath ==============
typedef void (CALLBACK* VCSetCMPPathFN) (short*, char*);

void WINAPI VCSetCMPPath (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCMPPath");
	if (fp)
	{
		((VCSetCMPPathFN)fp)(iError, szPath);
	}
}

//============== VCSetChamferDist1 ==============
typedef void (CALLBACK* VCSetChamferDist1FN) (short*, double);

void WINAPI VCSetChamferDist1 (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetChamferDist1");
	if (fp)
	{
		((VCSetChamferDist1FN)fp)(iError, dRet);
	}
}

//============== VCSetChamferDist2 ==============
typedef void (CALLBACK* VCSetChamferDist2FN) (short*, double);

void WINAPI VCSetChamferDist2 (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetChamferDist2");
	if (fp)
	{
		((VCSetChamferDist2FN)fp)(iError, dRet);
	}
}

//============== VCSetCmdStr ==============
typedef void (CALLBACK* VCSetCmdStrFN) (short*, char*);

void WINAPI VCSetCmdStr (short* iError, char* pS)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCmdStr");
	if (fp)
	{
		((VCSetCmdStrFN)fp)(iError, pS);
	}
}

//============== VCSetColorIndex ==============
typedef void (CALLBACK* VCSetColorIndexFN) (short*, short);

void WINAPI VCSetColorIndex (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetColorIndex");
	if (fp)
	{
		((VCSetColorIndexFN)fp)(iError, i);
	}
}

//============== VCSetConstPt ==============
typedef void (CALLBACK* VCSetConstPtFN) (short*, vbool);

void WINAPI VCSetConstPt (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetConstPt");
	if (fp)
	{
		((VCSetConstPtFN)fp)(iError, tf);
	}
}

//============== VCSetCurEntAtbRecValue ==============
typedef void (CALLBACK* VCSetCurEntAtbRecValueFN) (short*, short, short, char*);

void WINAPI VCSetCurEntAtbRecValue (short* iError, short iWhichAtb, short iWhichRec, char* pValue)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurEntAtbRecValue");
	if (fp)
	{
		((VCSetCurEntAtbRecValueFN)fp)(iError, iWhichAtb, iWhichRec, pValue);
	}
}

//============== VCSetCurEntAtbRefPoint ==============
typedef void (CALLBACK* VCSetCurEntAtbRefPointFN) (short*, short, Point2D*);

void WINAPI VCSetCurEntAtbRefPoint (short* iError, short iWhichAtb, Point2D* dpRef)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurEntAtbRefPoint");
	if (fp)
	{
		((VCSetCurEntAtbRefPointFN)fp)(iError, iWhichAtb, dpRef);
	}
}

//============== VCSetCurrWorld ==============
typedef void (CALLBACK* VCSetCurrWorldFN) (WORLDHANDLE);

void WINAPI VCSetCurrWorld (WORLDHANDLE hW)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrWorld");
	if (fp)
	{
		((VCSetCurrWorldFN)fp)(hW);
	}
}

//============== VCSetCurrentDeSelected ==============
typedef void (CALLBACK* VCSetCurrentDeSelectedFN) (short*);

void WINAPI VCSetCurrentDeSelected (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentDeSelected");
	if (fp)
	{
		((VCSetCurrentDeSelectedFN)fp)(iError);
	}
}

//============== VCSetCurrentEntity ==============
typedef void (CALLBACK* VCSetCurrentEntityFN) (short*, ENTITYHANDLE);

void WINAPI VCSetCurrentEntity (short* iError, ENTITYHANDLE lH)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntity");
	if (fp)
	{
		((VCSetCurrentEntityFN)fp)(iError, lH);
	}
}

//============== VCSetCurrentEntity3DFlag0 ==============
typedef void (CALLBACK* VCSetCurrentEntity3DFlag0FN) (short*, short);

void WINAPI VCSetCurrentEntity3DFlag0 (short* iError, short iFlag)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntity3DFlag0");
	if (fp)
	{
		((VCSetCurrentEntity3DFlag0FN)fp)(iError, iFlag);
	}
}

//============== VCSetCurrentEntityCloseContour ==============
typedef void (CALLBACK* VCSetCurrentEntityCloseContourFN) (short*, vbool);

void WINAPI VCSetCurrentEntityCloseContour (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityCloseContour");
	if (fp)
	{
		((VCSetCurrentEntityCloseContourFN)fp)(iError, tf);
	}
}

//============== VCSetCurrentEntityPoint ==============
typedef void (CALLBACK* VCSetCurrentEntityPointFN) (short*, short, Point2D*);

void WINAPI VCSetCurrentEntityPoint (short* iError, short i, Point2D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityPoint");
	if (fp)
	{
		((VCSetCurrentEntityPointFN)fp)(iError, i, dpP);
	}
}

//============== VCSetCurrentEntityPoint3D ==============
typedef void (CALLBACK* VCSetCurrentEntityPoint3DFN) (short*, short, Point3D*);

void WINAPI VCSetCurrentEntityPoint3D (short* iError, short i, Point3D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityPoint3D");
	if (fp)
	{
		((VCSetCurrentEntityPoint3DFN)fp)(iError, i, dpP);
	}
}

//============== VCSetCurrentEntityPoints ==============
typedef void (CALLBACK* VCSetCurrentEntityPointsFN) (short*, Point2D*, short);

void WINAPI VCSetCurrentEntityPoints (short* iError, Point2D* p2dArray, short iPointCount)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityPoints");
	if (fp)
	{
		((VCSetCurrentEntityPointsFN)fp)(iError, p2dArray, iPointCount);
	}
}

//============== VCSetCurrentEntitySubEntity ==============
typedef void (CALLBACK* VCSetCurrentEntitySubEntityFN) (short*, ENTITYHANDLE, short, short);

void WINAPI VCSetCurrentEntitySubEntity (short* iError, ENTITYHANDLE lH, short iContour, short iEntity)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntitySubEntity");
	if (fp)
	{
		((VCSetCurrentEntitySubEntityFN)fp)(iError, lH, iContour, iEntity);
	}
}

//============== VCSetCurrentEntityUID ==============
typedef void (CALLBACK* VCSetCurrentEntityUIDFN) (short*, UID);

void WINAPI VCSetCurrentEntityUID (short* iError, UID uid)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityUID");
	if (fp)
	{
		((VCSetCurrentEntityUIDFN)fp)(iError, uid);
	}
}

//============== VCSetCurrentEntityUserDataByte ==============
typedef void (CALLBACK* VCSetCurrentEntityUserDataByteFN) (short*, short, BYTE);

void WINAPI VCSetCurrentEntityUserDataByte (short* iError, short iIndex, BYTE b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityUserDataByte");
	if (fp)
	{
		((VCSetCurrentEntityUserDataByteFN)fp)(iError, iIndex, b);
	}
}

//============== VCSetCurrentEntityUserDataChunk ==============
typedef void (CALLBACK* VCSetCurrentEntityUserDataChunkFN) (short*, short, void*, short);

void WINAPI VCSetCurrentEntityUserDataChunk (short* iError, short iIndex, void* p, short iSize)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityUserDataChunk");
	if (fp)
	{
		((VCSetCurrentEntityUserDataChunkFN)fp)(iError, iIndex, p, iSize);
	}
}

//============== VCSetCurrentEntityUserDataDouble ==============
typedef void (CALLBACK* VCSetCurrentEntityUserDataDoubleFN) (short*, short, double);

void WINAPI VCSetCurrentEntityUserDataDouble (short* iError, short iIndex, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityUserDataDouble");
	if (fp)
	{
		((VCSetCurrentEntityUserDataDoubleFN)fp)(iError, iIndex, dRet);
	}
}

//============== VCSetCurrentEntityUserDataFloat ==============
typedef void (CALLBACK* VCSetCurrentEntityUserDataFloatFN) (short*, short, float);

void WINAPI VCSetCurrentEntityUserDataFloat (short* iError, short iIndex, float f)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityUserDataFloat");
	if (fp)
	{
		((VCSetCurrentEntityUserDataFloatFN)fp)(iError, iIndex, f);
	}
}

//============== VCSetCurrentEntityUserDataLong ==============
typedef void (CALLBACK* VCSetCurrentEntityUserDataLongFN) (short*, short, long);

void WINAPI VCSetCurrentEntityUserDataLong (short* iError, short iIndex, long l)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityUserDataLong");
	if (fp)
	{
		((VCSetCurrentEntityUserDataLongFN)fp)(iError, iIndex, l);
	}
}

//============== VCSetCurrentEntityUserDataShort ==============
typedef void (CALLBACK* VCSetCurrentEntityUserDataShortFN) (short*, short, short);

void WINAPI VCSetCurrentEntityUserDataShort (short* iError, short iIndex, short s)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityUserDataShort");
	if (fp)
	{
		((VCSetCurrentEntityUserDataShortFN)fp)(iError, iIndex, s);
	}
}

//============== VCSetCurrentEntityUserDataString ==============
typedef void (CALLBACK* VCSetCurrentEntityUserDataStringFN) (short*, short, char*);

void WINAPI VCSetCurrentEntityUserDataString (short* iError, short iIndex, char* str)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentEntityUserDataString");
	if (fp)
	{
		((VCSetCurrentEntityUserDataStringFN)fp)(iError, iIndex, str);
	}
}

//============== VCSetCurrentErased ==============
typedef void (CALLBACK* VCSetCurrentErasedFN) (short*);

void WINAPI VCSetCurrentErased (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentErased");
	if (fp)
	{
		((VCSetCurrentErasedFN)fp)(iError);
	}
}

//============== VCSetCurrentSelected ==============
typedef void (CALLBACK* VCSetCurrentSelectedFN) (short*);

void WINAPI VCSetCurrentSelected (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentSelected");
	if (fp)
	{
		((VCSetCurrentSelectedFN)fp)(iError);
	}
}

//============== VCSetCurrentUnErased ==============
typedef void (CALLBACK* VCSetCurrentUnErasedFN) (short*);

void WINAPI VCSetCurrentUnErased (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentUnErased");
	if (fp)
	{
		((VCSetCurrentUnErasedFN)fp)(iError);
	}
}

//============== VCSetCurrentView ==============
typedef void (CALLBACK* VCSetCurrentViewFN) (short*, short);

void WINAPI VCSetCurrentView (short* iError, short iView)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrentView");
	if (fp)
	{
		((VCSetCurrentViewFN)fp)(iError, iView);
	}
}

//============== VCSetCursor ==============
typedef void (CALLBACK* VCSetCursorFN) (short*, char*);

void WINAPI VCSetCursor (short* iError, char* dzName)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCursor");
	if (fp)
	{
		((VCSetCursorFN)fp)(iError, dzName);
	}
}

//============== VCSetCursorColor ==============
typedef void (CALLBACK* VCSetCursorColorFN) (short*, short);

void WINAPI VCSetCursorColor (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCursorColor");
	if (fp)
	{
		((VCSetCursorColorFN)fp)(iError, i);
	}
}

//============== VCSetCursorFree ==============
typedef void (CALLBACK* VCSetCursorFreeFN) (short*, vbool);

void WINAPI VCSetCursorFree (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCursorFree");
	if (fp)
	{
		((VCSetCursorFreeFN)fp)(iError, tf);
	}
}

//============== VCSetCursorSize ==============
typedef void (CALLBACK* VCSetCursorSizeFN) (short*, short);

void WINAPI VCSetCursorSize (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCursorSize");
	if (fp)
	{
		((VCSetCursorSizeFN)fp)(iError, i);
	}
}

//============== VCSetDWGPath ==============
typedef void (CALLBACK* VCSetDWGPathFN) (short*, char*);

void WINAPI VCSetDWGPath (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDWGPath");
	if (fp)
	{
		((VCSetDWGPathFN)fp)(iError, szPath);
	}
}

//============== VCSetDXFPath ==============
typedef void (CALLBACK* VCSetDXFPathFN) (short*, char*);

void WINAPI VCSetDXFPath (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDXFPath");
	if (fp)
	{
		((VCSetDXFPathFN)fp)(iError, szPath);
	}
}

//============== VCSetDatumBasePt ==============
typedef void (CALLBACK* VCSetDatumBasePtFN) (short*, Point2D);

void WINAPI VCSetDatumBasePt (short* iError, Point2D p)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDatumBasePt");
	if (fp)
	{
		((VCSetDatumBasePtFN)fp)(iError, p);
	}
}

//============== VCSetDatumType ==============
typedef void (CALLBACK* VCSetDatumTypeFN) (short*, short);

void WINAPI VCSetDatumType (short* iError, short iDatumType)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDatumType");
	if (fp)
	{
		((VCSetDatumTypeFN)fp)(iError, iDatumType);
	}
}

//============== VCSetDefaultTool ==============
typedef void (CALLBACK* VCSetDefaultToolFN) (short*, WORD);

void WINAPI VCSetDefaultTool (short* iError, WORD w)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDefaultTool");
	if (fp)
	{
		((VCSetDefaultToolFN)fp)(iError, w);
	}
}

//============== VCSetDimAngleFormat ==============
typedef void (CALLBACK* VCSetDimAngleFormatFN) (short*, short);

void WINAPI VCSetDimAngleFormat (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimAngleFormat");
	if (fp)
	{
		((VCSetDimAngleFormatFN)fp)(iError, iF_);
	}
}

//============== VCSetDimArrowAngle ==============
typedef void (CALLBACK* VCSetDimArrowAngleFN) (short*, double);

void WINAPI VCSetDimArrowAngle (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimArrowAngle");
	if (fp)
	{
		((VCSetDimArrowAngleFN)fp)(iError, dRet);
	}
}

//============== VCSetDimArrowFlipDists ==============
typedef void (CALLBACK* VCSetDimArrowFlipDistsFN) (short*, double, double);

void WINAPI VCSetDimArrowFlipDists (short* iError, double d0, double d1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimArrowFlipDists");
	if (fp)
	{
		((VCSetDimArrowFlipDistsFN)fp)(iError, d0, d1);
	}
}

//============== VCSetDimArrowLength ==============
typedef void (CALLBACK* VCSetDimArrowLengthFN) (short*, double);

void WINAPI VCSetDimArrowLength (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimArrowLength");
	if (fp)
	{
		((VCSetDimArrowLengthFN)fp)(iError, dRet);
	}
}

//============== VCSetDimArrowMode ==============
typedef void (CALLBACK* VCSetDimArrowModeFN) (short*, short);

void WINAPI VCSetDimArrowMode (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimArrowMode");
	if (fp)
	{
		((VCSetDimArrowModeFN)fp)(iError, b);
	}
}

//============== VCSetDimArrowType ==============
typedef void (CALLBACK* VCSetDimArrowTypeFN) (short*, short);

void WINAPI VCSetDimArrowType (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimArrowType");
	if (fp)
	{
		((VCSetDimArrowTypeFN)fp)(iError, b);
	}
}

//============== VCSetDimDecimalValue ==============
typedef void (CALLBACK* VCSetDimDecimalValueFN) (short*, short);

void WINAPI VCSetDimDecimalValue (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimDecimalValue");
	if (fp)
	{
		((VCSetDimDecimalValueFN)fp)(iError, iF_);
	}
}

//============== VCSetDimDistFormat ==============
typedef void (CALLBACK* VCSetDimDistFormatFN) (short*, short);

void WINAPI VCSetDimDistFormat (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimDistFormat");
	if (fp)
	{
		((VCSetDimDistFormatFN)fp)(iError, iF_);
	}
}

//============== VCSetDimExtAbove ==============
typedef void (CALLBACK* VCSetDimExtAboveFN) (short*, double);

void WINAPI VCSetDimExtAbove (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimExtAbove");
	if (fp)
	{
		((VCSetDimExtAboveFN)fp)(iError, dRet);
	}
}

//============== VCSetDimExtBelow ==============
typedef void (CALLBACK* VCSetDimExtBelowFN) (short*, double);

void WINAPI VCSetDimExtBelow (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimExtBelow");
	if (fp)
	{
		((VCSetDimExtBelowFN)fp)(iError, dRet);
	}
}

//============== VCSetDimExtOffset ==============
typedef void (CALLBACK* VCSetDimExtOffsetFN) (short*, double);

void WINAPI VCSetDimExtOffset (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimExtOffset");
	if (fp)
	{
		((VCSetDimExtOffsetFN)fp)(iError, dRet);
	}
}

//============== VCSetDimFont ==============
typedef void (CALLBACK* VCSetDimFontFN) (short*, char*);

void WINAPI VCSetDimFont (short* iError, char* pS)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimFont");
	if (fp)
	{
		((VCSetDimFontFN)fp)(iError, pS);
	}
}

//============== VCSetDimFractionalValue ==============
typedef void (CALLBACK* VCSetDimFractionalValueFN) (short*, short);

void WINAPI VCSetDimFractionalValue (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimFractionalValue");
	if (fp)
	{
		((VCSetDimFractionalValueFN)fp)(iError, iF_);
	}
}

//============== VCSetDimItemColor ==============
typedef void (CALLBACK* VCSetDimItemColorFN) (short*, short, short);

void WINAPI VCSetDimItemColor (short* iError, short i, short j)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimItemColor");
	if (fp)
	{
		((VCSetDimItemColorFN)fp)(iError, i, j);
	}
}

//============== VCSetDimItemLineType ==============
typedef void (CALLBACK* VCSetDimItemLineTypeFN) (short*, short, short);

void WINAPI VCSetDimItemLineType (short* iError, short i, short j)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimItemLineType");
	if (fp)
	{
		((VCSetDimItemLineTypeFN)fp)(iError, i, j);
	}
}

//============== VCSetDimItemLineWidth ==============
typedef void (CALLBACK* VCSetDimItemLineWidthFN) (short*, short, short);

void WINAPI VCSetDimItemLineWidth (short* iError, short i, short j)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimItemLineWidth");
	if (fp)
	{
		((VCSetDimItemLineWidthFN)fp)(iError, i, j);
	}
}

//============== VCSetDimItemShow ==============
typedef void (CALLBACK* VCSetDimItemShowFN) (short*, short, vbool);

void WINAPI VCSetDimItemShow (short* iError, short i, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimItemShow");
	if (fp)
	{
		((VCSetDimItemShowFN)fp)(iError, i, tf);
	}
}

//============== VCSetDimLayer ==============
typedef void (CALLBACK* VCSetDimLayerFN) (short*, short);

void WINAPI VCSetDimLayer (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimLayer");
	if (fp)
	{
		((VCSetDimLayerFN)fp)(iError, i);
	}
}

//============== VCSetDimLineAngle ==============
typedef void (CALLBACK* VCSetDimLineAngleFN) (short*, double);

void WINAPI VCSetDimLineAngle (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimLineAngle");
	if (fp)
	{
		((VCSetDimLineAngleFN)fp)(iError, dRet);
	}
}

//============== VCSetDimLineDirect ==============
typedef void (CALLBACK* VCSetDimLineDirectFN) (short*, short);

void WINAPI VCSetDimLineDirect (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimLineDirect");
	if (fp)
	{
		((VCSetDimLineDirectFN)fp)(iError, b);
	}
}

//============== VCSetDimLineText ==============
typedef void (CALLBACK* VCSetDimLineTextFN) (short*, short);

void WINAPI VCSetDimLineText (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimLineText");
	if (fp)
	{
		((VCSetDimLineTextFN)fp)(iError, b);
	}
}

//============== VCSetDimShowDash ==============
typedef void (CALLBACK* VCSetDimShowDashFN) (short*, vbool);

void WINAPI VCSetDimShowDash (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimShowDash");
	if (fp)
	{
		((VCSetDimShowDashFN)fp)(iError, tf);
	}
}

//============== VCSetDimShowLeadingZeros ==============
typedef void (CALLBACK* VCSetDimShowLeadingZerosFN) (short*, short);

void WINAPI VCSetDimShowLeadingZeros (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimShowLeadingZeros");
	if (fp)
	{
		((VCSetDimShowLeadingZerosFN)fp)(iError, iF_);
	}
}

//============== VCSetDimShowUnits ==============
typedef void (CALLBACK* VCSetDimShowUnitsFN) (short*, short);

void WINAPI VCSetDimShowUnits (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimShowUnits");
	if (fp)
	{
		((VCSetDimShowUnitsFN)fp)(iError, iF_);
	}
}

//============== VCSetDimTextAspect ==============
typedef void (CALLBACK* VCSetDimTextAspectFN) (short*, double);

void WINAPI VCSetDimTextAspect (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextAspect");
	if (fp)
	{
		((VCSetDimTextAspectFN)fp)(iError, dRet);
	}
}

//============== VCSetDimTextBold ==============
typedef void (CALLBACK* VCSetDimTextBoldFN) (short*, short);

void WINAPI VCSetDimTextBold (short* iErrors, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextBold");
	if (fp)
	{
		((VCSetDimTextBoldFN)fp)(iErrors, i);
	}
}

//============== VCSetDimTextCentered ==============
typedef void (CALLBACK* VCSetDimTextCenteredFN) (short*, vbool);

void WINAPI VCSetDimTextCentered (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextCentered");
	if (fp)
	{
		((VCSetDimTextCenteredFN)fp)(iError, tf);
	}
}

//============== VCSetDimTextCharSpace ==============
typedef void (CALLBACK* VCSetDimTextCharSpaceFN) (short*, double);

void WINAPI VCSetDimTextCharSpace (short* iError, double dCharSpacing)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextCharSpace");
	if (fp)
	{
		((VCSetDimTextCharSpaceFN)fp)(iError, dCharSpacing);
	}
}

//============== VCSetDimTextFillVText ==============
typedef void (CALLBACK* VCSetDimTextFillVTextFN) (short*, vbool);

void WINAPI VCSetDimTextFillVText (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextFillVText");
	if (fp)
	{
		((VCSetDimTextFillVTextFN)fp)(iError, tf);
	}
}

//============== VCSetDimTextHeight ==============
typedef void (CALLBACK* VCSetDimTextHeightFN) (short*, double);

void WINAPI VCSetDimTextHeight (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextHeight");
	if (fp)
	{
		((VCSetDimTextHeightFN)fp)(iError, dRet);
	}
}

//============== VCSetDimTextHorizSpace ==============
typedef void (CALLBACK* VCSetDimTextHorizSpaceFN) (short*, double);

void WINAPI VCSetDimTextHorizSpace (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextHorizSpace");
	if (fp)
	{
		((VCSetDimTextHorizSpaceFN)fp)(iError, dRet);
	}
}

//============== VCSetDimTextItalic ==============
typedef void (CALLBACK* VCSetDimTextItalicFN) (short*, vbool);

void WINAPI VCSetDimTextItalic (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextItalic");
	if (fp)
	{
		((VCSetDimTextItalicFN)fp)(iError, tf);
	}
}

//============== VCSetDimTextItalicAng ==============
typedef void (CALLBACK* VCSetDimTextItalicAngFN) (short*, double);

void WINAPI VCSetDimTextItalicAng (short* iError, double dI)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextItalicAng");
	if (fp)
	{
		((VCSetDimTextItalicAngFN)fp)(iError, dI);
	}
}

//============== VCSetDimTextLineSpace ==============
typedef void (CALLBACK* VCSetDimTextLineSpaceFN) (short*, double);

void WINAPI VCSetDimTextLineSpace (short* iError, double dLineSpacing)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextLineSpace");
	if (fp)
	{
		((VCSetDimTextLineSpaceFN)fp)(iError, dLineSpacing);
	}
}

//============== VCSetDimTextOverwrite ==============
typedef void (CALLBACK* VCSetDimTextOverwriteFN) (short*, short);

void WINAPI VCSetDimTextOverwrite (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextOverwrite");
	if (fp)
	{
		((VCSetDimTextOverwriteFN)fp)(iError, b);
	}
}

//============== VCSetDimTextOverwriteString ==============
typedef void (CALLBACK* VCSetDimTextOverwriteStringFN) (short*, char*);

void WINAPI VCSetDimTextOverwriteString (short* iError, char* pB)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextOverwriteString");
	if (fp)
	{
		((VCSetDimTextOverwriteStringFN)fp)(iError, pB);
	}
}

//============== VCSetDimTextPrefix ==============
typedef void (CALLBACK* VCSetDimTextPrefixFN) (short*, short);

void WINAPI VCSetDimTextPrefix (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextPrefix");
	if (fp)
	{
		((VCSetDimTextPrefixFN)fp)(iError, b);
	}
}

//============== VCSetDimTextPrefixString ==============
typedef void (CALLBACK* VCSetDimTextPrefixStringFN) (short*, char*);

void WINAPI VCSetDimTextPrefixString (short* iError, char* pB)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextPrefixString");
	if (fp)
	{
		((VCSetDimTextPrefixStringFN)fp)(iError, pB);
	}
}

//============== VCSetDimTextProSpacing ==============
typedef void (CALLBACK* VCSetDimTextProSpacingFN) (short*, vbool);

void WINAPI VCSetDimTextProSpacing (short* iError, vbool b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextProSpacing");
	if (fp)
	{
		((VCSetDimTextProSpacingFN)fp)(iError, b);
	}
}

//============== VCSetDimTextRotationType ==============
typedef void (CALLBACK* VCSetDimTextRotationTypeFN) (short*, short);

void WINAPI VCSetDimTextRotationType (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextRotationType");
	if (fp)
	{
		((VCSetDimTextRotationTypeFN)fp)(iError, b);
	}
}

//============== VCSetDimTextScale ==============
typedef void (CALLBACK* VCSetDimTextScaleFN) (short*, double);

void WINAPI VCSetDimTextScale (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextScale");
	if (fp)
	{
		((VCSetDimTextScaleFN)fp)(iError, dRet);
	}
}

//============== VCSetDimTextSuffix ==============
typedef void (CALLBACK* VCSetDimTextSuffixFN) (short*, short);

void WINAPI VCSetDimTextSuffix (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextSuffix");
	if (fp)
	{
		((VCSetDimTextSuffixFN)fp)(iError, b);
	}
}

//============== VCSetDimTextSuffixString ==============
typedef void (CALLBACK* VCSetDimTextSuffixStringFN) (short*, char*);

void WINAPI VCSetDimTextSuffixString (short* iError, char* pB)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextSuffixString");
	if (fp)
	{
		((VCSetDimTextSuffixStringFN)fp)(iError, pB);
	}
}

//============== VCSetDimTextTolDecimal ==============
typedef void (CALLBACK* VCSetDimTextTolDecimalFN) (short*, short);

void WINAPI VCSetDimTextTolDecimal (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextTolDecimal");
	if (fp)
	{
		((VCSetDimTextTolDecimalFN)fp)(iError, b);
	}
}

//============== VCSetDimTextTolLowerVal ==============
typedef void (CALLBACK* VCSetDimTextTolLowerValFN) (short*, double);

void WINAPI VCSetDimTextTolLowerVal (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextTolLowerVal");
	if (fp)
	{
		((VCSetDimTextTolLowerValFN)fp)(iError, dRet);
	}
}

//============== VCSetDimTextTolType ==============
typedef void (CALLBACK* VCSetDimTextTolTypeFN) (short*, short);

void WINAPI VCSetDimTextTolType (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextTolType");
	if (fp)
	{
		((VCSetDimTextTolTypeFN)fp)(iError, b);
	}
}

//============== VCSetDimTextTolUpperVal ==============
typedef void (CALLBACK* VCSetDimTextTolUpperValFN) (short*, double);

void WINAPI VCSetDimTextTolUpperVal (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextTolUpperVal");
	if (fp)
	{
		((VCSetDimTextTolUpperValFN)fp)(iError, dRet);
	}
}

//============== VCSetDimTextUnderline ==============
typedef void (CALLBACK* VCSetDimTextUnderlineFN) (short*, vbool);

void WINAPI VCSetDimTextUnderline (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextUnderline");
	if (fp)
	{
		((VCSetDimTextUnderlineFN)fp)(iError, tf);
	}
}

//============== VCSetDimTextVertSpace ==============
typedef void (CALLBACK* VCSetDimTextVertSpaceFN) (short*, double);

void WINAPI VCSetDimTextVertSpace (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimTextVertSpace");
	if (fp)
	{
		((VCSetDimTextVertSpaceFN)fp)(iError, dRet);
	}
}

//============== VCSetDimUseDimLayer ==============
typedef void (CALLBACK* VCSetDimUseDimLayerFN) (short*, vbool);

void WINAPI VCSetDimUseDimLayer (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDimUseDimLayer");
	if (fp)
	{
		((VCSetDimUseDimLayerFN)fp)(iError, tf);
	}
}

//============== VCSetDisplayAngleFormat ==============
typedef void (CALLBACK* VCSetDisplayAngleFormatFN) (short*, short);

void WINAPI VCSetDisplayAngleFormat (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDisplayAngleFormat");
	if (fp)
	{
		((VCSetDisplayAngleFormatFN)fp)(iError, iF_);
	}
}

//============== VCSetDisplayDecimalValue ==============
typedef void (CALLBACK* VCSetDisplayDecimalValueFN) (short*, short);

void WINAPI VCSetDisplayDecimalValue (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDisplayDecimalValue");
	if (fp)
	{
		((VCSetDisplayDecimalValueFN)fp)(iError, iF_);
	}
}

//============== VCSetDisplayDistFormat ==============
typedef void (CALLBACK* VCSetDisplayDistFormatFN) (short*, short);

void WINAPI VCSetDisplayDistFormat (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDisplayDistFormat");
	if (fp)
	{
		((VCSetDisplayDistFormatFN)fp)(iError, iF_);
	}
}

//============== VCSetDisplayFontNotFoundMessage ==============
typedef void (CALLBACK* VCSetDisplayFontNotFoundMessageFN) (short*, vbool);

void WINAPI VCSetDisplayFontNotFoundMessage (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDisplayFontNotFoundMessage");
	if (fp)
	{
		((VCSetDisplayFontNotFoundMessageFN)fp)(iError, tf);
	}
}

//============== VCSetDisplayFractionalValue ==============
typedef void (CALLBACK* VCSetDisplayFractionalValueFN) (short*, short);

void WINAPI VCSetDisplayFractionalValue (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDisplayFractionalValue");
	if (fp)
	{
		((VCSetDisplayFractionalValueFN)fp)(iError, iF_);
	}
}

//============== VCSetDisplayHiddenLayersMessage ==============
typedef void (CALLBACK* VCSetDisplayHiddenLayersMessageFN) (short*, vbool);

void WINAPI VCSetDisplayHiddenLayersMessage (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDisplayHiddenLayersMessage");
	if (fp)
	{
		((VCSetDisplayHiddenLayersMessageFN)fp)(iError, tf);
	}
}

//============== VCSetDisplayShowLeadingZeros ==============
typedef void (CALLBACK* VCSetDisplayShowLeadingZerosFN) (short*, short);

void WINAPI VCSetDisplayShowLeadingZeros (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDisplayShowLeadingZeros");
	if (fp)
	{
		((VCSetDisplayShowLeadingZerosFN)fp)(iError, iF_);
	}
}

//============== VCSetDisplayShowUnits ==============
typedef void (CALLBACK* VCSetDisplayShowUnitsFN) (short*, short);

void WINAPI VCSetDisplayShowUnits (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDisplayShowUnits");
	if (fp)
	{
		((VCSetDisplayShowUnitsFN)fp)(iError, iF_);
	}
}

//============== VCSetDistanceHandle ==============
typedef void (CALLBACK* VCSetDistanceHandleFN) (long);

void WINAPI VCSetDistanceHandle (long hWnd_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDistanceHandle");
	if (fp)
	{
		((VCSetDistanceHandleFN)fp)(hWnd_);
	}
}

//============== VCSetDllRunCmdLine ==============
typedef void (CALLBACK* VCSetDllRunCmdLineFN) (short*, char*);

void WINAPI VCSetDllRunCmdLine (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDllRunCmdLine");
	if (fp)
	{
		((VCSetDllRunCmdLineFN)fp)(iError, szPath);
	}
}

//============== VCSetDllRunFunction ==============
typedef void (CALLBACK* VCSetDllRunFunctionFN) (short*, char*);

void WINAPI VCSetDllRunFunction (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDllRunFunction");
	if (fp)
	{
		((VCSetDllRunFunctionFN)fp)(iError, szPath);
	}
}

//============== VCSetDllRunName ==============
typedef void (CALLBACK* VCSetDllRunNameFN) (short*, char*);

void WINAPI VCSetDllRunName (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDllRunName");
	if (fp)
	{
		((VCSetDllRunNameFN)fp)(iError, szPath);
	}
}

//============== VCSetDrawFBoundary ==============
typedef void (CALLBACK* VCSetDrawFBoundaryFN) (short*, vbool);

void WINAPI VCSetDrawFBoundary (short* iError, vbool tfB)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDrawFBoundary");
	if (fp)
	{
		((VCSetDrawFBoundaryFN)fp)(iError, tfB);
	}
}

//============== VCSetDrawHBoundary ==============
typedef void (CALLBACK* VCSetDrawHBoundaryFN) (short*, vbool);

void WINAPI VCSetDrawHBoundary (short* iError, vbool tfB)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDrawHBoundary");
	if (fp)
	{
		((VCSetDrawHBoundaryFN)fp)(iError, tfB);
	}
}

//============== VCSetDrawingName ==============
typedef void (CALLBACK* VCSetDrawingNameFN) (char*);

void WINAPI VCSetDrawingName (char* pName)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDrawingName");
	if (fp)
	{
		((VCSetDrawingNameFN)fp)(pName);
	}
}

//============== VCSetEatNextLButtonDown ==============
typedef vbool (CALLBACK* VCSetEatNextLButtonDownFN) (short*, vbool);

vbool WINAPI VCSetEatNextLButtonDown (short* iError, vbool tfSet)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetEatNextLButtonDown");
	if (fp)
	{
		return ((VCSetEatNextLButtonDownFN)fp)(iError, tfSet);
	}
	return vbRet;
}

//============== VCSetEmbAtbLabelValue ==============
typedef void (CALLBACK* VCSetEmbAtbLabelValueFN) (short*, short, short, char*, char*, short);

void WINAPI VCSetEmbAtbLabelValue (short* iError, short iWhichSymbolDef, short iWhichAtb, char* szLabel, char* Value, short iRec)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetEmbAtbLabelValue");
	if (fp)
	{
		((VCSetEmbAtbLabelValueFN)fp)(iError, iWhichSymbolDef, iWhichAtb, szLabel, Value, iRec);
	}
}

//============== VCSetEntitySection ==============
typedef void (CALLBACK* VCSetEntitySectionFN) (short*);

void WINAPI VCSetEntitySection (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetEntitySection");
	if (fp)
	{
		((VCSetEntitySectionFN)fp)(iError);
	}
}

//============== VCSetExeName ==============
typedef void (CALLBACK* VCSetExeNameFN) (short*, char*);

void WINAPI VCSetExeName (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetExeName");
	if (fp)
	{
		((VCSetExeNameFN)fp)(iError, sz);
	}
}

//============== VCSetExplodeContinuousLines ==============
typedef void (CALLBACK* VCSetExplodeContinuousLinesFN) (short*, BYTE);

void WINAPI VCSetExplodeContinuousLines (short* iError, BYTE tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetExplodeContinuousLines");
	if (fp)
	{
		((VCSetExplodeContinuousLinesFN)fp)(iError, tf);
	}
}

//============== VCSetFillColor ==============
typedef void (CALLBACK* VCSetFillColorFN) (short*, short);

void WINAPI VCSetFillColor (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFillColor");
	if (fp)
	{
		((VCSetFillColorFN)fp)(iError, i);
	}
}

//============== VCSetFillDisplay ==============
typedef void (CALLBACK* VCSetFillDisplayFN) (short*, vbool);

void WINAPI VCSetFillDisplay (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFillDisplay");
	if (fp)
	{
		((VCSetFillDisplayFN)fp)(iError, tf);
	}
}

//============== VCSetFillVText ==============
typedef void (CALLBACK* VCSetFillVTextFN) (short*, vbool);

void WINAPI VCSetFillVText (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFillVText");
	if (fp)
	{
		((VCSetFillVTextFN)fp)(iError, tf);
	}
}

//============== VCSetFilletPreview ==============
typedef void (CALLBACK* VCSetFilletPreviewFN) (short*, vbool);

void WINAPI VCSetFilletPreview (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilletPreview");
	if (fp)
	{
		((VCSetFilletPreviewFN)fp)(iError, tf);
	}
}

//============== VCSetFilletRad ==============
typedef void (CALLBACK* VCSetFilletRadFN) (short*, double);

void WINAPI VCSetFilletRad (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilletRad");
	if (fp)
	{
		((VCSetFilletRadFN)fp)(iError, dRet);
	}
}

//============== VCSetFilterActive ==============
typedef void (CALLBACK* VCSetFilterActiveFN) (short*, vbool);

void WINAPI VCSetFilterActive (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilterActive");
	if (fp)
	{
		((VCSetFilterActiveFN)fp)(iError, tf);
	}
}

//============== VCSetFilterColor ==============
typedef void (CALLBACK* VCSetFilterColorFN) (short*, short);

void WINAPI VCSetFilterColor (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilterColor");
	if (fp)
	{
		((VCSetFilterColorFN)fp)(iError, i);
	}
}

//============== VCSetFilterKind ==============
typedef void (CALLBACK* VCSetFilterKindFN) (short*, BYTE);

void WINAPI VCSetFilterKind (short* iError, BYTE b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilterKind");
	if (fp)
	{
		((VCSetFilterKindFN)fp)(iError, b);
	}
}

//============== VCSetFilterKind2 ==============
typedef void (CALLBACK* VCSetFilterKind2FN) (short*, BYTE);

void WINAPI VCSetFilterKind2 (short* iError, BYTE b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilterKind2");
	if (fp)
	{
		((VCSetFilterKind2FN)fp)(iError, b);
	}
}

//============== VCSetFilterLayer ==============
typedef void (CALLBACK* VCSetFilterLayerFN) (short*, short);

void WINAPI VCSetFilterLayer (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilterLayer");
	if (fp)
	{
		((VCSetFilterLayerFN)fp)(iError, i);
	}
}

//============== VCSetFilterLineType ==============
typedef void (CALLBACK* VCSetFilterLineTypeFN) (short*, short);

void WINAPI VCSetFilterLineType (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilterLineType");
	if (fp)
	{
		((VCSetFilterLineTypeFN)fp)(iError, i);
	}
}

//============== VCSetFilterMatch ==============
typedef void (CALLBACK* VCSetFilterMatchFN) (short*, ENTITYHANDLE);

void WINAPI VCSetFilterMatch (short* iError, ENTITYHANDLE EH)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilterMatch");
	if (fp)
	{
		((VCSetFilterMatchFN)fp)(iError, EH);
	}
}

//============== VCSetFilterName ==============
typedef void (CALLBACK* VCSetFilterNameFN) (short*, char*);

void WINAPI VCSetFilterName (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilterName");
	if (fp)
	{
		((VCSetFilterNameFN)fp)(iError, sz);
	}
}

//============== VCSetFilterWidth ==============
typedef void (CALLBACK* VCSetFilterWidthFN) (short*, short);

void WINAPI VCSetFilterWidth (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFilterWidth");
	if (fp)
	{
		((VCSetFilterWidthFN)fp)(iError, i);
	}
}

//============== VCSetFunkeyCmdString ==============
typedef vbool (CALLBACK* VCSetFunkeyCmdStringFN) (char*, short, short);

vbool WINAPI VCSetFunkeyCmdString (char* szCmd, short iShift, short nVKey)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetFunkeyCmdString");
	if (fp)
	{
		return ((VCSetFunkeyCmdStringFN)fp)(szCmd, iShift, nVKey);
	}
	return vbRet;
}

//============== VCSetGCDDefaultHatchName ==============
typedef void (CALLBACK* VCSetGCDDefaultHatchNameFN) (short*, char*);

void WINAPI VCSetGCDDefaultHatchName (short* iError, char* szName)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetGCDDefaultHatchName");
	if (fp)
	{
		((VCSetGCDDefaultHatchNameFN)fp)(iError, szName);
	}
}

//============== VCSetGCDPath ==============
typedef void (CALLBACK* VCSetGCDPathFN) (short*, char*);

void WINAPI VCSetGCDPath (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetGCDPath");
	if (fp)
	{
		((VCSetGCDPathFN)fp)(iError, szPath);
	}
}

//============== VCSetGraphicPenWidth ==============
typedef void (CALLBACK* VCSetGraphicPenWidthFN) (short*, double);

void WINAPI VCSetGraphicPenWidth (short* iError, double dPen)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetGraphicPenWidth");
	if (fp)
	{
		((VCSetGraphicPenWidthFN)fp)(iError, dPen);
	}
}

//============== VCSetGridDisplay ==============
typedef void (CALLBACK* VCSetGridDisplayFN) (short*, vbool);

void WINAPI VCSetGridDisplay (short* iError, vbool tfDisp)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetGridDisplay");
	if (fp)
	{
		((VCSetGridDisplayFN)fp)(iError, tfDisp);
	}
}

//============== VCSetGridOrigin ==============
typedef void (CALLBACK* VCSetGridOriginFN) (short*, Point2D);

void WINAPI VCSetGridOrigin (short* iError, Point2D dpOrg)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetGridOrigin");
	if (fp)
	{
		((VCSetGridOriginFN)fp)(iError, dpOrg);
	}
}

//============== VCSetGridOriginBP ==============
typedef void (CALLBACK* VCSetGridOriginBPFN) (short*, Point2D*);

void WINAPI VCSetGridOriginBP (short* iError, Point2D* dpOrg_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetGridOriginBP");
	if (fp)
	{
		((VCSetGridOriginBPFN)fp)(iError, dpOrg_);
	}
}

//============== VCSetGridSize ==============
typedef void (CALLBACK* VCSetGridSizeFN) (short*, Point2D);

void WINAPI VCSetGridSize (short* iError, Point2D dpSize)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetGridSize");
	if (fp)
	{
		((VCSetGridSizeFN)fp)(iError, dpSize);
	}
}

//============== VCSetGridSizeBP ==============
typedef void (CALLBACK* VCSetGridSizeBPFN) (short*, Point2D*);

void WINAPI VCSetGridSizeBP (short* iError, Point2D* dpSize_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetGridSizeBP");
	if (fp)
	{
		((VCSetGridSizeBPFN)fp)(iError, dpSize_);
	}
}

//============== VCSetGridSnap ==============
typedef void (CALLBACK* VCSetGridSnapFN) (short*, vbool);

void WINAPI VCSetGridSnap (short* iError, vbool tfSnap)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetGridSnap");
	if (fp)
	{
		((VCSetGridSnapFN)fp)(iError, tfSnap);
	}
}

//============== VCSetHandlePt ==============
typedef void (CALLBACK* VCSetHandlePtFN) (short*, vbool);

void WINAPI VCSetHandlePt (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetHandlePt");
	if (fp)
	{
		((VCSetHandlePtFN)fp)(iError, tf);
	}
}

//============== VCSetHatchColor ==============
typedef void (CALLBACK* VCSetHatchColorFN) (short*, short);

void WINAPI VCSetHatchColor (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetHatchColor");
	if (fp)
	{
		((VCSetHatchColorFN)fp)(iError, i);
	}
}

//============== VCSetHatchDisplay ==============
typedef void (CALLBACK* VCSetHatchDisplayFN) (short*, vbool);

void WINAPI VCSetHatchDisplay (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetHatchDisplay");
	if (fp)
	{
		((VCSetHatchDisplayFN)fp)(iError, tf);
	}
}

//============== VCSetHatchName ==============
typedef void (CALLBACK* VCSetHatchNameFN) (short*, char*);

void WINAPI VCSetHatchName (short* iError, char* s)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetHatchName");
	if (fp)
	{
		((VCSetHatchNameFN)fp)(iError, s);
	}
}

//============== VCSetHatchRot ==============
typedef void (CALLBACK* VCSetHatchRotFN) (short*, double);

void WINAPI VCSetHatchRot (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetHatchRot");
	if (fp)
	{
		((VCSetHatchRotFN)fp)(iError, dRet);
	}
}

//============== VCSetHatchScale ==============
typedef void (CALLBACK* VCSetHatchScaleFN) (short*, double);

void WINAPI VCSetHatchScale (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetHatchScale");
	if (fp)
	{
		((VCSetHatchScaleFN)fp)(iError, dRet);
	}
}

//============== VCSetHeaderUserData ==============
typedef void (CALLBACK* VCSetHeaderUserDataFN) (short*);

void WINAPI VCSetHeaderUserData (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetHeaderUserData");
	if (fp)
	{
		((VCSetHeaderUserDataFN)fp)(iError);
	}
}

//============== VCSetHighlight ==============
typedef void (CALLBACK* VCSetHighlightFN) (short*, vbool);

void WINAPI VCSetHighlight (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetHighlight");
	if (fp)
	{
		((VCSetHighlightFN)fp)(iError, tf);
	}
}

//============== VCSetIncSnap ==============
typedef void (CALLBACK* VCSetIncSnapFN) (short*, vbool);

void WINAPI VCSetIncSnap (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetIncSnap");
	if (fp)
	{
		((VCSetIncSnapFN)fp)(iError, tf);
	}
}

//============== VCSetIncSnapSize ==============
typedef void (CALLBACK* VCSetIncSnapSizeFN) (short*, double);

void WINAPI VCSetIncSnapSize (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetIncSnapSize");
	if (fp)
	{
		((VCSetIncSnapSizeFN)fp)(iError, dRet);
	}
}

//============== VCSetIsoMode ==============
typedef void (CALLBACK* VCSetIsoModeFN) (short*, vbool);

void WINAPI VCSetIsoMode (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetIsoMode");
	if (fp)
	{
		((VCSetIsoModeFN)fp)(iError, tf);
	}
}

//============== VCSetIsoPlane ==============
typedef void (CALLBACK* VCSetIsoPlaneFN) (short*, short);

void WINAPI VCSetIsoPlane (short* iError, short iPlane)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetIsoPlane");
	if (fp)
	{
		((VCSetIsoPlaneFN)fp)(iError, iPlane);
	}
}

//============== VCSetKeepAcadFontName ==============
typedef void (CALLBACK* VCSetKeepAcadFontNameFN) (short*, BOOL);

void WINAPI VCSetKeepAcadFontName (short* iError, BOOL tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetKeepAcadFontName");
	if (fp)
	{
		((VCSetKeepAcadFontNameFN)fp)(iError, tf);
	}
}

//============== VCSetKeepGCDFontName ==============
typedef void (CALLBACK* VCSetKeepGCDFontNameFN) (short*, BOOL);

void WINAPI VCSetKeepGCDFontName (short* iError, BOOL tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetKeepGCDFontName");
	if (fp)
	{
		((VCSetKeepGCDFontNameFN)fp)(iError, tf);
	}
}

//============== VCSetKeepGCDHatch ==============
typedef void (CALLBACK* VCSetKeepGCDHatchFN) (short*, BOOL);

void WINAPI VCSetKeepGCDHatch (short* iError, BOOL tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetKeepGCDHatch");
	if (fp)
	{
		((VCSetKeepGCDHatchFN)fp)(iError, tf);
	}
}

//============== VCSetLTScaleDevice ==============
typedef void (CALLBACK* VCSetLTScaleDeviceFN) (short*, double);

void WINAPI VCSetLTScaleDevice (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLTScaleDevice");
	if (fp)
	{
		((VCSetLTScaleDeviceFN)fp)(iError, dRet);
	}
}

//============== VCSetLTScaleWorld ==============
typedef void (CALLBACK* VCSetLTScaleWorldFN) (short*, double);

void WINAPI VCSetLTScaleWorld (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLTScaleWorld");
	if (fp)
	{
		((VCSetLTScaleWorldFN)fp)(iError, dRet);
	}
}

//============== VCSetLastCommandId ==============
typedef void (CALLBACK* VCSetLastCommandIdFN) (WORD);

void WINAPI VCSetLastCommandId (WORD CmdId)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLastCommandId");
	if (fp)
	{
		((VCSetLastCommandIdFN)fp)(CmdId);
	}
}

//============== VCSetLastPoint ==============
typedef void (CALLBACK* VCSetLastPointFN) (short*, Point2D*);

void WINAPI VCSetLastPoint (short* iError, Point2D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLastPoint");
	if (fp)
	{
		((VCSetLastPointFN)fp)(iError, dpP);
	}
}

//============== VCSetLayerDisplay ==============
typedef void (CALLBACK* VCSetLayerDisplayFN) (short*, short, vbool);

void WINAPI VCSetLayerDisplay (short* iError, short iIndex, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLayerDisplay");
	if (fp)
	{
		((VCSetLayerDisplayFN)fp)(iError, iIndex, tf);
	}
}

//============== VCSetLayerIndex ==============
typedef void (CALLBACK* VCSetLayerIndexFN) (short*, short);

void WINAPI VCSetLayerIndex (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLayerIndex");
	if (fp)
	{
		((VCSetLayerIndexFN)fp)(iError, i);
	}
}

//============== VCSetLayerProperties ==============
typedef vbool (CALLBACK* VCSetLayerPropertiesFN) (short*, short, short, short, short, float);

vbool WINAPI VCSetLayerProperties (short* iError, short iLayer, short iColor, short iLtype, short iWidth, float fWidth)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLayerProperties");
	if (fp)
	{
		return ((VCSetLayerPropertiesFN)fp)(iError, iLayer, iColor, iLtype, iWidth, fWidth);
	}
	return vbRet;
}

//============== VCSetLayerRedraw ==============
typedef void (CALLBACK* VCSetLayerRedrawFN) (short*, vbool);

void WINAPI VCSetLayerRedraw (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLayerRedraw");
	if (fp)
	{
		((VCSetLayerRedrawFN)fp)(iError, tf);
	}
}

//============== VCSetLeaderArrowAngle ==============
typedef void (CALLBACK* VCSetLeaderArrowAngleFN) (short*, double);

void WINAPI VCSetLeaderArrowAngle (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderArrowAngle");
	if (fp)
	{
		((VCSetLeaderArrowAngleFN)fp)(iError, dRet);
	}
}

//============== VCSetLeaderArrowLength ==============
typedef void (CALLBACK* VCSetLeaderArrowLengthFN) (short*, double);

void WINAPI VCSetLeaderArrowLength (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderArrowLength");
	if (fp)
	{
		((VCSetLeaderArrowLengthFN)fp)(iError, dRet);
	}
}

//============== VCSetLeaderArrowMode ==============
typedef void (CALLBACK* VCSetLeaderArrowModeFN) (short*, short);

void WINAPI VCSetLeaderArrowMode (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderArrowMode");
	if (fp)
	{
		((VCSetLeaderArrowModeFN)fp)(iError, b);
	}
}

//============== VCSetLeaderArrowType ==============
typedef void (CALLBACK* VCSetLeaderArrowTypeFN) (short*, short);

void WINAPI VCSetLeaderArrowType (short* iError, short b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderArrowType");
	if (fp)
	{
		((VCSetLeaderArrowTypeFN)fp)(iError, b);
	}
}

//============== VCSetLeaderFontName ==============
typedef void (CALLBACK* VCSetLeaderFontNameFN) (short*, char*);

void WINAPI VCSetLeaderFontName (short* iError, char* pS)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderFontName");
	if (fp)
	{
		((VCSetLeaderFontNameFN)fp)(iError, pS);
	}
}

//============== VCSetLeaderShoulderLength ==============
typedef void (CALLBACK* VCSetLeaderShoulderLengthFN) (short*, double);

void WINAPI VCSetLeaderShoulderLength (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderShoulderLength");
	if (fp)
	{
		((VCSetLeaderShoulderLengthFN)fp)(iError, dRet);
	}
}

//============== VCSetLeaderString ==============
typedef void (CALLBACK* VCSetLeaderStringFN) (short*, char*);

void WINAPI VCSetLeaderString (short* iError, char* s)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderString");
	if (fp)
	{
		((VCSetLeaderStringFN)fp)(iError, s);
	}
}

//============== VCSetLeaderTextAspect ==============
typedef void (CALLBACK* VCSetLeaderTextAspectFN) (short*, double);

void WINAPI VCSetLeaderTextAspect (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextAspect");
	if (fp)
	{
		((VCSetLeaderTextAspectFN)fp)(iError, dRet);
	}
}

//============== VCSetLeaderTextBold ==============
typedef void (CALLBACK* VCSetLeaderTextBoldFN) (short*, short);

void WINAPI VCSetLeaderTextBold (short* iErrors, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextBold");
	if (fp)
	{
		((VCSetLeaderTextBoldFN)fp)(iErrors, i);
	}
}

//============== VCSetLeaderTextCharSpace ==============
typedef void (CALLBACK* VCSetLeaderTextCharSpaceFN) (short*, double);

void WINAPI VCSetLeaderTextCharSpace (short* iError, double dCharSpacing)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextCharSpace");
	if (fp)
	{
		((VCSetLeaderTextCharSpaceFN)fp)(iError, dCharSpacing);
	}
}

//============== VCSetLeaderTextFillVText ==============
typedef void (CALLBACK* VCSetLeaderTextFillVTextFN) (short*, vbool);

void WINAPI VCSetLeaderTextFillVText (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextFillVText");
	if (fp)
	{
		((VCSetLeaderTextFillVTextFN)fp)(iError, tf);
	}
}

//============== VCSetLeaderTextHeight ==============
typedef void (CALLBACK* VCSetLeaderTextHeightFN) (short*, double);

void WINAPI VCSetLeaderTextHeight (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextHeight");
	if (fp)
	{
		((VCSetLeaderTextHeightFN)fp)(iError, dRet);
	}
}

//============== VCSetLeaderTextItalic ==============
typedef void (CALLBACK* VCSetLeaderTextItalicFN) (short*, vbool);

void WINAPI VCSetLeaderTextItalic (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextItalic");
	if (fp)
	{
		((VCSetLeaderTextItalicFN)fp)(iError, tf);
	}
}

//============== VCSetLeaderTextItalicAng ==============
typedef void (CALLBACK* VCSetLeaderTextItalicAngFN) (short*, double);

void WINAPI VCSetLeaderTextItalicAng (short* iError, double dI)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextItalicAng");
	if (fp)
	{
		((VCSetLeaderTextItalicAngFN)fp)(iError, dI);
	}
}

//============== VCSetLeaderTextLineSpace ==============
typedef void (CALLBACK* VCSetLeaderTextLineSpaceFN) (short*, double);

void WINAPI VCSetLeaderTextLineSpace (short* iError, double dLineSpacing)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextLineSpace");
	if (fp)
	{
		((VCSetLeaderTextLineSpaceFN)fp)(iError, dLineSpacing);
	}
}

//============== VCSetLeaderTextOffset ==============
typedef void (CALLBACK* VCSetLeaderTextOffsetFN) (short*, double);

void WINAPI VCSetLeaderTextOffset (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextOffset");
	if (fp)
	{
		((VCSetLeaderTextOffsetFN)fp)(iError, dRet);
	}
}

//============== VCSetLeaderTextProSpacing ==============
typedef void (CALLBACK* VCSetLeaderTextProSpacingFN) (short*, vbool);

void WINAPI VCSetLeaderTextProSpacing (short* iError, vbool b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextProSpacing");
	if (fp)
	{
		((VCSetLeaderTextProSpacingFN)fp)(iError, b);
	}
}

//============== VCSetLeaderTextUnderline ==============
typedef void (CALLBACK* VCSetLeaderTextUnderlineFN) (short*, vbool);

void WINAPI VCSetLeaderTextUnderline (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLeaderTextUnderline");
	if (fp)
	{
		((VCSetLeaderTextUnderlineFN)fp)(iError, tf);
	}
}

//============== VCSetLineTypeDisplay ==============
typedef void (CALLBACK* VCSetLineTypeDisplayFN) (short*, vbool);

void WINAPI VCSetLineTypeDisplay (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLineTypeDisplay");
	if (fp)
	{
		((VCSetLineTypeDisplayFN)fp)(iError, tf);
	}
}

//============== VCSetLineTypeIndex ==============
typedef void (CALLBACK* VCSetLineTypeIndexFN) (short*, short);

void WINAPI VCSetLineTypeIndex (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLineTypeIndex");
	if (fp)
	{
		((VCSetLineTypeIndexFN)fp)(iError, i);
	}
}

//============== VCSetLineWidthDisplay ==============
typedef void (CALLBACK* VCSetLineWidthDisplayFN) (short*, vbool);

void WINAPI VCSetLineWidthDisplay (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLineWidthDisplay");
	if (fp)
	{
		((VCSetLineWidthDisplayFN)fp)(iError, tf);
	}
}

//============== VCSetLineWidthIndex ==============
typedef void (CALLBACK* VCSetLineWidthIndexFN) (short*, short);

void WINAPI VCSetLineWidthIndex (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLineWidthIndex");
	if (fp)
	{
		((VCSetLineWidthIndexFN)fp)(iError, i);
	}
}

//============== VCSetLineWidthValue ==============
typedef void (CALLBACK* VCSetLineWidthValueFN) (short*, float);

void WINAPI VCSetLineWidthValue (short* iError, float dV)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLineWidthValue");
	if (fp)
	{
		((VCSetLineWidthValueFN)fp)(iError, dV);
	}
}

//============== VCSetMBMode ==============
typedef void (CALLBACK* VCSetMBModeFN) (short*);

void WINAPI VCSetMBMode (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetMBMode");
	if (fp)
	{
		((VCSetMBModeFN)fp)(iError);
	}
}

//============== VCSetMOMode ==============
typedef void (CALLBACK* VCSetMOModeFN) (short*);

void WINAPI VCSetMOMode (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetMOMode");
	if (fp)
	{
		((VCSetMOModeFN)fp)(iError);
	}
}

//============== VCSetMRMode ==============
typedef void (CALLBACK* VCSetMRModeFN) (short*);

void WINAPI VCSetMRMode (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetMRMode");
	if (fp)
	{
		((VCSetMRModeFN)fp)(iError);
	}
}

//============== VCSetMapAcadPolylineWidths ==============
typedef void (CALLBACK* VCSetMapAcadPolylineWidthsFN) (short*, vbool);

void WINAPI VCSetMapAcadPolylineWidths (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetMapAcadPolylineWidths");
	if (fp)
	{
		((VCSetMapAcadPolylineWidthsFN)fp)(iError, tf);
	}
}

//============== VCSetMaxUID ==============
typedef void (CALLBACK* VCSetMaxUIDFN) (short*, UID);

void WINAPI VCSetMaxUID (short* iError, UID uidMax)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetMaxUID");
	if (fp)
	{
		((VCSetMaxUIDFN)fp)(iError, uidMax);
	}
}

//============== VCSetMenu ==============
typedef void (CALLBACK* VCSetMenuFN) (short*, char*);

void WINAPI VCSetMenu (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetMenu");
	if (fp)
	{
		((VCSetMenuFN)fp)(iError, sz);
	}
}

//============== VCSetMessageHandle ==============
typedef void (CALLBACK* VCSetMessageHandleFN) (long);

void WINAPI VCSetMessageHandle (long hWnd_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetMessageHandle");
	if (fp)
	{
		((VCSetMessageHandleFN)fp)(hWnd_);
	}
}

//============== VCSetNamedLayer ==============
typedef void (CALLBACK* VCSetNamedLayerFN) (short*, short, char*);

void WINAPI VCSetNamedLayer (short* iError, short iIndex, char* pName)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetNamedLayer");
	if (fp)
	{
		((VCSetNamedLayerFN)fp)(iError, iIndex, pName);
	}
}

//============== VCSetNumCopies ==============
typedef void (CALLBACK* VCSetNumCopiesFN) (short*, short);

void WINAPI VCSetNumCopies (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetNumCopies");
	if (fp)
	{
		((VCSetNumCopiesFN)fp)(iError, i);
	}
}

//============== VCSetNumRows ==============
typedef void (CALLBACK* VCSetNumRowsFN) (short*, short);

void WINAPI VCSetNumRows (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetNumRows");
	if (fp)
	{
		((VCSetNumRowsFN)fp)(iError, i);
	}
}

//============== VCSetOffsetDist ==============
typedef void (CALLBACK* VCSetOffsetDistFN) (short*, double);

void WINAPI VCSetOffsetDist (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetOffsetDist");
	if (fp)
	{
		((VCSetOffsetDistFN)fp)(iError, dRet);
	}
}

//============== VCSetOffsetFixed ==============
typedef void (CALLBACK* VCSetOffsetFixedFN) (short*, vbool);

void WINAPI VCSetOffsetFixed (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetOffsetFixed");
	if (fp)
	{
		((VCSetOffsetFixedFN)fp)(iError, tf);
	}
}

//============== VCSetOleDllClassName ==============
typedef void (CALLBACK* VCSetOleDllClassNameFN) (short*, char*);

void WINAPI VCSetOleDllClassName (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetOleDllClassName");
	if (fp)
	{
		((VCSetOleDllClassNameFN)fp)(iError, szPath);
	}
}

//============== VCSetOleDllFunctionCmdLine ==============
typedef void (CALLBACK* VCSetOleDllFunctionCmdLineFN) (short*, char*);

void WINAPI VCSetOleDllFunctionCmdLine (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetOleDllFunctionCmdLine");
	if (fp)
	{
		((VCSetOleDllFunctionCmdLineFN)fp)(iError, szPath);
	}
}

//============== VCSetOleDllFunctionName ==============
typedef void (CALLBACK* VCSetOleDllFunctionNameFN) (short*, char*);

void WINAPI VCSetOleDllFunctionName (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetOleDllFunctionName");
	if (fp)
	{
		((VCSetOleDllFunctionNameFN)fp)(iError, szPath);
	}
}

//============== VCSetOleDllName ==============
typedef void (CALLBACK* VCSetOleDllNameFN) (short*, char*);

void WINAPI VCSetOleDllName (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetOleDllName");
	if (fp)
	{
		((VCSetOleDllNameFN)fp)(iError, szPath);
	}
}

//============== VCSetOrdinateTextOffset ==============
typedef void (CALLBACK* VCSetOrdinateTextOffsetFN) (short*, double);

void WINAPI VCSetOrdinateTextOffset (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetOrdinateTextOffset");
	if (fp)
	{
		((VCSetOrdinateTextOffsetFN)fp)(iError, dRet);
	}
}

//============== VCSetOrthoAng ==============
typedef void (CALLBACK* VCSetOrthoAngFN) (short*, double);

void WINAPI VCSetOrthoAng (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetOrthoAng");
	if (fp)
	{
		((VCSetOrthoAngFN)fp)(iError, dRet);
	}
}

//============== VCSetOrthoMode ==============
typedef void (CALLBACK* VCSetOrthoModeFN) (short*, vbool);

void WINAPI VCSetOrthoMode (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetOrthoMode");
	if (fp)
	{
		((VCSetOrthoModeFN)fp)(iError, tf);
	}
}

//============== VCSetPointDisplay ==============
typedef void (CALLBACK* VCSetPointDisplayFN) (short*, vbool);

void WINAPI VCSetPointDisplay (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetPointDisplay");
	if (fp)
	{
		((VCSetPointDisplayFN)fp)(iError, tf);
	}
}

//============== VCSetPopupButton ==============
typedef void (CALLBACK* VCSetPopupButtonFN) (short*, short);

void WINAPI VCSetPopupButton (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetPopupButton");
	if (fp)
	{
		((VCSetPopupButtonFN)fp)(iError, i);
	}
}

//============== VCSetPreserveAcadColorNums ==============
typedef void (CALLBACK* VCSetPreserveAcadColorNumsFN) (short*, BOOL);

void WINAPI VCSetPreserveAcadColorNums (short* iError, BOOL tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetPreserveAcadColorNums");
	if (fp)
	{
		((VCSetPreserveAcadColorNumsFN)fp)(iError, tf);
	}
}

//============== VCSetProjection3D ==============
typedef void (CALLBACK* VCSetProjection3DFN) (short*, short);

void WINAPI VCSetProjection3D (short* iError, short iCode)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetProjection3D");
	if (fp)
	{
		((VCSetProjection3DFN)fp)(iError, iCode);
	}
}

//============== VCSetQuickSearch ==============
typedef void (CALLBACK* VCSetQuickSearchFN) (short*, vbool);

void WINAPI VCSetQuickSearch (short* iError, vbool tfQS)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetQuickSearch");
	if (fp)
	{
		((VCSetQuickSearchFN)fp)(iError, tfQS);
	}
}

//============== VCSetRPolyInscribe ==============
typedef void (CALLBACK* VCSetRPolyInscribeFN) (short*, vbool);

void WINAPI VCSetRPolyInscribe (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRPolyInscribe");
	if (fp)
	{
		((VCSetRPolyInscribeFN)fp)(iError, tf);
	}
}

//============== VCSetRPolySides ==============
typedef void (CALLBACK* VCSetRPolySidesFN) (short*, short);

void WINAPI VCSetRPolySides (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRPolySides");
	if (fp)
	{
		((VCSetRPolySidesFN)fp)(iError, i);
	}
}

//============== VCSetRPolygonSides ==============
typedef void (CALLBACK* VCSetRPolygonSidesFN) (long);

void WINAPI VCSetRPolygonSides (long id)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRPolygonSides");
	if (fp)
	{
		((VCSetRPolygonSidesFN)fp)(id);
	}
}

//============== VCSetRadCopies ==============
typedef void (CALLBACK* VCSetRadCopiesFN) (short*, short);

void WINAPI VCSetRadCopies (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRadCopies");
	if (fp)
	{
		((VCSetRadCopiesFN)fp)(iError, i);
	}
}

//============== VCSetReadOnly ==============
typedef void (CALLBACK* VCSetReadOnlyFN) (short*, short);

void WINAPI VCSetReadOnly (short* iError, short iReadOnly)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetReadOnly");
	if (fp)
	{
		((VCSetReadOnlyFN)fp)(iError, iReadOnly);
	}
}

//============== VCSetRefFrame ==============
typedef void (CALLBACK* VCSetRefFrameFN) (short*, Point2D*, Point2D*);

void WINAPI VCSetRefFrame (short* iError, Point2D* dpLL, Point2D* dpUR)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRefFrame");
	if (fp)
	{
		((VCSetRefFrameFN)fp)(iError, dpLL, dpUR);
	}
}

//============== VCSetRefFrameColor ==============
typedef void (CALLBACK* VCSetRefFrameColorFN) (short*, short);

void WINAPI VCSetRefFrameColor (short* iError, short iC)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRefFrameColor");
	if (fp)
	{
		((VCSetRefFrameColorFN)fp)(iError, iC);
	}
}

//============== VCSetRefFrameDrawBoundary ==============
typedef void (CALLBACK* VCSetRefFrameDrawBoundaryFN) (short*, vbool);

void WINAPI VCSetRefFrameDrawBoundary (short* iError, vbool vb)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRefFrameDrawBoundary");
	if (fp)
	{
		((VCSetRefFrameDrawBoundaryFN)fp)(iError, vb);
	}
}

//============== VCSetRefFrameIsDataBound ==============
typedef void (CALLBACK* VCSetRefFrameIsDataBoundFN) (short*, BOOL);

void WINAPI VCSetRefFrameIsDataBound (short* iError, BOOL tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRefFrameIsDataBound");
	if (fp)
	{
		((VCSetRefFrameIsDataBoundFN)fp)(iError, tf);
	}
}

//============== VCSetRefFrameLineWidth ==============
typedef void (CALLBACK* VCSetRefFrameLineWidthFN) (short*, short);

void WINAPI VCSetRefFrameLineWidth (short* iError, short iC)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRefFrameLineWidth");
	if (fp)
	{
		((VCSetRefFrameLineWidthFN)fp)(iError, iC);
	}
}

//============== VCSetRefFrameName ==============
typedef void (CALLBACK* VCSetRefFrameNameFN) (short*, char*);

void WINAPI VCSetRefFrameName (short* iError, char* s)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRefFrameName");
	if (fp)
	{
		((VCSetRefFrameNameFN)fp)(iError, s);
	}
}

//============== VCSetRefFrameOffset ==============
typedef void (CALLBACK* VCSetRefFrameOffsetFN) (short*, Point2D*);

void WINAPI VCSetRefFrameOffset (short* iError, Point2D* dpOffset)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRefFrameOffset");
	if (fp)
	{
		((VCSetRefFrameOffsetFN)fp)(iError, dpOffset);
	}
}

//============== VCSetRefFrameRot ==============
typedef void (CALLBACK* VCSetRefFrameRotFN) (short*, double*);

void WINAPI VCSetRefFrameRot (short* iError, double* dR)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRefFrameRot");
	if (fp)
	{
		((VCSetRefFrameRotFN)fp)(iError, dR);
	}
}

//============== VCSetRefFrameScale ==============
typedef void (CALLBACK* VCSetRefFrameScaleFN) (short*, Point2D*);

void WINAPI VCSetRefFrameScale (short* iError, Point2D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRefFrameScale");
	if (fp)
	{
		((VCSetRefFrameScaleFN)fp)(iError, dpP);
	}
}

//============== VCSetRefFrameViewWidthHeight ==============
typedef void (CALLBACK* VCSetRefFrameViewWidthHeightFN) (short*, Point2D*);

void WINAPI VCSetRefFrameViewWidthHeight (short* iError, Point2D* dpWidthHeight)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRefFrameViewWidthHeight");
	if (fp)
	{
		((VCSetRefFrameViewWidthHeightFN)fp)(iError, dpWidthHeight);
	}
}

//============== VCSetReplaceWithSymbol ==============
typedef void (CALLBACK* VCSetReplaceWithSymbolFN) (short*, vbool);

void WINAPI VCSetReplaceWithSymbol (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetReplaceWithSymbol");
	if (fp)
	{
		((VCSetReplaceWithSymbolFN)fp)(iError, tf);
	}
}

//============== VCSetRubberBandColor ==============
typedef void (CALLBACK* VCSetRubberBandColorFN) (short*, short);

void WINAPI VCSetRubberBandColor (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetRubberBandColor");
	if (fp)
	{
		((VCSetRubberBandColorFN)fp)(iError, i);
	}
}

//============== VCSetSCRPath ==============
typedef void (CALLBACK* VCSetSCRPathFN) (short*, char*);

void WINAPI VCSetSCRPath (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSCRPath");
	if (fp)
	{
		((VCSetSCRPathFN)fp)(iError, szPath);
	}
}

//============== VCSetSYSPath ==============
typedef void (CALLBACK* VCSetSYSPathFN) (short*, char*);

void WINAPI VCSetSYSPath (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSYSPath");
	if (fp)
	{
		((VCSetSYSPathFN)fp)(iError, szPath);
	}
}

//============== VCSetSaveEnvOnExit ==============
typedef void (CALLBACK* VCSetSaveEnvOnExitFN) (short*, vbool);

void WINAPI VCSetSaveEnvOnExit (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSaveEnvOnExit");
	if (fp)
	{
		((VCSetSaveEnvOnExitFN)fp)(iError, tf);
	}
}

//============== VCSetSavePaths ==============
typedef void (CALLBACK* VCSetSavePathsFN) (short*, vbool);

void WINAPI VCSetSavePaths (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSavePaths");
	if (fp)
	{
		((VCSetSavePathsFN)fp)(iError, tf);
	}
}

//============== VCSetScale ==============
typedef void (CALLBACK* VCSetScaleFN) (short*, double);

void WINAPI VCSetScale (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetScale");
	if (fp)
	{
		((VCSetScaleFN)fp)(iError, dRet);
	}
}

//============== VCSetScaleX ==============
typedef void (CALLBACK* VCSetScaleXFN) (short*, double);

void WINAPI VCSetScaleX (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetScaleX");
	if (fp)
	{
		((VCSetScaleXFN)fp)(iError, dRet);
	}
}

//============== VCSetScaleXY ==============
typedef void (CALLBACK* VCSetScaleXYFN) (short*, Point2D);

void WINAPI VCSetScaleXY (short* iError, Point2D p)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetScaleXY");
	if (fp)
	{
		((VCSetScaleXYFN)fp)(iError, p);
	}
}

//============== VCSetScaleY ==============
typedef void (CALLBACK* VCSetScaleYFN) (short*, double);

void WINAPI VCSetScaleY (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetScaleY");
	if (fp)
	{
		((VCSetScaleYFN)fp)(iError, dRet);
	}
}

//============== VCSetSecondaryDistFormat ==============
typedef void (CALLBACK* VCSetSecondaryDistFormatFN) (short*, short);

void WINAPI VCSetSecondaryDistFormat (short* iError, short iF_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSecondaryDistFormat");
	if (fp)
	{
		((VCSetSecondaryDistFormatFN)fp)(iError, iF_);
	}
}

//============== VCSetSelectionColor ==============
typedef void (CALLBACK* VCSetSelectionColorFN) (short*, short);

void WINAPI VCSetSelectionColor (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSelectionColor");
	if (fp)
	{
		((VCSetSelectionColorFN)fp)(iError, i);
	}
}

//============== VCSetShiftClick ==============
typedef void (CALLBACK* VCSetShiftClickFN) (short*, vbool);

void WINAPI VCSetShiftClick (short* iError, vbool tfShift)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetShiftClick");
	if (fp)
	{
		((VCSetShiftClickFN)fp)(iError, tfShift);
	}
}

//============== VCSetShortLayerList ==============
typedef void (CALLBACK* VCSetShortLayerListFN) (short*, vbool);

void WINAPI VCSetShortLayerList (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetShortLayerList");
	if (fp)
	{
		((VCSetShortLayerListFN)fp)(iError, tf);
	}
}

//============== VCSetShowAngleSeconds ==============
typedef void (CALLBACK* VCSetShowAngleSecondsFN) (short*, vbool);

void WINAPI VCSetShowAngleSeconds (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetShowAngleSeconds");
	if (fp)
	{
		((VCSetShowAngleSecondsFN)fp)(iError, tf);
	}
}

//============== VCSetShowDimAngleSeconds ==============
typedef void (CALLBACK* VCSetShowDimAngleSecondsFN) (short*, vbool);

void WINAPI VCSetShowDimAngleSeconds (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetShowDimAngleSeconds");
	if (fp)
	{
		((VCSetShowDimAngleSecondsFN)fp)(iError, tf);
	}
}

//============== VCSetShowDrag ==============
typedef void (CALLBACK* VCSetShowDragFN) (short*, vbool);

void WINAPI VCSetShowDrag (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetShowDrag");
	if (fp)
	{
		((VCSetShowDragFN)fp)(iError, tf);
	}
}

//============== VCSetShowSecondaryUnit ==============
typedef void (CALLBACK* VCSetShowSecondaryUnitFN) (short*, vbool);

void WINAPI VCSetShowSecondaryUnit (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetShowSecondaryUnit");
	if (fp)
	{
		((VCSetShowSecondaryUnitFN)fp)(iError, tf);
	}
}

//============== VCSetShowSingleUnitFrac ==============
typedef void (CALLBACK* VCSetShowSingleUnitFracFN) (short*, vbool);

void WINAPI VCSetShowSingleUnitFrac (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetShowSingleUnitFrac");
	if (fp)
	{
		((VCSetShowSingleUnitFracFN)fp)(iError, tf);
	}
}

//============== VCSetShowTangentPoints ==============
typedef void (CALLBACK* VCSetShowTangentPointsFN) (short*, vbool);

void WINAPI VCSetShowTangentPoints (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetShowTangentPoints");
	if (fp)
	{
		((VCSetShowTangentPointsFN)fp)(iError, tf);
	}
}

//============== VCSetSnapPercentVal ==============
typedef void (CALLBACK* VCSetSnapPercentValFN) (short*, double);

void WINAPI VCSetSnapPercentVal (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSnapPercentVal");
	if (fp)
	{
		((VCSetSnapPercentValFN)fp)(iError, dRet);
	}
}

//============== VCSetSolid ==============
typedef void (CALLBACK* VCSetSolidFN) (short*, vbool);

void WINAPI VCSetSolid (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSolid");
	if (fp)
	{
		((VCSetSolidFN)fp)(iError, tf);
	}
}

//============== VCSetSpanAngle ==============
typedef void (CALLBACK* VCSetSpanAngleFN) (short*, double);

void WINAPI VCSetSpanAngle (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSpanAngle");
	if (fp)
	{
		((VCSetSpanAngleFN)fp)(iError, dRet);
	}
}

//============== VCSetSym3DName ==============
typedef void (CALLBACK* VCSetSym3DNameFN) (short*, char*);

void WINAPI VCSetSym3DName (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSym3DName");
	if (fp)
	{
		((VCSetSym3DNameFN)fp)(iError, sz);
	}
}

//============== VCSetSym3DNormal ==============
typedef void (CALLBACK* VCSetSym3DNormalFN) (short*, Point3D*);

void WINAPI VCSetSym3DNormal (short* iError, Point3D* normal)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSym3DNormal");
	if (fp)
	{
		((VCSetSym3DNormalFN)fp)(iError, normal);
	}
}

//============== VCSetSym3DRot ==============
typedef void (CALLBACK* VCSetSym3DRotFN) (short*, double);

void WINAPI VCSetSym3DRot (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSym3DRot");
	if (fp)
	{
		((VCSetSym3DRotFN)fp)(iError, dRet);
	}
}

//============== VCSetSym3DScale ==============
typedef void (CALLBACK* VCSetSym3DScaleFN) (short*, Point3D*);

void WINAPI VCSetSym3DScale (short* iError, Point3D* dpScale)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSym3DScale");
	if (fp)
	{
		((VCSetSym3DScaleFN)fp)(iError, dpScale);
	}
}

//============== VCSetSymAutoExplode ==============
typedef void (CALLBACK* VCSetSymAutoExplodeFN) (short*, vbool);

void WINAPI VCSetSymAutoExplode (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSymAutoExplode");
	if (fp)
	{
		((VCSetSymAutoExplodeFN)fp)(iError, tf);
	}
}

//============== VCSetSymExplode ==============
typedef void (CALLBACK* VCSetSymExplodeFN) (short*, short);

void WINAPI VCSetSymExplode (short* iError, short iEx)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSymExplode");
	if (fp)
	{
		((VCSetSymExplodeFN)fp)(iError, iEx);
	}
}

//============== VCSetSymName ==============
typedef void (CALLBACK* VCSetSymNameFN) (short*, char*);

void WINAPI VCSetSymName (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSymName");
	if (fp)
	{
		((VCSetSymNameFN)fp)(iError, sz);
	}
}

//============== VCSetSymRot ==============
typedef void (CALLBACK* VCSetSymRotFN) (short*, double);

void WINAPI VCSetSymRot (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSymRot");
	if (fp)
	{
		((VCSetSymRotFN)fp)(iError, dRet);
	}
}

//============== VCSetSymScale ==============
typedef void (CALLBACK* VCSetSymScaleFN) (short*, Point2D);

void WINAPI VCSetSymScale (short* iError, Point2D p)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSymScale");
	if (fp)
	{
		((VCSetSymScaleFN)fp)(iError, p);
	}
}

//============== VCSetSymScaleX ==============
typedef void (CALLBACK* VCSetSymScaleXFN) (short*, double);

void WINAPI VCSetSymScaleX (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSymScaleX");
	if (fp)
	{
		((VCSetSymScaleXFN)fp)(iError, dRet);
	}
}

//============== VCSetSymScaleY ==============
typedef void (CALLBACK* VCSetSymScaleYFN) (short*, double);

void WINAPI VCSetSymScaleY (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSymScaleY");
	if (fp)
	{
		((VCSetSymScaleYFN)fp)(iError, dRet);
	}
}

//============== VCSetSymSnap ==============
typedef void (CALLBACK* VCSetSymSnapFN) (short*, vbool);

void WINAPI VCSetSymSnap (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSymSnap");
	if (fp)
	{
		((VCSetSymSnapFN)fp)(iError, tf);
	}
}

//============== VCSetSymbolSection ==============
typedef void (CALLBACK* VCSetSymbolSectionFN) (short*, char*);

void WINAPI VCSetSymbolSection (short* iError, char* pName)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSymbolSection");
	if (fp)
	{
		((VCSetSymbolSectionFN)fp)(iError, pName);
	}
}

//============== VCSetTextAspect ==============
typedef void (CALLBACK* VCSetTextAspectFN) (short*, double);

void WINAPI VCSetTextAspect (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextAspect");
	if (fp)
	{
		((VCSetTextAspectFN)fp)(iError, dRet);
	}
}

//============== VCSetTextBold ==============
typedef void (CALLBACK* VCSetTextBoldFN) (short*, vbool);

void WINAPI VCSetTextBold (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextBold");
	if (fp)
	{
		((VCSetTextBoldFN)fp)(iError, tf);
	}
}

//============== VCSetTextCharSpace ==============
typedef void (CALLBACK* VCSetTextCharSpaceFN) (short*, double);

void WINAPI VCSetTextCharSpace (short* iError, double dCharSpacing)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextCharSpace");
	if (fp)
	{
		((VCSetTextCharSpaceFN)fp)(iError, dCharSpacing);
	}
}

//============== VCSetTextColor ==============
typedef void (CALLBACK* VCSetTextColorFN) (short*, short);

void WINAPI VCSetTextColor (short* iError, short i)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextColor");
	if (fp)
	{
		((VCSetTextColorFN)fp)(iError, i);
	}
}

//============== VCSetTextFontName ==============
typedef void (CALLBACK* VCSetTextFontNameFN) (short*, char*);

void WINAPI VCSetTextFontName (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextFontName");
	if (fp)
	{
		((VCSetTextFontNameFN)fp)(iError, sz);
	}
}

//============== VCSetTextHeight ==============
typedef void (CALLBACK* VCSetTextHeightFN) (short*, double);

void WINAPI VCSetTextHeight (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextHeight");
	if (fp)
	{
		((VCSetTextHeightFN)fp)(iError, dRet);
	}
}

//============== VCSetTextItalic ==============
typedef void (CALLBACK* VCSetTextItalicFN) (short*, vbool);

void WINAPI VCSetTextItalic (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextItalic");
	if (fp)
	{
		((VCSetTextItalicFN)fp)(iError, tf);
	}
}

//============== VCSetTextItalicValue ==============
typedef void (CALLBACK* VCSetTextItalicValueFN) (short*, double);

void WINAPI VCSetTextItalicValue (short* iError, double dI)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextItalicValue");
	if (fp)
	{
		((VCSetTextItalicValueFN)fp)(iError, dI);
	}
}

//============== VCSetTextJustify ==============
typedef void (CALLBACK* VCSetTextJustifyFN) (short*, short);

void WINAPI VCSetTextJustify (short* iError, short j)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextJustify");
	if (fp)
	{
		((VCSetTextJustifyFN)fp)(iError, j);
	}
}

//============== VCSetTextLayer ==============
typedef void (CALLBACK* VCSetTextLayerFN) (short*, short);

void WINAPI VCSetTextLayer (short* iError, short iTextLayer)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextLayer");
	if (fp)
	{
		((VCSetTextLayerFN)fp)(iError, iTextLayer);
	}
}

//============== VCSetTextLineSpace ==============
typedef void (CALLBACK* VCSetTextLineSpaceFN) (short*, double);

void WINAPI VCSetTextLineSpace (short* iError, double dLineSpacing)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextLineSpace");
	if (fp)
	{
		((VCSetTextLineSpaceFN)fp)(iError, dLineSpacing);
	}
}

//============== VCSetTextProSpacing ==============
typedef void (CALLBACK* VCSetTextProSpacingFN) (short*, vbool);

void WINAPI VCSetTextProSpacing (short* iError, vbool b)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextProSpacing");
	if (fp)
	{
		((VCSetTextProSpacingFN)fp)(iError, b);
	}
}

//============== VCSetTextRot ==============
typedef void (CALLBACK* VCSetTextRotFN) (short*, double);

void WINAPI VCSetTextRot (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextRot");
	if (fp)
	{
		((VCSetTextRotFN)fp)(iError, dRet);
	}
}

//============== VCSetTextString ==============
typedef void (CALLBACK* VCSetTextStringFN) (short*, char*);

void WINAPI VCSetTextString (short* iError, char* pS)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextString");
	if (fp)
	{
		((VCSetTextStringFN)fp)(iError, pS);
	}
}

//============== VCSetTextUnderline ==============
typedef void (CALLBACK* VCSetTextUnderlineFN) (short*, vbool);

void WINAPI VCSetTextUnderline (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextUnderline");
	if (fp)
	{
		((VCSetTextUnderlineFN)fp)(iError, tf);
	}
}

//============== VCSetTextUseByLayerProperties ==============
typedef void (CALLBACK* VCSetTextUseByLayerPropertiesFN) (short*, vbool, vbool, vbool);

void WINAPI VCSetTextUseByLayerProperties (short* iError, vbool tfColor, vbool tfLineType, vbool tfLineWidth)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextUseByLayerProperties");
	if (fp)
	{
		((VCSetTextUseByLayerPropertiesFN)fp)(iError, tfColor, tfLineType, tfLineWidth);
	}
}

//============== VCSetUseByLayerProperties ==============
typedef void (CALLBACK* VCSetUseByLayerPropertiesFN) (short*, vbool, vbool, vbool);

void WINAPI VCSetUseByLayerProperties (short* iError, vbool tfColor, vbool tfLineType, vbool tfLineWidth)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetUseByLayerProperties");
	if (fp)
	{
		((VCSetUseByLayerPropertiesFN)fp)(iError, tfColor, tfLineType, tfLineWidth);
	}
}

//============== VCSetUseFileLocking ==============
typedef void (CALLBACK* VCSetUseFileLockingFN) (short*, vbool);

void WINAPI VCSetUseFileLocking (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetUseFileLocking");
	if (fp)
	{
		((VCSetUseFileLockingFN)fp)(iError, tf);
	}
}

//============== VCSetUserDataName ==============
typedef void (CALLBACK* VCSetUserDataNameFN) (short*, char*);

void WINAPI VCSetUserDataName (short* iError, char* pS)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetUserDataName");
	if (fp)
	{
		((VCSetUserDataNameFN)fp)(iError, pS);
	}
}

//============== VCSetVCDPath ==============
typedef void (CALLBACK* VCSetVCDPathFN) (short*, char*);

void WINAPI VCSetVCDPath (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetVCDPath");
	if (fp)
	{
		((VCSetVCDPathFN)fp)(iError, szPath);
	}
}

//============== VCSetVCFPath ==============
typedef void (CALLBACK* VCSetVCFPathFN) (short*, char*);

void WINAPI VCSetVCFPath (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetVCFPath");
	if (fp)
	{
		((VCSetVCFPathFN)fp)(iError, szPath);
	}
}

//============== VCSetVCSPath ==============
typedef void (CALLBACK* VCSetVCSPathFN) (short*, char*);

void WINAPI VCSetVCSPath (short* iError, char* szPath)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetVCSPath");
	if (fp)
	{
		((VCSetVCSPathFN)fp)(iError, szPath);
	}
}

//============== VCSetVidTolerance ==============
typedef void (CALLBACK* VCSetVidToleranceFN) (short*, double);

void WINAPI VCSetVidTolerance (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetVidTolerance");
	if (fp)
	{
		((VCSetVidToleranceFN)fp)(iError, dRet);
	}
}

//============== VCSetView3D ==============
typedef void (CALLBACK* VCSetView3DFN) (short*, Point3D*, Point3D*);

void WINAPI VCSetView3D (short* iError, Point3D* dpEye, Point3D* dpTarget)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetView3D");
	if (fp)
	{
		((VCSetView3DFN)fp)(iError, dpEye, dpTarget);
	}
}

//============== VCSetWallWidth1 ==============
typedef void (CALLBACK* VCSetWallWidth1FN) (short*, double);

void WINAPI VCSetWallWidth1 (short* iError, double d1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetWallWidth1");
	if (fp)
	{
		((VCSetWallWidth1FN)fp)(iError, d1);
	}
}

//============== VCSetWallWidth2 ==============
typedef void (CALLBACK* VCSetWallWidth2FN) (short*, double);

void WINAPI VCSetWallWidth2 (short* iError, double d1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetWallWidth2");
	if (fp)
	{
		((VCSetWallWidth2FN)fp)(iError, d1);
	}
}

//============== VCSetWorldZoomAll ==============
typedef void (CALLBACK* VCSetWorldZoomAllFN) (short*);

void WINAPI VCSetWorldZoomAll (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetWorldZoomAll");
	if (fp)
	{
		((VCSetWorldZoomAllFN)fp)(iError);
	}
}

//============== VCSetWorldZoomWindow ==============
typedef void (CALLBACK* VCSetWorldZoomWindowFN) (short*, Point2D*, Point2D*);

void WINAPI VCSetWorldZoomWindow (short* iError, Point2D* p0, Point2D* p1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetWorldZoomWindow");
	if (fp)
	{
		((VCSetWorldZoomWindowFN)fp)(iError, p0, p1);
	}
}

//============== VCSetXYHandle ==============
typedef void (CALLBACK* VCSetXYHandleFN) (long);

void WINAPI VCSetXYHandle (long hWnd_)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetXYHandle");
	if (fp)
	{
		((VCSetXYHandleFN)fp)(hWnd_);
	}
}

//============== VCSetZoomFactor ==============
typedef void (CALLBACK* VCSetZoomFactorFN) (short*, double);

void WINAPI VCSetZoomFactor (short* iError, double dRet)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetZoomFactor");
	if (fp)
	{
		((VCSetZoomFactorFN)fp)(iError, dRet);
	}
}

//============== VCSethMenu ==============
typedef void (CALLBACK* VCSethMenuFN) (HMENU);

void WINAPI VCSethMenu (HMENU hMenu)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSethMenu");
	if (fp)
	{
		((VCSethMenuFN)fp)(hMenu);
	}
}

//============== VCSethWndFrame ==============
typedef void (CALLBACK* VCSethWndFrameFN) (long);

void WINAPI VCSethWndFrame (long hWnd)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSethWndFrame");
	if (fp)
	{
		((VCSethWndFrameFN)fp)(hWnd);
	}
}

//============== VCSethWndMdiClient ==============
typedef void (CALLBACK* VCSethWndMdiClientFN) (long);

void WINAPI VCSethWndMdiClient (long hWnd)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSethWndMdiClient");
	if (fp)
	{
		((VCSethWndMdiClientFN)fp)(hWnd);
	}
}

//============== VCSortCurrentHatchFillEntity ==============
typedef void (CALLBACK* VCSortCurrentHatchFillEntityFN) (short*);

void WINAPI VCSortCurrentHatchFillEntity (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSortCurrentHatchFillEntity");
	if (fp)
	{
		((VCSortCurrentHatchFillEntityFN)fp)(iError);
	}
}

//============== VCStringToAngle ==============
typedef void (CALLBACK* VCStringToAngleFN) (short*, double*, char*);

void WINAPI VCStringToAngle (short* iError, double* pD, char* pS)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCStringToAngle");
	if (fp)
	{
		((VCStringToAngleFN)fp)(iError, pD, pS);
	}
}

//============== VCStringToDist ==============
typedef void (CALLBACK* VCStringToDistFN) (short*, double*, char*);

void WINAPI VCStringToDist (short* iError, double* pD, char* pS)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCStringToDist");
	if (fp)
	{
		((VCStringToDistFN)fp)(iError, pD, pS);
	}
}

//============== VCTerminate ==============
typedef void (CALLBACK* VCTerminateFN) (void);

void WINAPI VCTerminate (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCTerminate");
	if (fp)
	{
		((VCTerminateFN)fp)();
	}
}

//============== VCThisNameIsCurrentUser ==============
typedef vbool (CALLBACK* VCThisNameIsCurrentUserFN) (char*);

vbool WINAPI VCThisNameIsCurrentUser (char* szName)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCThisNameIsCurrentUser");
	if (fp)
	{
		return ((VCThisNameIsCurrentUserFN)fp)(szName);
	}
	return vbRet;
}

//============== VCTimer ==============
typedef void (CALLBACK* VCTimerFN) (void);

void WINAPI VCTimer (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCTimer");
	if (fp)
	{
		((VCTimerFN)fp)();
	}
}

//============== VCToggle ==============
typedef void (CALLBACK* VCToggleFN) (WORD);

void WINAPI VCToggle (WORD id)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCToggle");
	if (fp)
	{
		((VCToggleFN)fp)(id);
	}
}

//============== VCTruncFrom ==============
typedef void (CALLBACK* VCTruncFromFN) (short*, ENTITYHANDLE);

void WINAPI VCTruncFrom (short* iError, ENTITYHANDLE StartHere)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCTruncFrom");
	if (fp)
	{
		((VCTruncFromFN)fp)(iError, StartHere);
	}
}

//============== VCUIOff ==============
typedef void (CALLBACK* VCUIOffFN) (void);

void WINAPI VCUIOff (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCUIOff");
	if (fp)
	{
		((VCUIOffFN)fp)();
	}
}

//============== VCUIOn ==============
typedef void (CALLBACK* VCUIOnFN) (void);

void WINAPI VCUIOn (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCUIOn");
	if (fp)
	{
		((VCUIOnFN)fp)();
	}
}

//============== VCUnloadUnusedSymDefs ==============
typedef void (CALLBACK* VCUnloadUnusedSymDefsFN) (short*);

void WINAPI VCUnloadUnusedSymDefs (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCUnloadUnusedSymDefs");
	if (fp)
	{
		((VCUnloadUnusedSymDefsFN)fp)(iError);
	}
}

//============== VCUpdateStatusBar ==============
typedef void (CALLBACK* VCUpdateStatusBarFN) (void);

void WINAPI VCUpdateStatusBar (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCUpdateStatusBar");
	if (fp)
	{
		((VCUpdateStatusBarFN)fp)();
	}
}

//============== VCWindowSelect ==============
typedef void (CALLBACK* VCWindowSelectFN) (Point2D*, Point2D*);

void WINAPI VCWindowSelect (Point2D* dpP0, Point2D* dpP1)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCWindowSelect");
	if (fp)
	{
		((VCWindowSelectFN)fp)(dpP0, dpP1);
	}
}

//============== VCWorld2DToScreen ==============
typedef void (CALLBACK* VCWorld2DToScreenFN) (short*, Point2D*, Point2D*);

void WINAPI VCWorld2DToScreen (short* iError, Point2D* dpWorld, Point2D* dpScreen)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCWorld2DToScreen");
	if (fp)
	{
		((VCWorld2DToScreenFN)fp)(iError, dpWorld, dpScreen);
	}
}

//============== VCWorld3DToView3D ==============
typedef void (CALLBACK* VCWorld3DToView3DFN) (short*, Point3D*, Point3D*);

void WINAPI VCWorld3DToView3D (short* iError, Point3D* dpWorld3D, Point3D* dpView3D)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCWorld3DToView3D");
	if (fp)
	{
		((VCWorld3DToView3DFN)fp)(iError, dpWorld3D, dpView3D);
	}
}

//============== VCWorld3DToWorld2D ==============
typedef void (CALLBACK* VCWorld3DToWorld2DFN) (short*, Point3D*, Point2D*);

void WINAPI VCWorld3DToWorld2D (short* iError, Point3D* dpWorld3D, Point2D* dpWorld2D)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCWorld3DToWorld2D");
	if (fp)
	{
		((VCWorld3DToWorld2DFN)fp)(iError, dpWorld3D, dpWorld2D);
	}
}

//============== VCZoomAll ==============
typedef void (CALLBACK* VCZoomAllFN) (void);

void WINAPI VCZoomAll (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCZoomAll");
	if (fp)
	{
		((VCZoomAllFN)fp)();
	}
}

//============== VCZoomAllViews ==============
typedef vbool (CALLBACK* VCZoomAllViewsFN) (short*);

vbool WINAPI VCZoomAllViews (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCZoomAllViews");
	if (fp)
	{
		return ((VCZoomAllViewsFN)fp)(iError);
	}
	return vbRet;
}

//============== VCZoomPrevious ==============
typedef void (CALLBACK* VCZoomPreviousFN) (void);

void WINAPI VCZoomPrevious (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCZoomPrevious");
	if (fp)
	{
		((VCZoomPreviousFN)fp)();
	}
}

//============== VCZoomRegen ==============
typedef void (CALLBACK* VCZoomRegenFN) (void);

void WINAPI VCZoomRegen (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCZoomRegen");
	if (fp)
	{
		((VCZoomRegenFN)fp)();
	}
}

//============== VCZoomRegenAllViews ==============
typedef vbool (CALLBACK* VCZoomRegenAllViewsFN) (short*);

vbool WINAPI VCZoomRegenAllViews (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCZoomRegenAllViews");
	if (fp)
	{
		return ((VCZoomRegenAllViewsFN)fp)(iError);
	}
	return vbRet;
}

//============== VCZoomSelected ==============
typedef void (CALLBACK* VCZoomSelectedFN) (void);

void WINAPI VCZoomSelected (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCZoomSelected");
	if (fp)
	{
		((VCZoomSelectedFN)fp)();
	}
}

//============== VCZoomView ==============
typedef void (CALLBACK* VCZoomViewFN) (char*);

void WINAPI VCZoomView (char* szView)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCZoomView");
	if (fp)
	{
		((VCZoomViewFN)fp)(szView);
	}
}

//============== VComputeSplineTangentPoints ==============
typedef void (CALLBACK* VComputeSplineTangentPointsFN) (short*, Point2D*, short, Point2D*, short*);

void WINAPI VComputeSplineTangentPoints (short* iError, Point2D* pInput, short iCount, Point2D* pOutput, short* iOutCount)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VComputeSplineTangentPoints");
	if (fp)
	{
		((VComputeSplineTangentPointsFN)fp)(iError, pInput, iCount, pOutput, iOutCount);
	}
}


// ========================================================================
// ========================================================================
//
//
// New VCADD API calls for V3 - untested and undocumented - use at own risk 
//
//
// ========================================================================
// ========================================================================
//
//
//============== VCGetDisplayPointString ==============
typedef short (CALLBACK* VCGetDisplayPointStringFN) (short*, char*);

short WINAPI VCGetDisplayPointString (short* iError, char* szPoint)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayPointString");
	if (fp)
	{
		return ((VCGetDisplayPointStringFN)fp)(iError, szPoint);
	}
	return iRet;
}

//============== VCGetDisplayAngleString ==============
typedef short (CALLBACK* VCGetDisplayAngleStringFN) (short*, char*);

short WINAPI VCGetDisplayAngleString (short* iError, char* szAngle)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayAngleString");
	if (fp)
	{
		return ((VCGetDisplayAngleStringFN)fp)(iError, szAngle);
	}
	return iRet;
}

//============== VCGetDisplayLengthString ==============
typedef short (CALLBACK* VCGetDisplayLengthStringFN) (short*, char*);

short WINAPI VCGetDisplayLengthString (short* iError, char* szLength)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDisplayLengthString");
	if (fp)
	{
		((VCGetDisplayLengthStringFN)fp)(iError, szLength);
	}
	return iRet;
}

//============== VCGetSelectionCount ==============
typedef long (CALLBACK* VCGetSelectionCountFN) (short*);

long WINAPI VCGetSelectionCount (short* iError)
{
	long lRet;
	lRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetSelectionCount");
	if (fp)
	{
		return ((VCGetSelectionCountFN)fp)(iError);
	}
	return lRet;
}

//============== VCGetCommandString ==============
typedef short (CALLBACK* VCGetCommandStringFN) (WORD, short, char*);

short WINAPI VCGetCommandString (WORD id, short iIndex, char* szIn)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetCommandString");
	if (fp)
	{
		return ((VCGetCommandStringFN)fp)(id, iIndex, szIn);
	}
	return iRet;
}

//============== VCSetCurrWorldByHWND ==============
typedef WORLDHANDLE (CALLBACK* VCSetCurrWorldByHWNDFN) (short*, HWND);

WORLDHANDLE WINAPI VCSetCurrWorldByHWND (short* iError, HWND hWnd)
{
	WORLDHANDLE iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCurrWorldByHWND");
	if (fp)
	{
		return ((VCSetCurrWorldByHWNDFN)fp)(iError, hWnd);
	}
	return iRet;
}

//============== VCFirstWorld ==============
typedef vbool (CALLBACK* VCFirstWorldFN) (short*);

vbool WINAPI VCFirstWorld (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCFirstWorld");
	if (fp)
	{
		return ((VCFirstWorldFN)fp)(iError);
	}
	return vbRet;
}

//============== VCNextWorld ==============
typedef vbool (CALLBACK* VCNextWorldFN) (short*);

vbool WINAPI VCNextWorld (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCNextWorld");
	if (fp)
	{
		return ((VCNextWorldFN)fp)(iError);
	}
	return vbRet;
}

//============== VCOnActivateView ==============
typedef void (CALLBACK* VCOnActivateViewFN) (short*, HWND, vbool);

void WINAPI VCOnActivateView (short* iError, HWND hActiveWnd, vbool tfEatLButtonDown)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCOnActivateView");
	if (fp)
	{
		((VCOnActivateViewFN)fp)(iError, hActiveWnd, tfEatLButtonDown);
	}
}

//============== VCScreenToWorld2D ==============
typedef void (CALLBACK* VCScreenToWorld2DFN) (short*, iPoint2D, Point2D*);

void WINAPI VCScreenToWorld2D (short* iError, iPoint2D ipScreen, Point2D* dpWorld)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCScreenToWorld2D");
	if (fp)
	{
		((VCScreenToWorld2DFN)fp)(iError, ipScreen, dpWorld);
	}
}

//============== VCScrollStart ==============
typedef void (CALLBACK* VCScrollStartFN) (short*);

void WINAPI VCScrollStart (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCScrollStart");
	if (fp)
	{
		((VCScrollStartFN)fp)(iError);
	}
}

//============== VCScrollEnd ==============
typedef void (CALLBACK* VCScrollEndFN) (short*);

void WINAPI VCScrollEnd (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCScrollEnd");
	if (fp)
	{
		((VCScrollEndFN)fp)(iError);
	}
}

//============== VCOnScroll ==============
typedef void (CALLBACK* VCOnScrollFN) (short*,  UINT, UINT, UINT);

void WINAPI VCOnScroll (short* iError, UINT uWhichScroll, UINT nSBCode, UINT nPos)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCOnScroll");
	if (fp)
	{
		((VCOnScrollFN)fp)(iError, uWhichScroll, nSBCode, nPos);
	}
}

//============== VCOnTimerRunningSnap ==============
typedef void (CALLBACK* VCOnTimerRunningSnapFN) (void);

void WINAPI VCOnTimerRunningSnap (void)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCOnTimerRunningSnap");
	if (fp)
	{
		((VCOnTimerRunningSnapFN)fp)();
	}
}

//============== VCLayerSelect ==============
typedef void (CALLBACK* VCLayerSelectFN) (short*, short, vbool);

void WINAPI VCLayerSelect (short* iError, short iLayer, vbool tfSelect)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCLayerSelect");
	if (fp)
	{
		((VCLayerSelectFN)fp)(iError, iLayer, tfSelect);
	}
}

//============== VCSetCursorEx ==============
typedef void (CALLBACK* VCSetCursorExFN) (short*, HCURSOR);

void WINAPI VCSetCursorEx (short* iError, HCURSOR hC)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetCursorEx");
	if (fp)
	{
		((VCSetCursorExFN)fp)(iError, hC);
	}
}

//============== VCGetTextUseTextLayer ==============
typedef vbool (CALLBACK* VCGetTextUseTextLayerFN) (short*);

vbool WINAPI VCGetTextUseTextLayer (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetTextUseTextLayer");
	if (fp)
	{
		return ((VCGetTextUseTextLayerFN)fp)(iError);
	}
	return vbRet; 
}

//============== VCSetTextUseTextLayer ==============

typedef void (CALLBACK* VCSetTextUseTextLayerFN) (short*, vbool);

void WINAPI VCSetTextUseTextLayer (short* iError, vbool tfUseTextLayer)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetTextUseTextLayer");
	if (fp)
	{
		((VCSetTextUseTextLayerFN)fp)(iError, tfUseTextLayer);
	}
}

//============== VCGetProgramPath ==============
typedef short (CALLBACK* VCGetProgramPathFN) (short*, char*);

short WINAPI VCGetProgramPath(short* iError, char* szPath)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetProgramPath");
	if (fp)
	{
		return ((VCGetProgramPathFN)fp)(iError, szPath);
	}
	return iRet;
}


// ========================================================================
// ========================================================================
//
//
// New VCADD API calls for V3.x bug fix - added "by pointer" calls
//
//
// ========================================================================
// ========================================================================
//
//
//============== VCCreateSymbolFromSelectionBP ==============
typedef void (CALLBACK* VCCreateSymbolFromSelectionFN) (short*, char*, Point2D);

void WINAPI VCCreateSymbolFromSelectionBP (short* iError, char* szName, Point2D* dpP)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCCreateSymbolFromSelection");
	if (fp)
	{
		((VCCreateSymbolFromSelectionFN)fp)(iError, szName, *dpP);
	}
}

//============== VCDigPointBP ==============
typedef void (CALLBACK* VCDigPointFN) (lPoint2D, short, short);

void WINAPI VCDigPointBP (lPoint2D* lpt, short bButtonNum, short bButtonState)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDigPoint");
	if (fp)
	{
		((VCDigPointFN)fp)(*lpt, bButtonNum, bButtonState);
	}
}

//============== VCGetDatumBasePtBP ==============
typedef Point2D (CALLBACK* VCGetDatumBasePtFN) (short*);

void WINAPI VCGetDatumBasePtBP (short* iError, Point2D* dpRet)
{
	dpRet->x = dpRet->y = 0.0;

	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetDatumBasePt");
	if (fp)
	{
		*dpRet = ((VCGetDatumBasePtFN)fp)(iError);
	}
	return;
}

//============== VCMouseMoveWorldPointBP ==============
typedef void (CALLBACK* VCMouseMoveWorldPointFN) (Point2D);

void WINAPI VCMouseMoveWorldPointBP (Point2D* dpW)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCMouseMoveWorldPoint");
	if (fp)
	{
		((VCMouseMoveWorldPointFN)fp)(*dpW);
	}
}

//============== VCPaintBP ==============
typedef void (CALLBACK* VCPaintFN) (long, RECT);

void WINAPI VCPaintBP (long hWnd, RECT* rc)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCPaint");
	if (fp)
	{
		((VCPaintFN)fp)(hWnd, *rc);
	}
}

//============== VCScreenToWorld2DBP ==============
typedef void (CALLBACK* VCScreenToWorld2DFN) (short*, iPoint2D, Point2D*);

void WINAPI VCScreenToWorld2DBP (short* iError, iPoint2D* ipScreen, Point2D* dpWorld)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCScreenToWorld2D");
	if (fp)
	{
		((VCScreenToWorld2DFN)fp)(iError, *ipScreen, dpWorld);
	}
}

//============== VCSetDatumBasePtBP ==============
typedef void (CALLBACK* VCSetDatumBasePtFN) (short*, Point2D);

void WINAPI VCSetDatumBasePtBP (short* iError, Point2D* p)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetDatumBasePt");
	if (fp)
	{
		((VCSetDatumBasePtFN)fp)(iError, *p);
	}
}

//============== VCSetScaleXYBP ==============
typedef void (CALLBACK* VCSetScaleXYFN) (short*, Point2D);

void WINAPI VCSetScaleXYBP (short* iError, Point2D* p)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetScaleXY");
	if (fp)
	{
		((VCSetScaleXYFN)fp)(iError, *p);
	}
}

//============== VCSetSymScaleBP ==============
typedef void (CALLBACK* VCSetSymScaleFN) (short*, Point2D);

void WINAPI VCSetSymScaleBP (short* iError, Point2D* p)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetSymScale");
	if (fp)
	{
		((VCSetSymScaleFN)fp)(iError, *p);
	}
}

// ========================================================================
// ========================================================================
//
//
// New VCADD API calls for V3.x bug fix - added missing calls
//
//
// ========================================================================
// ========================================================================
//
//
//
//============== VCGetManualEntryMode ==============
typedef short (CALLBACK* VCGetManualEntryModeFN) (short*);

short WINAPI VCGetManualEntryMode(short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetManualEntryMode");
	if (fp)
	{
		return ((VCGetManualEntryModeFN)fp)(iError);
	}
	return 0;
}

// ========================================================================
// ========================================================================
//
//
// New VCADD API calls for V3.x bug fix - added new Layer Group calls
//
//
// ========================================================================
// ========================================================================
//
//
//
//============== VCApplyLayerGroupByIndex ==============
typedef void (CALLBACK* VCApplyLayerGroupByIndexFN) (short*, short);

void WINAPI VCApplyLayerGroupByIndex(short* iError, short iGroupIndex)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCApplyLayerGroupByIndex");
	if (fp)
	{
		((VCApplyLayerGroupByIndexFN)fp)(iError, iGroupIndex);
	}
}

//============== VCApplyLayerGroupByName ==============
typedef void (CALLBACK* VCApplyLayerGroupByNameFN) (short*, char*);

void WINAPI VCApplyLayerGroupByName(short* iError, char* szGroupName)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCApplyLayerGroupByName");
	if (fp)
	{
		((VCApplyLayerGroupByNameFN)fp)(iError, szGroupName);
	}
}

//============== VCGetLayerGroupName ==============
typedef short (CALLBACK* VCGetLayerGroupNameFN) (short*, short, char*);

short WINAPI VCGetLayerGroupName(short* iError, short iGroupIndex, char* szGroupName)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerGroupName");
	if (fp)
	{
		return ((VCGetLayerGroupNameFN)fp)(iError, iGroupIndex, szGroupName);
	}

	return 0;
}

//============== VCGetLayerGroupIndex ==============
typedef short (CALLBACK* VCGetLayerGroupIndexFN) (short* iError, char*);

short WINAPI VCGetLayerGroupIndex(short* iError, char* szGroupName)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerGroupIndex");
	if (fp)
	{
		return ((VCGetLayerGroupIndexFN)fp)(iError, szGroupName);
	}

	return 0;
}

//============== VCGetLayerGroupCount ==============
typedef short (CALLBACK* VCGetLayerGroupCountFN) (short*);

short WINAPI VCGetLayerGroupCount(short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerGroupCount");
	if (fp)
	{
		return ((VCGetLayerGroupCountFN)fp)(iError);
	}

	return 0;
}

//============== VCAddLayerGroup ==============
typedef short (CALLBACK* VCAddLayerGroupFN) (short*, char*);

short WINAPI VCAddLayerGroup(short* iError, char* szGroupName)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCAddLayerGroup");
	if (fp)
	{
		return ((VCAddLayerGroupFN)fp)(iError, szGroupName);
	}

	return 0;
}

//============== VCDeleteLayerGroup ==============
typedef void (CALLBACK* VCDeleteLayerGroupFN) (short*, short);

void WINAPI VCDeleteLayerGroup(short* iError, short iGroupIndex)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCDeleteLayerGroup");
	if (fp)
	{
		((VCDeleteLayerGroupFN)fp)(iError, iGroupIndex);
	}
}

//============== VCGetLayerGroupLayer ==============
typedef vbool (CALLBACK* VCGetLayerGroupLayerFN) (short*, short, short);

vbool WINAPI VCGetLayerGroupLayer(short* iError, short iGroupIndex, short iLayer)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCGetLayerGroupLayer");
	if (fp)
	{
		return ((VCGetLayerGroupLayerFN)fp)(iError, iGroupIndex, iLayer);
	}

	return FALSE;
}

//============== VCSetLayerGroupLayer ==============
typedef void (CALLBACK* VCSetLayerGroupLayerFN) (short*, short, short, vbool);

void WINAPI VCSetLayerGroupLayer(short* iError, short iGroupIndex, short iLayer, vbool bState)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"VCSetLayerGroupLayer");
	if (fp)
	{
		((VCSetLayerGroupLayerFN)fp)(iError, iGroupIndex, iLayer, bState);
	}
}

//============== GetLayerPrintable ==============
typedef vbool (CALLBACK* GetLayerPrintableFN) (short*, short);

vbool WINAPI VCGetLayerPrintable(short* iError, short iLayer)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"GetLayerPrintable");
	if (fp)
	{
		return ((GetLayerPrintableFN)fp)(iError, iLayer);
	}

	return FALSE;
}

//============== SetLayerPrintable ==============
typedef void (CALLBACK* SetLayerPrintableFN) (short*, short, vbool);

void WINAPI VCSetLayerPrintable(short* iError, short iLayer, vbool tfPrintableFlag)
{
	FARPROC fp = GetProcAddress(hInstVCMAIN32 , (LPSTR)"SetLayerPrintable");
	if (fp)
	{
		((SetLayerPrintableFN)fp)(iError, iLayer, tfPrintableFlag);
	}
}
